/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.security;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Set;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveDataEnhancer {
    private static final Logger log = LoggerFactory.getLogger(SensitiveDataEnhancer.class);
    public static final String AES_KEY = "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt";
    private static final String AES_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final Pattern DIGITS_ONLY_PATTERN = Pattern.compile("\\D");
    private static final Pattern PHONE_FORMAT_PATTERN = Pattern.compile("\\d+");
    private static final Pattern ID_NUMBER_PATTERN = Pattern.compile("\\d{6}\\d{8}[\\dXx]");
    private static final Set<String> NAME_STRATEGIES = Set.of("name", "\u59d3\u540d", "\u7528\u6237\u540d");
    private static final Set<String> PHONE_STRATEGIES = Set.of("phone", "mobile", "\u624b\u673a", "\u7535\u8bdd");
    private static final Set<String> ADDRESS_STRATEGIES = Set.of("address", "addr", "\u5730\u5740", "\u4f4f\u5740");
    private static final Set<String> ID_STRATEGIES = Set.of("idnumber", "idcard", "\u8eab\u4efd\u8bc1", "\u8bc1\u4ef6\u53f7");

    public static String applyMaskingStrategy(String fieldName, String originalValue, String strategy) {
        if (originalValue == null || originalValue.isEmpty()) {
            return originalValue;
        }
        String actualStrategy = strategy != null ? strategy : SensitiveDataEnhancer.inferStrategy(fieldName);
        try {
            return switch (actualStrategy.toLowerCase()) {
                case "name" -> SensitiveDataEnhancer.maskUserName(originalValue);
                case "phone", "mobile" -> SensitiveDataEnhancer.maskPhone(originalValue);
                case "address", "addr" -> SensitiveDataEnhancer.maskAddress(originalValue);
                case "idnumber", "idcard" -> SensitiveDataEnhancer.maskIdNumber(originalValue);
                default -> SensitiveDataEnhancer.maskDefault(originalValue);
            };
        }
        catch (Exception e) {
            log.error("\u8131\u654f\u5904\u7406\u5931\u8d25: {}, \u7b56\u7565: {}", new Object[]{fieldName, actualStrategy, e});
            return "**MASKED**";
        }
    }

    private static String inferStrategy(String fieldName) {
        block16: {
            block14: {
                String lowerFieldName;
                block15: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            lowerFieldName = fieldName.toLowerCase();
                                            if (NAME_STRATEGIES.stream().anyMatch(lowerFieldName::contains)) break block8;
                                            if (!Set.of("username", "realname", "nickname").stream().anyMatch(lowerFieldName::contains)) break block9;
                                        }
                                        return "name";
                                    }
                                    if (PHONE_STRATEGIES.stream().anyMatch(lowerFieldName::contains)) break block10;
                                    if (!Set.of("tel", "telephone").stream().anyMatch(lowerFieldName::contains)) break block11;
                                }
                                return "phone";
                            }
                            if (ADDRESS_STRATEGIES.stream().anyMatch(lowerFieldName::contains)) break block12;
                            if (!Set.of("location").stream().anyMatch(lowerFieldName::contains)) break block13;
                        }
                        return "address";
                    }
                    if (ID_STRATEGIES.stream().anyMatch(lowerFieldName::contains)) break block14;
                    if (!lowerFieldName.contains("id")) break block15;
                    if (Set.of("number", "card").stream().anyMatch(lowerFieldName::contains)) break block14;
                }
                if (!Set.of("cardnumber").stream().anyMatch(lowerFieldName::contains)) break block16;
            }
            return "idnumber";
        }
        return "default";
    }

    private static String maskUserName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        int length = name.length();
        return switch (length) {
            case 1 -> name;
            case 2 -> "*" + name.charAt(1);
            default -> name.charAt(0) + "*".repeat(length - 2) + name.charAt(length - 1);
        };
    }

    private static String maskPhone(String phone) {
        if (phone == null || phone.isEmpty()) {
            return phone;
        }
        String digitsOnly = DIGITS_ONLY_PATTERN.matcher(phone).replaceAll("");
        int length = digitsOnly.length();
        if (length < 4) {
            return phone;
        }
        return switch (length) {
            case 4, 5, 6, 7 -> {
                String prefix = digitsOnly.substring(0, 2);
                String suffix = digitsOnly.substring(length - 1);
                yield PHONE_FORMAT_PATTERN.matcher(phone).replaceAll(prefix + "*".repeat(length - 3) + suffix);
            }
            case 8, 9, 10, 11 -> {
                String prefix = digitsOnly.substring(0, 3);
                String suffix = digitsOnly.substring(length - 2);
                yield PHONE_FORMAT_PATTERN.matcher(phone).replaceAll(prefix + "****" + suffix);
            }
            default -> {
                String prefix = digitsOnly.substring(0, 3);
                String suffix = digitsOnly.substring(length - 4);
                yield PHONE_FORMAT_PATTERN.matcher(phone).replaceAll(prefix + "****" + suffix);
            }
        };
    }

    private static String maskIdNumber(String idNumber) {
        if (idNumber == null || idNumber.isEmpty()) {
            return idNumber;
        }
        return switch (idNumber.length()) {
            case 15 -> idNumber.substring(0, 6) + "*".repeat(6) + idNumber.substring(12);
            case 18 -> {
                if (ID_NUMBER_PATTERN.matcher(idNumber).matches()) {
                    yield idNumber.substring(0, 6) + "*".repeat(8) + idNumber.substring(14);
                }
                yield idNumber.substring(0, 6) + "*".repeat(8) + idNumber.substring(14);
            }
            default -> idNumber.length() >= 10 ? idNumber.substring(0, 6) + "*".repeat(Math.min(8, idNumber.length() - 10)) + idNumber.substring(Math.max(6, idNumber.length() - 4)) : idNumber;
        };
    }

    private static String maskAddress(String address) {
        if (address == null || address.isEmpty()) {
            return address;
        }
        int length = address.length();
        return switch (length) {
            case 1, 2, 3 -> address;
            case 4, 5, 6 -> address.substring(0, 2) + "***";
            case 7, 8, 9, 10 -> address.substring(0, 3) + "***" + address.substring(length - 2);
            default -> address.substring(0, 4) + "***" + address.substring(length - 3);
        };
    }

    private static String maskDefault(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int length = value.length();
        return switch (length) {
            case 1, 2 -> "*".repeat(length);
            case 3, 4, 5, 6 -> value.charAt(0) + "*".repeat(length - 2) + value.charAt(length - 1);
            default -> value.substring(0, 2) + "*".repeat(length - 4) + value.substring(length - 2);
        };
    }

    private static boolean matchesStrategy(String fieldName, Set<String> strategies) {
        return strategies.stream().anyMatch(fieldName::contains);
    }

    private static boolean isValidInput(String input) {
        return input == null || input.trim().isEmpty();
    }

    public static String generateSHA256Hash(String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (Exception e) {
            log.error("\u751f\u6210SHA256\u54c8\u5e0c\u5931\u8d25: \u8f93\u5165\u957f\u5ea6=" + input.length(), (Throwable)e);
            return null;
        }
    }

    public static String aesEncrypt(String input) throws Exception {
        if (SensitiveDataEnhancer.isValidInput(input)) {
            return null;
        }
        SecretKeySpec keySpec = new SecretKeySpec(AES_KEY.getBytes(StandardCharsets.UTF_8), "AES");
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(1, keySpec);
        byte[] encryptedBytes = cipher.doFinal(input.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static String aesDecrypt(String encrypted) throws Exception {
        if (SensitiveDataEnhancer.isValidInput(encrypted)) {
            return null;
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(AES_KEY.getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(2, keySpec);
            byte[] encryptedBytes = Base64.getDecoder().decode(encrypted);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.error("AES\u89e3\u5bc6\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u6570\u636e\u683c\u5f0f\u9519\u8bef\u6216\u5bc6\u94a5\u4e0d\u5339\u914d", (Throwable)e);
            throw e;
        }
    }

    public static SensitiveProcessResult processSensitiveField(String fieldName, String originalValue, String maskStrategy) {
        if (SensitiveDataEnhancer.isValidInput(originalValue)) {
            return null;
        }
        try {
            String hashValue = SensitiveDataEnhancer.generateSHA256Hash(originalValue);
            String encryptedValue = SensitiveDataEnhancer.aesEncrypt(originalValue);
            String maskedValue = SensitiveDataEnhancer.applyMaskingStrategy(fieldName, originalValue, maskStrategy);
            if (hashValue != null && encryptedValue != null && maskedValue != null) {
                return new SensitiveProcessResult(hashValue, encryptedValue, maskedValue);
            }
            log.warn("\u654f\u611f\u5b57\u6bb5\u5904\u7406\u90e8\u5206\u5931\u8d25: {}, hash={}, encrypted={}, masked={}", new Object[]{fieldName, hashValue != null, encryptedValue != null, maskedValue != null});
            return null;
        }
        catch (Exception e) {
            log.error("\u654f\u611f\u5b57\u6bb5\u5904\u7406\u5931\u8d25: {}", (Object)fieldName, (Object)e);
            return null;
        }
    }

    public record SensitiveProcessResult(String hashValue, String encryptedValue, String maskedValue) {
        public SensitiveProcessResult {
            if (hashValue == null || encryptedValue == null || maskedValue == null) {
                throw new IllegalArgumentException("\u6240\u6709\u5b57\u6bb5\u90fd\u4e0d\u80fd\u4e3anull");
            }
        }

        public boolean isValid() {
            return !this.hashValue.isBlank() && !this.encryptedValue.isBlank() && !this.maskedValue.isBlank();
        }

        public static SensitiveProcessResult empty() {
            return new SensitiveProcessResult("", "", "");
        }
    }

    public record SensitiveDataResult(String tableName, JSONObject data, String relationField) {
        public SensitiveDataResult {
            if (tableName == null || tableName.isBlank()) {
                throw new IllegalArgumentException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (relationField == null || relationField.isBlank()) {
                throw new IllegalArgumentException("\u5173\u8054\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            tableName = tableName.trim();
            relationField = relationField.trim();
        }

        public boolean hasData() {
            return this.data != null && !this.data.isEmpty();
        }

        public boolean isEmpty() {
            return !this.hasData();
        }

        public int dataSize() {
            return this.hasData() ? this.data.length() : 0;
        }

        public String getDataSummary() {
            if (!this.hasData()) {
                return "\u65e0\u6570\u636e";
            }
            return "\u5305\u542b" + this.data.length() + "\u4e2a\u5b57\u6bb5\u7684\u52a0\u5bc6\u6570\u636e";
        }

        public static SensitiveDataResult empty(String tableName, String relationField) {
            return new SensitiveDataResult(tableName, null, relationField);
        }

        public static SensitiveDataResult of(String tableName, JSONObject data, String relationField) {
            return new SensitiveDataResult(tableName, data, relationField);
        }

        public SensitiveDataResult withData(JSONObject newData) {
            return new SensitiveDataResult(this.tableName, newData, this.relationField);
        }

        @Override
        public String toString() {
            return "SensitiveDataResult{\n    tableName='" + this.tableName + "',\n    relationField='" + this.relationField + "',\n    data=" + this.getDataSummary() + "\n}\n";
        }
    }
}

