/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.other;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class SHA1Tools {
    public static String sha1(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] hash = sha1.digest(data.getBytes(StandardCharsets.UTF_8));
            return SHA1Tools.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    public static String sha1Hex(String data) {
        return SHA1Tools.sha1(data);
    }

    public static String sha1Base64(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] hash = sha1.digest(data.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    public static byte[] sha1Bytes(String data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            return sha1.digest(data.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    public static String sha1FromBytes(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] hash = sha1.digest(data);
            return SHA1Tools.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    public static boolean verify(String data, String hash) {
        if (data == null || hash == null) {
            return false;
        }
        return hash.equals(SHA1Tools.sha1(data));
    }

    public static boolean verifyBase64(String data, String base64Hash) {
        if (data == null || base64Hash == null) {
            return false;
        }
        return base64Hash.equals(SHA1Tools.sha1Base64(data));
    }

    public static String sha1WithSalt(String data, String salt) {
        if (data == null || salt == null) {
            return null;
        }
        return SHA1Tools.sha1(data + salt);
    }

    public static String sha1HMAC(String data, String key) {
        if (data == null || key == null) {
            return null;
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
            byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
            if (keyBytes.length > 64) {
                sha1.update(keyBytes);
                keyBytes = sha1.digest();
                sha1.reset();
            }
            byte[] ipad = new byte[64];
            byte[] opad = new byte[64];
            System.arraycopy(keyBytes, 0, ipad, 0, keyBytes.length);
            System.arraycopy(keyBytes, 0, opad, 0, keyBytes.length);
            int i = 0;
            while (i < 64) {
                int n = i;
                ipad[n] = (byte)(ipad[n] ^ 0x36);
                int n2 = i++;
                opad[n2] = (byte)(opad[n2] ^ 0x5C);
            }
            sha1.update(ipad);
            sha1.update(dataBytes);
            byte[] innerHash = sha1.digest();
            sha1.reset();
            sha1.update(opad);
            sha1.update(innerHash);
            byte[] hmac = sha1.digest();
            return SHA1Tools.bytesToHex(hmac);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    public static String hashFile(byte[] fileData) {
        return SHA1Tools.sha1FromBytes(fileData);
    }

    public static String hashFileBase64(byte[] fileData) {
        if (fileData == null || fileData.length == 0) {
            return null;
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] hash = sha1.digest(fileData);
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1\u7b97\u6cd5\u4e0d\u53ef\u7528", e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }
}

