/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.concurrent;

import com.af.v4.system.common.core.context.GlobalVisualThreadContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTaskProcessor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchTaskProcessor.class);

    protected int calculateChunkSize(int listSize, TaskType taskType) {
        int availableCores = 4;
        int result = taskType == TaskType.CPU_INTENSIVE ? Math.max(1, listSize / (availableCores + 1)) : Math.max(1, listSize / (availableCores * 2 + 1));
        return result;
    }

    public <V> JSONObject process(List<T> items, TaskType taskType, Function<T, V> taskHandler, Function<List<T>, List<T>> preProcessor, BiConsumer<T, V> successCallback, BiConsumer<T, Exception> failureCallback) {
        int chunkSize = this.calculateChunkSize(items.size(), taskType);
        List<T> processedItems = preProcessor != null ? preProcessor.apply(items) : items;
        List<List<T>> chunks = this.splitList(processedItems, chunkSize);
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        JSONObject result = new JSONObject();
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger failureCount = new AtomicInteger(0);
        Executor executor = GlobalVisualThreadContext.getAsyncVirtualExecutor();
        for (List chunk : chunks) {
            CompletableFuture future = GlobalVisualThreadContext.runAsync(() -> {
                for (Object item : chunk) {
                    try {
                        Object resultValue = taskHandler.apply(item);
                        successCount.incrementAndGet();
                        if (successCallback == null) continue;
                        successCallback.accept(item, resultValue);
                    }
                    catch (Exception e) {
                        failureCount.incrementAndGet();
                        if (failureCallback != null) {
                            failureCallback.accept(item, e);
                        }
                        LOGGER.error("Error processing task: {}", item, (Object)e);
                    }
                }
            });
            futures.add(future);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        result.put("totalItems", processedItems.size());
        result.put("chunkSize", chunkSize);
        result.put("totalChunks", chunks.size());
        result.put("successCount", successCount.get());
        result.put("failureCount", failureCount.get());
        LOGGER.info("Batch task processing completed: {}", (Object)result);
        return result;
    }

    public <V> JSONObject process(List<T> items, Function<T, V> taskHandler) {
        return this.process(items, TaskType.IO_INTENSIVE, taskHandler, null, null, null);
    }

    protected List<List<T>> splitList(List<T> list, int chunkSize) {
        ArrayList<List<T>> chunks = new ArrayList<List<T>>();
        int length = list.size();
        for (int i = 0; i < length; i += chunkSize) {
            int end = Math.min(i + chunkSize, length);
            chunks.add(list.subList(i, end));
        }
        return chunks;
    }

    public static enum TaskType {
        IO_INTENSIVE("io"),
        CPU_INTENSIVE("cpu");

        final String value;

        private TaskType(String value) {
            this.value = value;
        }

        public static TaskType toType(String value) {
            return Stream.of(TaskType.values()).filter(p -> p.value.equals(value)).findAny().orElse(null);
        }

        public static boolean is(String value) {
            return TaskType.toType(value) != null;
        }

        public String getValue() {
            return this.value;
        }
    }
}

