/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.plugins.auth;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.redis.RedisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthTools<T, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthTools.class);
    private static final String PUBLIC_ORG_NAME = "Public";
    private final RedisService redisService;

    protected AuthTools(RedisService redisService) {
        this.redisService = redisService;
    }

    public final R authorization(String orgId, T authParams) {
        if (!this.supportsParameterlessAuth() && authParams == null) {
            throw new ServiceException("\u4e0d\u652f\u6301\u65e0\u53c2\u9274\u6743");
        }
        if (orgId == null) {
            orgId = PUBLIC_ORG_NAME;
        }
        String key = this.getTokenCacheKey(orgId);
        Object tokenObj = this.redisService.get(key);
        LOGGER.info("{}:\u83b7\u53d6\u73b0\u6709token[{}]\u7684\u7ed3\u679c:{}", new Object[]{this.getName(), key, tokenObj});
        if (tokenObj != null) {
            return (R)tokenObj;
        }
        String finalOrgId = orgId;
        return (R)this.redisService.syncLock(key, () -> {
            Object newTokenObj = this.redisService.get(key);
            if (newTokenObj != null) {
                LOGGER.info("{}:\u83b7\u53d6\u73b0\u6709token[{}]\u7684\u7ed3\u679c:{}", new Object[]{this.getName(), key, newTokenObj});
                return newTokenObj;
            }
            LOGGER.info("{}\u5e73\u53f0\uff1a{}:\u8fdb\u884c\u9274\u6743\u64cd\u4f5c", (Object)this.getName(), (Object)key);
            AuthResult result = this.getToken(finalOrgId, authParams);
            this.redisService.set(key, result.value, (Object)result.expiresIn);
            return result.value;
        });
    }

    public final R authorization(String orgId) {
        return this.authorization(orgId, null);
    }

    public final R authorization() {
        return this.authorization(null);
    }

    public final void forceRefreshToken(String orgId) {
        if (orgId == null) {
            orgId = PUBLIC_ORG_NAME;
        }
        String key = this.getTokenCacheKey(orgId);
        this.redisService.lock(key, Integer.valueOf(0), Integer.valueOf(10), () -> {
            if (this.redisService.hasKey(key)) {
                this.redisService.delete(key);
            }
            return null;
        });
    }

    protected abstract AuthResult getToken(String var1, T var2);

    private String getTokenCacheKey(String orgId) {
        return this.getName() + "Token@" + orgId;
    }

    protected abstract String getName();

    protected boolean supportsParameterlessAuth() {
        return true;
    }

    protected final class AuthResult {
        private final R value;
        private final Integer expiresIn;

        public AuthResult(AuthTools this$0, R value, Integer expiresIn) {
            this.value = value;
            this.expiresIn = expiresIn;
        }
    }
}

