/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAUtils.class);

    private static KeyFactory getKeyFactory() {
        try {
            return KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("\u521d\u59cb\u5316 RSA KeyFactory \u5931\u8d25", e);
        }
    }

    public static byte[] sign(SignatureSuite suite, byte[] message, String privateKeyStr) {
        try {
            Signature signature = Signature.getInstance(suite.getValue());
            byte[] keyBytes = Base64.decodeBase64((String)privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey privateKey = RSAUtils.getKeyFactory().generatePrivate(keySpec);
            signature.initSign(privateKey);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            LOGGER.error("\u7b7e\u540d\u751f\u6210\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static boolean verifySign(SignatureSuite suite, String message, String signatureBase64, String publicKeyStr) {
        try {
            Signature signature = Signature.getInstance(suite.getValue());
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyStr));
            PublicKey publicKey = RSAUtils.getKeyFactory().generatePublic(keySpec);
            signature.initVerify(publicKey);
            signature.update(message.getBytes(StandardCharsets.UTF_8));
            return signature.verify(Base64.decodeBase64((String)signatureBase64));
        }
        catch (Exception e) {
            LOGGER.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    public static String encryptByPublicKey(String data, String publicKeyStr) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)publicKeyStr));
            PublicKey publicKey = RSAUtils.getKeyFactory().generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            byte[] encryptedData = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64String((byte[])encryptedData);
        }
        catch (Exception e) {
            LOGGER.error("RSA\u516c\u94a5\u52a0\u5bc6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static String decryptByPrivateKey(String encryptedData, String privateKeyStr) {
        try {
            byte[] keyBytes = Base64.decodeBase64((String)privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey privateKey = RSAUtils.getKeyFactory().generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, privateKey);
            byte[] decryptedData = cipher.doFinal(Base64.decodeBase64((String)encryptedData));
            return new String(decryptedData, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("RSA\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static enum SignatureSuite {
        SHA1("SHA1WithRSA"),
        SHA256("SHA256WithRSA");

        private final String suite;

        private SignatureSuite(String suite) {
            this.suite = suite;
        }

        public String getValue() {
            return this.suite;
        }
    }
}

