package com.af.v4.system.common.payment.enums;

/**
 * IntegrationTypeEnums
 * 对接方式
 */
public enum IntegrationType {
    AGGREGATE("聚合支付"),
    SCAN_DEVICE("扫码设备");

    private final String description;


    IntegrationType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }
    /**
     * 根据描述查找枚举
     */
    public static IntegrationType findByDescription(String description) {
        for (IntegrationType type : IntegrationType.values()) {
            if (type.getDescription().equals(description)) {
                return type;
            }
        }
        throw new IllegalArgumentException("未找到对应的对接方式: " + description);
    }
}



