package com.af.v4.system.common.payment.dto;

import org.json.JSONObject;

/**
 * 撤销订单请求参数
 */
public class CancelPaymentRequest {
    /**
     * 商户订单号（业务系统生成的唯一订单号）
     */
    private final String orderNo;
    /**
     * 银行名称
     */
    private final String bankName;
    /**
     * 分公司名称
     */
    private final String orgName;

    // 私有构造函数，防止直接实例化
    private CancelPaymentRequest(Builder builder) {
        this.orderNo = builder.orderNo;
        this.bankName = builder.bankName;
        this.orgName = builder.orgName;
    }

    public String getOrderNo() {
        return orderNo;
    }
    public String getBankName() {
        return bankName;
    }
    public String getOrgName() {
        return orgName;
    }
    // Builder 静态内部类
    public static class Builder {
        private String orderNo;
        private String bankName;
        private String orgName;

        public Builder() {
        }

        public static Builder fromJsonObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("orderNo")) {
                builder.orderNo(jsonObject.getString("orderNo"));
            }
            if (jsonObject.has("bankName")) {
                builder.bankName(jsonObject.getString("bankName"));
            }
            if (jsonObject.has("orgName")) {
                builder.orgName(jsonObject.getString("orgName"));
            }
            return builder;

        }

        public Builder orderNo(String orderNo) {
            this.orderNo = orderNo;
            return this;
        }

        public Builder orgName(String orgName) {
            this.orgName = orgName;
            return this;
        }

        public Builder bankName(String bankName) {
            this.bankName = bankName;
            return this;
        }

        public CancelPaymentRequest build() {
            return new CancelPaymentRequest(this);
        }
    }
}