package com.af.v4.system.common.payment.annotation;

import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 用于标记 PaymentHandler 的注解
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface PaymentHandlerConfig {
    // 银行名称
    BankName bankName();
    // 对接方式
    IntegrationType integrationType();
}
