/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.util.Assert;

public final class FileUtils {
    public static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String zip(String sourceFile, String targetFile) throws IOException {
        Assert.hasText((String)sourceFile, (String)"\u6e90\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)targetFile, (String)"\u76ee\u6807\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        File source = new File(sourceFile);
        Assert.isTrue((boolean)source.isFile(), (String)"\u6e90\u4e0d\u662f\u6587\u4ef6");
        int len = -1;
        byte[] buf = new byte[4096];
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(targetFile));
             BufferedOutputStream bos = new BufferedOutputStream(zos);
             FileInputStream fis = new FileInputStream(source);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            ZipEntry entry = new ZipEntry(source.getName());
            zos.putNextEntry(entry);
            while ((len = bis.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            bos.flush();
        }
        return targetFile;
    }

    public static String unzip(String sourceFile, String targetDirectory) throws IOException {
        Assert.hasText((String)sourceFile, (String)"\u6e90\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)targetDirectory, (String)"\u76ee\u6807\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a");
        File source = new File(sourceFile);
        Assert.isTrue((boolean)source.isFile(), (String)"\u6e90\u4e0d\u662f\u6587\u4ef6");
        File target = new File(targetDirectory);
        if (target.exists()) {
            target.delete();
            target.getParentFile().mkdirs();
            target.createNewFile();
        }
        try (FileInputStream is = new FileInputStream(source);
             ZipInputStream zis = new ZipInputStream(is);
             BufferedInputStream bin = new BufferedInputStream(zis);){
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null && !entry.isDirectory()) {
                File file = new File(targetDirectory, entry.getName());
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                byte[] buf = new byte[4096];
                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
                    int len;
                    while ((len = zis.read(buf)) != -1) {
                        bos.write(buf, 0, len);
                    }
                    bos.flush();
                }
            }
        }
        return targetDirectory;
    }

    public static String decodeFileContent(String filePath, String fileContent) throws Exception {
        String string;
        Assert.hasText((String)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)fileContent, (String)"\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        FileOutputStream out = null;
        try {
            File parentDirectory;
            byte[] encodedFileContentBytes = fileContent.getBytes(StandardCharsets.UTF_8);
            byte[] fileContentBytes = Base64.decode((byte[])encodedFileContentBytes);
            byte[] fileArray = FileUtils.inflater(fileContentBytes);
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
            if (!(parentDirectory = file.getParentFile()).exists()) {
                parentDirectory.mkdirs();
            }
            file.createNewFile();
            out = new FileOutputStream(file);
            out.write(fileArray, 0, fileArray.length);
            out.flush();
            string = filePath;
        }
        catch (IOException | DataFormatException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(out);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(out);
        return string;
    }

    public static String encodeFileContent(String filePath) throws IOException {
        Assert.hasText((String)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        try (FileInputStream fis = new FileInputStream(filePath);){
            String string;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] buffer = new byte[4096];
                int n = 0;
                while (-1 != (n = fis.read(buffer))) {
                    baos.write(buffer, 0, n);
                }
                byte[] bytes = baos.toByteArray();
                byte[] fileArray = FileUtils.deflater(bytes);
                byte[] fileContentBytes = Base64.encode((byte[])fileArray);
                string = new String(fileContentBytes, StandardCharsets.UTF_8);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inflater(byte[] inputBytes) throws DataFormatException {
        Inflater compresser = new Inflater(false);
        compresser.setInput(inputBytes, 0, inputBytes.length);
        byte[] result = new byte[1024];
        int compressedDataLength = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(inputBytes.length);
        try {
            byte[] bytes;
            baos = new ByteArrayOutputStream(inputBytes.length);
            while (!compresser.finished() && (compressedDataLength = compresser.inflate(result)) != 0) {
                baos.write(result, 0, compressedDataLength);
            }
            byte[] byArray = bytes = baos.toByteArray();
            return byArray;
        }
        finally {
            compresser.end();
            FileUtils.closeQuietly(baos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deflater(byte[] inputBytes) {
        Deflater compresser = new Deflater();
        compresser.setInput(inputBytes);
        compresser.finish();
        byte[] result = new byte[1024];
        int compressedDataLength = 0;
        ByteArrayOutputStream baos = null;
        try {
            byte[] bytes;
            baos = new ByteArrayOutputStream(inputBytes.length);
            while (!compresser.finished()) {
                compressedDataLength = compresser.deflate(result);
                baos.write(result, 0, compressedDataLength);
            }
            byte[] byArray = bytes = baos.toByteArray();
            return byArray;
        }
        finally {
            compresser.end();
            FileUtils.closeQuietly(baos);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

