/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.handler.impl.ccb;

import ccb.pay.api.util.CCBPayUtil;
import com.af.v4.system.common.payment.annotation.PaymentHandlerConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileRequest;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.impl.AbstractPaymentHandler;
import com.af.v4.system.common.payment.utils.PaymentUtils;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import java.util.Objects;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@PaymentHandlerConfig(bankName=BankName.XJ_CCB, integrationTypes={IntegrationType.SCAN_DEVICE})
public class XjCcbAbstractPaymentHandlerImpl
extends AbstractPaymentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(XjCcbAbstractPaymentHandlerImpl.class);

    @Override
    protected JSONObject buildPayOrderRequestParams(PaymentOrderRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u626b\u7801\u6536\u6b3e\u8bf7\u6c42\u53c2\u6570");
        try {
            return JsonTools.getOrderedJson().put("TXCODE", (Object)"PAY100").put("MERFLAG", (Object)"1").put("ORDERID", (Object)request.getOrderNo()).put("QRCODE", (Object)request.getAuthCode()).put("AMOUNT", (double)request.getAmount() / 100.0);
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected PaymentOrderResponse processPayOrderResponse(PaymentOrderResponse response, PaymentOrderRequest request, JSONObject resultJson, JSONObject paymentConfig) {
        LOGGER.info(">>> \u5904\u7406\u4e8c\u7ef4\u7801\u6536\u6b3e\u54cd\u5e94\u7ed3\u679c");
        String res = resultJson.optString("value");
        try {
            JSONObject result = new JSONObject(res);
            if ("N".equals(result.getString("RESULT"))) {
                response.setState(PaymentStatus.PAY_FAIL);
                response.setMessage(result.optString("ERRMSG"));
            } else {
                response.setState(PaymentStatus.PAY_SUCCESS);
                response.setOrderNo(result.optString("TRACEID"));
                response.setAmount((int)Math.round(result.optDouble("AMOUNT") * 100.0));
                response.setQrCodeType(result.optString("QRCODETYPE"));
                response.setTransactionId(result.optString("ORDERID"));
                response.setAllowRefunds(paymentConfig.optString("allowRefunds", "0"));
                response.setAllowCancel(paymentConfig.optString("allowCancel", "0"));
                response.setNeedQuery(true);
                response.setPayResult(PaymentStatus.SUCCESS_FOR_PAYMENT.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            response.setState(PaymentStatus.PAY_FAIL);
            response.setMessage("\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u6570\u636e\u5931\u8d25");
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryPaymentStatusRequestParams(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570");
        try {
            String queryTime = Objects.nonNull(request.getCustomParams()) ? request.getCustomParams().optString("qrytime", "1") : "1";
            return JsonTools.getOrderedJson().put("TXCODE", (Object)"PAY101").put("MERFLAG", (Object)"1").put("ORDERID", (Object)request.getOrderNo()).put("QRCODETYPE", (Object)request.getCustomParams().optString("qrCodeType", "1")).put("QRCODE", (Object)request.getCustomParams().optString("authCode", "")).put("QRYTIME", (Object)queryTime);
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryPaymentStatusResponse processQueryPaymentStatusResponse(QueryPaymentStatusResponse response, QueryPaymentStatusRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u54cd\u5e94\u7ed3\u679c");
        String res = resultJson.optString("value");
        try {
            JSONObject result = new JSONObject(res);
            String resCode = result.optString("RESULT", "N");
            if ("Y".equals(resCode)) {
                response.setState(PaymentStatus.SUCCESS_FOR_PAYMENT);
                response.setOrderNo(result.optString("ORDERID"));
                response.setAmount((int)Math.round(result.optDouble("AMOUNT") * 100.0));
                response.setTransactionId(result.optString("ORDERID"));
            } else if ("Q".equals(resCode) || "U".equals(resCode)) {
                response.setState(PaymentStatus.PAYMENT_IN_PROGRESS);
            } else {
                response.setState(PaymentStatus.FAIL_FOR_PAYMENT);
                response.setMessage(result.optString("ERRMSG"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u6570\u636e\u5931\u8d25", (Throwable)e);
            response.setState(PaymentStatus.PAY_FAIL);
            response.setMessage("\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u6570\u636e\u5931\u8d25");
        }
        return response;
    }

    @Override
    public PaymentOrderResponse paymentOrder(PaymentOrderRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u5f00\u59cb\u6267\u884c\u652f\u4ed8\u8bf7\u6c42\uff01");
        PaymentOrderResponse response = new PaymentOrderResponse();
        try {
            JSONObject reqParams = this.buildPayOrderRequestParams(request, paymentConfig);
            JSONObject payOrderRes = this.executePaymentRequest(reqParams, paymentConfig);
            this.processPayOrderResponse(response, request, payOrderRes, paymentConfig);
            return response;
        }
        catch (Exception e) {
            LOGGER.error("\u652f\u4ed8\u5931\u8d25: \u8bf7\u6c42\u62a5\u6587 = {}, \u5f02\u5e38\u4fe1\u606f = {}", (Object)request, (Object)e.getMessage());
            response.setCode(PaymentStatus.PAY_FAIL.getCode());
            response.setMessage(PaymentStatus.PAY_FAIL.getMessage());
            return response;
        }
    }

    @Override
    public QueryPaymentStatusResponse queryPaymentStatus(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u5f00\u59cb\u6267\u884c\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\uff01");
        QueryPaymentStatusResponse response = new QueryPaymentStatusResponse();
        try {
            JSONObject reqParams = this.buildQueryPaymentStatusRequestParams(request, paymentConfig);
            JSONObject queryPaymentRes = this.executePaymentRequest(reqParams, paymentConfig);
            this.processQueryPaymentStatusResponse(response, request, queryPaymentRes);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5931\u8d25: \u8bf7\u6c42\u62a5\u6587 = {}, \u5f02\u5e38\u4fe1\u606f = {}", (Object)request, (Object)e.getMessage());
            response.setState(PaymentStatus.QUERY_ORDER_FAIL);
            response.setRequestJson(new JSONObject(request.toString()));
        }
        return response;
    }

    @Override
    public RefundPaymentResponse refundPayment(RefundPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u5f00\u59cb\u6267\u884c\u8ba2\u5355\u9000\u6b3e\u8bf7\u6c42");
        RefundPaymentResponse response = new RefundPaymentResponse();
        try {
            JSONObject queryPaymentRes;
            JSONObject reqParams = this.buildRefundOrderRequestParams(request, paymentConfig);
            LOGGER.info(">>> \u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u6784\u5efa\u5b8c\u6210\uff01");
            LOGGER.info(">>> \u53d1\u8d77\u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\uff01");
            if (paymentConfig.optBoolean("isSocket", true)) {
                LOGGER.info(">>> \u542f\u52a8socket\u8bf7\u6c42");
                queryPaymentRes = this.executePaymentRequestForSocket(reqParams, paymentConfig);
            } else {
                LOGGER.info(">>> \u542f\u52a8http\u8bf7\u6c42");
                queryPaymentRes = this.executePaymentRequestForHttp(reqParams, paymentConfig);
            }
            LOGGER.info(">>> \u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\u5b8c\u6210\uff01");
            this.processRefundOrderResponse(response, request, queryPaymentRes);
        }
        catch (Exception e) {
            LOGGER.error("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25: \u8bf7\u6c42\u62a5\u6587={}, \u5f02\u5e38\u4fe1\u606f={}", (Object)request, (Object)e.getMessage());
            response.setCode(PaymentStatus.QUERY_ORDER_FAIL.getCode());
            response.setMessage(PaymentStatus.QUERY_ORDER_FAIL.getMessage());
            response.setRequestJson(new JSONObject(request.toString()));
        }
        return response;
    }

    @Override
    protected JSONObject executePaymentRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            LOGGER.info("\u8bf7\u6c42\u652f\u4ed8\u4e1a\u52a1, \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqParams);
            String host = paymentConfig.getString("transactionurl");
            String pubKey = paymentConfig.getString("publicKey");
            String param = this.convertJsonToQueryString(reqParams);
            LOGGER.info(">>> \u53c2\u6570\u4fe1\u606f\uff1a{}", (Object)param);
            String merInfo = this.convertJsonToQueryString(this.getCommonRequest(paymentConfig));
            LOGGER.info(">>> \u5546\u6237\u4fe1\u606f\uff1a{}", (Object)merInfo);
            LOGGER.info(">>> \u516c\u94a5\uff1a{}", (Object)pubKey);
            CCBPayUtil ccbPayUtil = new CCBPayUtil();
            String sign = ccbPayUtil.makeCCBParam(merInfo + "&" + param, pubKey);
            String url = host + "?" + merInfo + "&ccbParam=" + sign;
            LOGGER.info(">>> \u53d1\u9001\u81f3\u94f6\u884c\uff1a{}", (Object)url);
            String notifyURLParam = RestTools.post((String)url, (JSONObject)new JSONObject());
            LOGGER.info(">>> \u94f6\u884c\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)notifyURLParam);
            return new JSONObject().put("value", (Object)notifyURLParam);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u652f\u4ed8\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), PaymentStatus.PAY_ORDER_ERROR.getMessage());
        }
    }

    private JSONObject executePaymentRequestForHttp(JSONObject reqParams, JSONObject paymentConfig) {
        String host = paymentConfig.optString("host");
        int port = paymentConfig.optInt("port", -1);
        int timeout = paymentConfig.optInt("timeout", 60000);
        if (host == null || host.trim().isEmpty() || port == -1) {
            throw new IllegalArgumentException("Http \u8bf7\u6c42\u914d\u7f6e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\u4e2d\u7684 host \u548c port\u3002");
        }
        String reqStr = "requestXml=" + JsonTools.jsonConvertToXml((JSONObject)reqParams, (String)"TX", (boolean)true, (String)paymentConfig.optString("charset", "UTF-8"));
        String url = "http://" + host + ":" + port;
        JSONObject headers = new JSONObject().put("Content-Type", (Object)"application/xml");
        LOGGER.info(">>> Http \u8bf7\u6c42\u5730\u5740: {}", (Object)url);
        LOGGER.info(">>> Http \u8bf7\u6c42\u62a5\u6587: {}", (Object)reqStr);
        String resp = RestTools.post((String)url, (String)reqStr.replaceAll(">\\s+<", "><").replaceAll("[\\n\\r\\t]", "").trim(), (String)headers.toString());
        LOGGER.info(">>> Http \u8bf7\u6c42\u54cd\u5e94\u62a5\u6587: {}", (Object)resp);
        return JsonTools.xmlConvertToJson((String)resp, (String)paymentConfig.optString("charset", "UTF-8"));
    }

    /*
     * Exception decompiling
     */
    private JSONObject executePaymentRequestForSocket(JSONObject reqParams, JSONObject paymentConfig) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 32[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JSONObject getCommonRequest(JSONObject paymentConfig) {
        return JsonTools.getOrderedJson().put("MERCHANTID", (Object)paymentConfig.optString("mchId")).put("POSID", (Object)paymentConfig.optString("posId")).put("BRANCHID", (Object)paymentConfig.optString("branchId"));
    }

    private String convertJsonToQueryString(JSONObject jsonObject) {
        StringBuilder queryString = new StringBuilder();
        boolean first = true;
        for (String key : jsonObject.keySet()) {
            if (!first) {
                queryString.append("&");
            } else {
                first = false;
            }
            queryString.append(key.toUpperCase()).append("=").append(jsonObject.opt(key));
        }
        return queryString.toString();
    }

    @Override
    protected JSONObject buildCancelOrderRequestParams(CancelPaymentRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected CancelPaymentResponse processCancelOrderResponse(CancelPaymentResponse response, CancelPaymentRequest request, JSONObject resultJson) {
        return null;
    }

    @Override
    protected JSONObject buildRefundOrderRequestParams(RefundPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.info(">>> \u6784\u5efa\u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570");
        try {
            JSONObject body = new JSONObject().put("MONEY", (double)request.getRefundAmount() / 100.0).put("ORDER", (Object)request.getTransactionId()).put("REFUND_CODE", (Object)"");
            return new JSONObject().put("REQUEST_SN", (Object)PaymentUtils.generateRandomString(16, PaymentUtils.Mode.DIGITS_ONLY)).put("CUST_ID", (Object)paymentConfig.optString("custId")).put("USER_ID", (Object)paymentConfig.optString("userId")).put("PASSWORD", (Object)paymentConfig.optString("password")).put("TX_CODE", (Object)"5W1004").put("LANGUAGE", (Object)"CN").put("SIGN_INFO", (Object)"").put("SIGNCERT", (Object)"").put("TX_INFO", (Object)body);
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected RefundPaymentResponse processRefundOrderResponse(RefundPaymentResponse response, RefundPaymentRequest request, JSONObject resultJson) {
        LOGGER.info(">>> \u5904\u7406\u9000\u6b3e\u8ba2\u5355\u54cd\u5e94\u7ed3\u679c --> ");
        try {
            if ("000000".equals(resultJson.optString("RETURN_CODE"))) {
                JSONObject txInfo = resultJson.optJSONObject("TX_INFO");
                response.setMchId(resultJson.optString("CUST_ID"));
                response.setOrderNo(txInfo.optString("ORDER_NUM"));
                response.setTransactionId(txInfo.optString("ORDER_NUM"));
                response.setRefundOrderNo(txInfo.optString("ORDER_NUM"));
                response.setRefundAmount(resultJson.optInt("refund_fee"));
                response.setRefundResult(PaymentStatus.REFUND_REQUEST_SUCCESS.getMessage());
                response.setState(PaymentStatus.REFUND_REQUEST_SUCCESS);
            } else {
                response.setState(PaymentStatus.REFUND_REQUEST_FAIL);
                response.setMessage(resultJson.optString("RETURN_MSG", PaymentStatus.REFUND_REQUEST_FAIL.getMessage()));
            }
        }
        catch (Exception e) {
            LOGGER.error(">>> \u5904\u7406\u8ba2\u5355\u9000\u6b3e\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryRefundStatusRequestParams(QueryRefundStatusRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected QueryRefundStatusResponse processQueryRefundStatusResponse(QueryRefundStatusResponse response, QueryRefundStatusRequest request, JSONObject resultJson) {
        return null;
    }

    @Override
    protected void signRequest(JSONObject reqParams, JSONObject paymentConfig) {
    }

    @Override
    protected boolean verifyResponseSign(JSONObject response, JSONObject paymentConfig) {
        return true;
    }

    @Override
    protected JSONObject buildDownloadReconciliationFileRequestParams(DownloadReconciliationFileRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected DownloadReconciliationFileResponse processDownloadReconciliationFileResponse(DownloadReconciliationFileResponse response, DownloadReconciliationFileRequest request, JSONObject resultJson) {
        return null;
    }
}

