/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.handler.impl.abc;

import com.af.v4.system.common.payment.annotation.PaymentHandlerConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileRequest;
import com.af.v4.system.common.payment.dto.DownloadReconciliationFileResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.impl.AbstractPaymentHandler;
import com.af.v4.system.common.payment.utils.MD5Utils;
import com.af.v4.system.common.payment.utils.RSAUtils;
import com.af.v4.system.common.plugins.http.RestTools;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@PaymentHandlerConfig(bankName=BankName.ABC, integrationTypes={IntegrationType.AGGREGATE})
public class ABCAbstractPaymentHandlerImpl
extends AbstractPaymentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ABCAbstractPaymentHandlerImpl.class);

    @Override
    protected JSONObject buildPayOrderRequestParams(PaymentOrderRequest request, JSONObject paymentConfig) {
        try {
            String posNo = null;
            if (request.getPosNo() != null) {
                posNo = request.getPosNo();
            } else if (paymentConfig.has("posNo")) {
                posNo = paymentConfig.getString("posNo");
            }
            JSONObject requestJson = new JSONObject();
            requestJson.put("mid", (Object)paymentConfig.getString("merchantId"));
            requestJson.put("posNo", (Object)posNo);
            requestJson.put("txnAmt", request.getAmount());
            requestJson.put("tranType", (Object)"F");
            requestJson.put("merTradeNo", (Object)request.getOrderNo());
            return requestJson;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected PaymentOrderResponse processPayOrderResponse(PaymentOrderResponse response, PaymentOrderRequest request, JSONObject resultJson, JSONObject paymentConfig) {
        if (!"00".equals(resultJson.getString("respCode"))) {
            throw new PaymentException(PaymentStatus.PAY_FAIL.getCode(), resultJson.optString("respMsg", "\u4e0b\u5355\u5931\u8d25"), PaymentStatus.PAY_FAIL.getMessage());
        }
        response.setState(PaymentStatus.PAY_SUCCESS);
        response.setMchId(resultJson.optString("mid"));
        response.setOrderNo(resultJson.optString("merTradeNo"));
        response.setPayUrl(resultJson.optString("scanCode"));
        response.setAmount(resultJson.optInt("txnAmt"));
        response.setMessage(resultJson.optString("respMsg", "\u751f\u6210\u52a8\u6001\u805a\u5408\u7801\u6210\u529f"));
        return response;
    }

    @Override
    protected JSONObject buildQueryPaymentStatusRequestParams(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        try {
            JSONObject requestJson = new JSONObject();
            requestJson.put("mid", (Object)paymentConfig.getString("merchantId"));
            String posNo = null;
            if (request.getCustomParams() != null && request.getCustomParams().has("posNo")) {
                posNo = request.getCustomParams().getString("posNo");
            } else if (paymentConfig.has("posNo")) {
                posNo = paymentConfig.getString("posNo");
            }
            requestJson.put("posNo", (Object)posNo);
            requestJson.put("merTradeNo", (Object)request.getOrderNo());
            requestJson.put("tranType", (Object)"G");
            return requestJson;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryPaymentStatusResponse processQueryPaymentStatusResponse(QueryPaymentStatusResponse response, QueryPaymentStatusRequest request, JSONObject resultJson) {
        try {
            if (!"00".equals(resultJson.getString("respCode"))) {
                response.setState(PaymentStatus.QUERY_ORDER_FAIL);
                response.setMessage(resultJson.optString("respMsg", "\u67e5\u8be2\u5931\u8d25"));
                return response;
            }
            response.setMchId(resultJson.optString("mid"));
            response.setOrderNo(resultJson.optString("merTradeNo"));
            response.setTransactionId(resultJson.optString("transNo"));
            response.setAmount(resultJson.optInt("txnAmt"));
            String bankDate = resultJson.optString("bankDate", "");
            String bankTime = resultJson.optString("bankTime", "");
            if (!bankDate.isEmpty() && !bankTime.isEmpty()) {
                response.setPaySuccessDate(bankDate + bankTime);
            }
            response.setPaymentStatus(PaymentStatus.SUCCESS_FOR_PAYMENT.getMessage());
            response.setState(PaymentStatus.SUCCESS_FOR_PAYMENT);
        }
        catch (PaymentException e) {
            LOGGER.error("\u5904\u7406\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u54cd\u5e94\u53c2\u6570\u5f02\u5e38", (Throwable)((Object)e));
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u54cd\u5e94\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildCancelOrderRequestParams(CancelPaymentRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected CancelPaymentResponse processCancelOrderResponse(CancelPaymentResponse response, CancelPaymentRequest request, JSONObject resultJson) {
        return null;
    }

    @Override
    protected JSONObject buildRefundOrderRequestParams(RefundPaymentRequest request, JSONObject paymentConfig) {
        try {
            JSONObject requestJson = new JSONObject();
            requestJson.put("mid", (Object)paymentConfig.getString("merchantId"));
            requestJson.put("vfTradeNo", (Object)request.getOrderNo());
            String posNo = null;
            if (request.getCustomParams() != null && request.getCustomParams().has("posNo")) {
                posNo = request.getCustomParams().getString("posNo");
            } else if (paymentConfig.has("posNo")) {
                posNo = paymentConfig.getString("posNo");
            }
            requestJson.put("posNo", (Object)posNo);
            requestJson.put("txnAmt", request.getRefundAmount());
            requestJson.put("merTradeNo", (Object)request.getRefundOrderNo());
            requestJson.put("tranType", (Object)"R");
            return requestJson;
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected RefundPaymentResponse processRefundOrderResponse(RefundPaymentResponse response, RefundPaymentRequest request, JSONObject resultJson) {
        try {
            if (!"00".equals(resultJson.getString("respCode"))) {
                response.setCode(PaymentStatus.REFUND_REQUEST_FAIL.getCode());
                response.setMessage(resultJson.optString("respMsg", "\u9000\u6b3e\u7533\u8bf7\u5931\u8d25"));
                return response;
            }
            response.setMchId(resultJson.optString("mid"));
            response.setOrderNo(resultJson.optString("merTradeNo"));
            response.setRefundOrderNo(resultJson.optString("vfTradeNo"));
            response.setTransactionId(resultJson.optString("transNo"));
            response.setRefundAmount(resultJson.optInt("txnAmt"));
            response.setRefundResult(PaymentStatus.REFUND_REQUEST_SUCCESS.getMessage());
            response.setState(PaymentStatus.REFUND_REQUEST_SUCCESS);
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u9000\u6b3e\u54cd\u5e94\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryRefundStatusRequestParams(QueryRefundStatusRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected QueryRefundStatusResponse processQueryRefundStatusResponse(QueryRefundStatusResponse response, QueryRefundStatusRequest request, JSONObject resultJson) {
        return null;
    }

    @Override
    protected void signRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            String signed = MD5Utils.md5Upper(reqParams.toString() + "&" + paymentConfig.getString("md5Key"));
            reqParams.put("sign", (Object)signed);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new PaymentException(PaymentStatus.SIGN_FAIL.getCode(), reqParams.toString(), PaymentStatus.SIGN_FAIL.getMessage());
        }
    }

    @Override
    protected JSONObject executePaymentRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            String url = paymentConfig.getString("url");
            JSONObject header = new JSONObject();
            header.put("Content-Type", (Object)"application/json");
            header.put("sign", (Object)reqParams.getString("sign"));
            reqParams.remove("sign");
            String requestBody = reqParams.toString();
            if (paymentConfig.has("rsaEncId") && paymentConfig.has("publicKey")) {
                String rsaEncId = paymentConfig.getString("rsaEncId");
                String publicKey = paymentConfig.getString("publicKey");
                LOGGER.info("\u68c0\u6d4b\u5230rsaEncId\uff0c\u5f00\u59cbRSA\u52a0\u5bc6\u5904\u7406");
                String encryptedBody = RSAUtils.encryptByPublicKey(requestBody, publicKey);
                if (encryptedBody == null) {
                    throw new PaymentException(PaymentStatus.PAY_FAIL.getCode(), "RSA\u52a0\u5bc6\u5931\u8d25", PaymentStatus.PAY_FAIL.getMessage());
                }
                header.put("rsaEncId", (Object)rsaEncId);
                LOGGER.info("RSA\u52a0\u5bc6\u6210\u529f\uff0c\u53d1\u9001\u52a0\u5bc6\u62a5\u6587");
                requestBody = encryptedBody;
            }
            String result = RestTools.post((String)url, (String)requestBody, (String)header.toString());
            if (paymentConfig.has("rsaEncId") && paymentConfig.has("privateKey")) {
                String privateKey = paymentConfig.getString("privateKey");
                LOGGER.info("\u68c0\u6d4b\u5230rsaEncId\uff0c\u5f00\u59cbRSA\u89e3\u5bc6\u54cd\u5e94");
                String decryptedResult = RSAUtils.decryptByPrivateKey(result, privateKey);
                if (decryptedResult == null) {
                    throw new PaymentException(PaymentStatus.PAY_FAIL.getCode(), "RSA\u89e3\u5bc6\u5931\u8d25", PaymentStatus.PAY_FAIL.getMessage());
                }
                LOGGER.info("RSA\u89e3\u5bc6\u6210\u529f");
                result = decryptedResult;
            }
            return new JSONObject(result);
        }
        catch (PaymentException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("\u8c03\u7528\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_FAIL.getCode(), reqParams.toString(), PaymentStatus.PAY_FAIL.getMessage());
        }
    }

    @Override
    protected boolean verifyResponseSign(JSONObject response, JSONObject paymentConfig) {
        return true;
    }

    @Override
    protected JSONObject buildDownloadReconciliationFileRequestParams(DownloadReconciliationFileRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected DownloadReconciliationFileResponse processDownloadReconciliationFileResponse(DownloadReconciliationFileResponse response, DownloadReconciliationFileRequest request, JSONObject resultJson) {
        return null;
    }
}

