/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.payment.handler.impl.hbbk;

import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.payment.annotation.PaymentHandlerConfig;
import com.af.v4.system.common.payment.dto.CancelPaymentRequest;
import com.af.v4.system.common.payment.dto.CancelPaymentResponse;
import com.af.v4.system.common.payment.dto.PaymentOrderRequest;
import com.af.v4.system.common.payment.dto.PaymentOrderResponse;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusRequest;
import com.af.v4.system.common.payment.dto.QueryPaymentStatusResponse;
import com.af.v4.system.common.payment.dto.QueryRefundStatusRequest;
import com.af.v4.system.common.payment.dto.QueryRefundStatusResponse;
import com.af.v4.system.common.payment.dto.RefundPaymentRequest;
import com.af.v4.system.common.payment.dto.RefundPaymentResponse;
import com.af.v4.system.common.payment.enums.BankName;
import com.af.v4.system.common.payment.enums.IntegrationType;
import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.exceptions.PaymentException;
import com.af.v4.system.common.payment.handler.impl.AbstractPaymentHandler;
import com.af.v4.system.common.payment.utils.PaymentUtils;
import com.af.v4.system.common.payment.utils.SignUtils;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@PaymentHandlerConfig(bankName=BankName.HBBK, integrationType=IntegrationType.AGGREGATE)
public class HbbkAbstractPaymentHandlerImpl
extends AbstractPaymentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HbbkAbstractPaymentHandlerImpl.class);
    private final String SUCCESS_CODE = "0";

    @Override
    protected JSONObject buildPayOrderRequestParams(PaymentOrderRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u6784\u5efa\u83b7\u53d6\u6536\u6b3e\u4e8c\u7ef4\u7801\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            String timeoutUnit;
            LOGGER.info(">>> \u8ba2\u5355\u8d85\u65f6\u65f6\u957f\uff1a");
            int timeoutDuration = paymentConfig.optInt("expirationTime", 2);
            timeoutUnit = switch (timeoutUnit = paymentConfig.optString("expiredUnits", "MINUTE")) {
                case "y", "YEAR" -> "YEAR";
                case "M", "MONTH" -> "MONTH";
                case "d", "DAY" -> "DAY";
                case "h", "HOUR" -> "HOUR";
                case "m", "MINUTE" -> "MINUTE";
                case "s", "SECOND" -> "SECOND";
                default -> throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65e5\u671f\u7c7b\u578b\uff01\u53ef\u9009\u503c(y, M, d, h, m, s)");
            };
            String now = DateTools.getNow2();
            String expirationTime = DateTools.format((String)DateTools.getDelayDate((String)now, (String)timeoutUnit, (String)String.valueOf(timeoutDuration)), (String)"yyyyMMddHHmmss");
            String now2 = DateTools.format((String)now, (String)"yyyyMMddHHmmss");
            LOGGER.info(">>> \u8ba2\u5355\u8d85\u65f6\u65f6\u957f\uff1a{}\uff0c\u5355\u4f4d\uff1a{} --> \u6700\u7ec8\u4e0b\u5355\u65f6\u95f4: {}\uff0c\u8ba2\u5355\u5931\u6548\u65f6\u95f4\uff1a{}", new Object[]{timeoutDuration, timeoutUnit, now2, expirationTime});
            return this.getCommonRequest(paymentConfig).put("service", (Object)"unified.trade.native").put("out_trade_no", (Object)request.getOrderNo()).put("body", (Object)request.getDescription()).put("total_fee", request.getAmount()).put("time_start", (Object)now2).put("time_expire", (Object)expirationTime).put("notify_url", (Object)(StringUtils.isBlank((CharSequence)request.getNotifyUrl()) ? paymentConfig.optString("notifyUrl", "127.0.0.1") : request.getNotifyUrl())).put("mch_create_ip", paymentConfig.opt("mchServiceIP")).put("terminal_info", (Object)new JSONObject().put("terminal_type", (Object)"08").put("terminal_id", (Object)"**").put("app_version", (Object)"1.000000").toString());
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected PaymentOrderResponse processPayOrderResponse(PaymentOrderResponse response, PaymentOrderRequest request, JSONObject resultJson, JSONObject paymentConfig) {
        LOGGER.info("\u5904\u7406\u83b7\u53d6\u4e8c\u7ef4\u7801\u54cd\u5e94\u7ed3\u679c > ");
        try {
            boolean needQuery = true;
            if ("0".equals(resultJson.optString("status"))) {
                String payState;
                response.setState(PaymentStatus.PAY_SUCCESS);
                response.setMchId(resultJson.optString("mch_id"));
                if ("0".equals(resultJson.optString("result_code"))) {
                    payState = "\u4ea4\u6613\u6210\u529f";
                    needQuery = false;
                    response.setPayUrl(resultJson.optString("code_url"));
                    response.setCustomParam(new JSONObject().put("payImgUrl", (Object)resultJson.optString("code_img_url")).toString());
                } else {
                    payState = resultJson.optString("err_msg", "\u4ea4\u6613\u5931\u8d25");
                }
                response.setNeedQuery(needQuery);
                response.setPayResult(payState);
            } else {
                LOGGER.info("\u672c\u6b21\u652f\u4ed8\u8ba2\u5355\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setState(PaymentStatus.COMMUNICATION_FAIL);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.PAY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryPaymentStatusRequestParams(QueryPaymentStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            return this.getCommonRequest(paymentConfig).put("service", (Object)"unified.trade.query").put("out_trade_no", (Object)request.getOrderNo());
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryPaymentStatusResponse processQueryPaymentStatusResponse(QueryPaymentStatusResponse response, QueryPaymentStatusRequest request, JSONObject resultJson) {
        LOGGER.info("\u5904\u7406\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u54cd\u5e94\u7ed3\u679c > ");
        try {
            if ("0".equals(resultJson.optString("status"))) {
                if ("0".equals(resultJson.optString("result_code"))) {
                    String tradeState;
                    response.setMchId(resultJson.optString("mch_id"));
                    response.setOrderNo(resultJson.optString("out_trade_no"));
                    response.setTransactionId(resultJson.optString("transaction_id"));
                    response.setAmount(resultJson.optInt("total_fee"));
                    PaymentStatus status = switch (tradeState = resultJson.optString("trade_state")) {
                        case "SUCCESS" -> PaymentStatus.SUCCESS_FOR_PAYMENT;
                        case "REFUND" -> PaymentStatus.REFUND_FOR_PAYMENT;
                        case "NOTPAY" -> PaymentStatus.NOT_FOR_PAYMENT;
                        case "CLOSED" -> PaymentStatus.ORDER_BEEN_CLOSED;
                        default -> PaymentStatus.FAIL_FOR_PAYMENT;
                    };
                    response.setPaymentStatus(status.getMessage());
                    response.setState(status);
                    response.setPaySuccessDate(DateTools.formatDateTime((String)resultJson.optString("time_end", DateTools.getNow((String)"yyyyMMddHHmmss"))));
                } else {
                    response.setState(PaymentStatus.PAY_FAIL);
                }
            } else {
                LOGGER.info("\u672c\u6b21\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setCode(PaymentStatus.COMMUNICATION_FAIL.getCode());
                response.setMessage(PaymentStatus.COMMUNICATION_FAIL.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u652f\u4ed8\u72b6\u6001\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.QUERY_ORDER_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildCancelOrderRequestParams(CancelPaymentRequest request, JSONObject paymentConfig) {
        return null;
    }

    @Override
    protected CancelPaymentResponse processCancelOrderResponse(CancelPaymentResponse response, CancelPaymentRequest request, JSONObject resultJson) {
        return null;
    }

    @Override
    protected JSONObject buildRefundOrderRequestParams(RefundPaymentRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u6784\u5efa\u9000\u6b3e\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            return this.getCommonRequest(paymentConfig).put("service", (Object)"unified.trade.refund").put("out_trade_no", (Object)request.getOrderNo()).put("out_refund_no", (Object)request.getRefundOrderNo()).put("total_fee", request.getAmount()).put("refund_fee", request.getRefundAmount()).put("op_user_id", (Object)paymentConfig.getString("mchId"));
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u8ba2\u5355\u64a4\u9500\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected RefundPaymentResponse processRefundOrderResponse(RefundPaymentResponse response, RefundPaymentRequest request, JSONObject resultJson) {
        LOGGER.info("\u5904\u7406\u8ba2\u5355\u9000\u6b3e\u54cd\u5e94\u7ed3\u679c > ");
        try {
            if ("0".equals(resultJson.optString("status"))) {
                if ("0".equals(resultJson.optString("result_code"))) {
                    response.setMchId(resultJson.optString("mch_id"));
                    response.setOrderNo(resultJson.optString("out_trade_no"));
                    response.setTransactionId(resultJson.optString("transaction_id"));
                    response.setRefundOrderNo(resultJson.optString("out_refund_no"));
                    response.setRefundId(resultJson.optString("refund_id"));
                    response.setRefundAmount(resultJson.optInt("refund_fee"));
                    response.setRefundResult(PaymentStatus.REFUND_REQUEST_SUCCESS.getMessage());
                    response.setState(PaymentStatus.REFUND_REQUEST_SUCCESS);
                } else {
                    response.setCode(PaymentStatus.REFUND_REQUEST_FAIL.getCode());
                    response.setMessage(resultJson.optString("message", PaymentStatus.REFUND_REQUEST_FAIL.getMessage()));
                }
            } else {
                LOGGER.info("\u672c\u6b21\u8ba2\u5355\u9000\u6b3e\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setState(PaymentStatus.COMMUNICATION_FAIL);
            }
        }
        catch (Exception e) {
            LOGGER.error(" \u6784\u5efa\u8ba2\u5355\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected JSONObject buildQueryRefundStatusRequestParams(QueryRefundStatusRequest request, JSONObject paymentConfig) {
        LOGGER.info("\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u8bf7\u6c42\u53c2\u6570 > ");
        try {
            return this.getCommonRequest(paymentConfig).put("service", (Object)"unified.trade.refundquery").put("out_trade_no", (Object)request.getOrderNo()).put("refund_id", (Object)request.getRefundId());
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.QUERY_REFUND_BUILD_REQUEST_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_REQUEST_PARAM_ERROR.getMessage());
        }
    }

    @Override
    protected QueryRefundStatusResponse processQueryRefundStatusResponse(QueryRefundStatusResponse response, QueryRefundStatusRequest request, JSONObject resultJson) {
        LOGGER.info("\u5904\u7406\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u54cd\u5e94\u7ed3\u679c > ");
        try {
            if ("0".equals(resultJson.optString("status"))) {
                if ("0".equals(resultJson.optString("result_code"))) {
                    String refundStatus;
                    response.setMchId(resultJson.optString("mch_id"));
                    response.setTransactionId(resultJson.optString("transaction_id"));
                    response.setOrderNo(resultJson.optString("out_trade_no"));
                    response.setRefundOrderNo(resultJson.optString("out_refund_no_0"));
                    response.setRefundId(resultJson.optString("refund_id_0"));
                    response.setRefundAmount(resultJson.optInt("refund_fee_0"));
                    response.setRefundDateTime(resultJson.optString("refund_time_0"));
                    PaymentStatus status = switch (refundStatus = resultJson.optString("refund_status_0")) {
                        case "SUCCESS" -> PaymentStatus.REFUND_SUCCESS;
                        case "PROCESSING" -> PaymentStatus.REFUND_PROCESSING;
                        case "CHANGE" -> PaymentStatus.REFUND_CHANGE;
                        default -> PaymentStatus.REFUND_FAIL;
                    };
                    response.setRefundResult(status.getMessage());
                    response.setState(status);
                } else {
                    response.setState(PaymentStatus.REFUND_FAIL);
                }
            } else {
                LOGGER.info("\u672c\u6b21\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u4ea4\u6613\u901a\u4fe1\u5931\u8d25\uff01");
                response.setState(PaymentStatus.COMMUNICATION_FAIL);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u5efa\u67e5\u8be2\u9000\u6b3e\u72b6\u6001\u8fd4\u56de\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getCode(), request.toString(), PaymentStatus.REFUND_BUILD_RESPONSE_PARAM_ERROR.getMessage());
        }
        return response;
    }

    @Override
    protected void signRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            SignUtils.signRequestParams(reqParams, "RSA_1_256", "sign", paymentConfig.getString("privateKey"));
        }
        catch (Exception e) {
            LOGGER.error("\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new PaymentException(PaymentStatus.SIGN_FAIL.getCode(), reqParams.toString(), PaymentStatus.SIGN_FAIL.getMessage());
        }
    }

    @Override
    protected JSONObject executePaymentRequest(JSONObject reqParams, JSONObject paymentConfig) {
        try {
            JSONObject headers = new JSONObject();
            String formattedRequest = JsonTools.jsonConvertToXml((JSONObject)reqParams);
            LOGGER.info("\u8bf7\u6c42\u652f\u4ed8\u4e1a\u52a1, \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)formattedRequest);
            headers.put("Content-Type", (Object)"application/xml");
            String response = RestTools.post((String)paymentConfig.getString("transactionurl"), (String)formattedRequest, (String)headers.toString());
            JSONObject jsonObject = JsonTools.xmlConvertToJson((String)response);
            LOGGER.info("\u54cd\u5e94\u7ed3\u679c\uff1a" + jsonObject.toString());
            return jsonObject;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u652f\u4ed8\u4e1a\u52a1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new PaymentException(PaymentStatus.PAY_ORDER_ERROR.getCode(), reqParams.toString(), PaymentStatus.PAY_ORDER_ERROR.getMessage());
        }
    }

    @Override
    protected boolean verifyResponseSign(JSONObject response, JSONObject paymentConfig) {
        try {
            return SignUtils.verifySign(response, response.getString("sign_type"), response.getString("sign"), paymentConfig.getString("publicKey"));
        }
        catch (Exception e) {
            LOGGER.error("\u9a8c\u7b7e\u5931\u8d25\uff01", (Throwable)e);
            throw new PaymentException(PaymentStatus.VERIFY_SIGN_FAIL.getCode(), "{}", PaymentStatus.VERIFY_SIGN_FAIL.getMessage());
        }
    }

    private JSONObject getCommonRequest(JSONObject paymentConfig) {
        return new JSONObject().put("version", (Object)"2.0").put("charset", (Object)"UTF-8").put("sign_type", (Object)"RSA_1_256").put("mch_id", (Object)paymentConfig.optString("mchId")).put("mch_create_ip", (Object)paymentConfig.optString("mchServiceIP")).put("nonce_str", (Object)PaymentUtils.generateRandomString(32));
    }
}

