package com.af.v4.system.common.payment.handler;

import com.af.v4.system.common.payment.dto.*;
import org.json.JSONObject;

/**
 * @ClassName PaymentHandler
 * @Description 通用支付处理器
 * @Author llz
 * @Date 2024/12/20 18:12
 */
public interface PaymentHandler {


    /**
     * 支付订单
     *
     * @param request 支付订单请求
     * @return 支付响应
     */
    PaymentOrderResponse paymentOrder (PaymentOrderRequest request, JSONObject paymentConfig);

    /**
     * 查询支付状态
     *
     * @param request 查询支付状态请求
     * @return 支付查询响应
     */
    QueryPaymentStatusResponse queryPaymentStatus (QueryPaymentStatusRequest request, JSONObject paymentConfig);

    /**
     * 撤销支付订单
     *
     * @param request 撤销支付订单请求
     * @return 撤销支付结果
     */
    CancelPaymentResponse cancelOrder(CancelPaymentRequest request, JSONObject paymentConfig);

    /**
     * 退款
     *
     * @param request 退款请求
     * @return 退款结果
     */
    RefundPaymentResponse refundPayment(RefundPaymentRequest request, JSONObject paymentConfig);

    /**
     * 退款
     *
     * @param request 退款请求
     * @return 退款结果
     */
    QueryRefundStatusResponse queryRefundStatus(QueryRefundStatusRequest request, JSONObject paymentConfig);
}

