package com.af.v4.system.common.payment.exceptions;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.payment.enums.PaymentStatus;

/**
 * @author llzh
 * @ClassName PaymentException
 * @Description 支付相关的自定义异常
 * @DateTime 2024/12/24 17:23
 */
public class PaymentException extends ServiceException {
    // 请求的 JSON 数据
    private final String requestJson;
    // 响应的 JSON 数据
    private final String responseJson;
    // 错误码
    private final String errorCode;

    public PaymentException(PaymentStatus paymentStatus) {
        this(paymentStatus.getCode(), paymentStatus.getMessage(), null, null);
    }

    public PaymentException(PaymentStatus paymentStatus, String requestJson) {
        this(paymentStatus.getCode(), paymentStatus.getMessage(), requestJson, null);
    }

    public PaymentException(PaymentStatus paymentStatus, String requestJson, String responseJson) {
        this(paymentStatus.getCode(), paymentStatus.getMessage(), requestJson, responseJson);
    }

    public PaymentException(String message) {
        this(null, message, null, null);
    }

    public PaymentException(String errorCode, String message) {
        this(errorCode, message, null, null);
    }
    public PaymentException(String errorCode, String message, String requestJson) {
        this(errorCode, message, requestJson, null);
    }
    public PaymentException(String errorCode, String message, String requestJson, String responseJson) {
        super(message);
        this.errorCode = errorCode;
        this.requestJson = requestJson;
        this.responseJson = responseJson;
    }


    public String getRequestJson() {
        return requestJson;
    }

    public String getResponseJson() {
        return responseJson;
    }

    public String getErrorCode() {
        return errorCode;
    }

    @Override
    public String toString() {
        return STR."PaymentException{errorCode='\{errorCode}', message='\{getMessage()}', requestJson='\{requestJson}', responseJson='\{responseJson}'}";
    }
}
