package com.af.v4.system.common.payment.dto;

import com.af.v4.system.common.payment.enums.PaymentStatus;
import com.af.v4.system.common.payment.utils.PaymentUtils;
import org.json.JSONObject;

/**
 * @author llzh
 * @ClassName PaymentQueryResponse
 * @Description 查询订单状态返回参数
 * @DateTime 2024/12/25 13:36
 */
public class QueryPaymentStatusResponse {
    /**
     * 返回码
     */
    private String code;
    /**
     * 返回描述
     */
    private String message;
    /**
     * 订单支付状态
     */
    private String paymentStatus;
    /**
     * 商户号
     */
    private String mchId;
    /**
     * 商户订单号（业务系统生成的唯一订单号）
     */
    private String orderNo;
    /**
     * 第三方订单号
     */
    private String transactionId;
    /**
     * 支付金额（单位：分）
     */
    private int amount;
    /**
     * 支付完成时间
     */
    private String paySuccessDate;
    /**
     * 请求报文
     */
    private JSONObject requestJson;

    public JSONObject buildJson(){
        return  PaymentUtils.toJson(this);
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public int getAmount() {
        return amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public JSONObject getRequestJson() {
        return requestJson;
    }

    public void setRequestJson(JSONObject requestJson) {
        this.requestJson = requestJson;
    }

    public String getPaySuccessDate() {
        return paySuccessDate;
    }

    public void setPaySuccessDate(String paySuccessDate) {
        this.paySuccessDate = paySuccessDate;
    }

    public void setState(PaymentStatus paymentStatus) {
        this.code = paymentStatus.getCode();
        this.message = paymentStatus.getMessage();
    }
}