package com.af.v4.system.common.mq.rabbitMQ;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 多RabbitMQ连接配置属性
 */
@Component
@RefreshScope
@ConfigurationProperties(prefix = "rabbitmq")
public class MultiRabbitProperties {

    /**
     * 是否启用RabbitMQ多连接功能
     */
    private boolean enabled = true;

    /**
     * 多个RabbitMQ连接配置
     */
    private Map<String, ConnectionConfig> connections = new HashMap<>();

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, ConnectionConfig> getConnections() {
        return connections;
    }

    public void setConnections(Map<String, ConnectionConfig> connections) {
        this.connections = connections;
    }

    /**
     * RabbitMQ连接配置
     */
    public static class ConnectionConfig {
        /**
         * RabbitMQ服务器地址 - 必填
         */
        private String host;

        /**
         * RabbitMQ端口 - 可选，默认5672
         */
        private Integer port = 5672;

        /**
         * 用户名 - 必填
         */
        private String username;

        /**
         * 密码 - 必填
         */
        private String password;

        /**
         * 虚拟主机 - 可选，默认"/"
         */
        private String virtualHost = "/";

        /**
         * 监听的队列列表 - 可选
         */
        private List<String> listenQueues = new ArrayList<>();

        /**
         * 连接超时时间（毫秒） - 可选，默认60秒
         */
        private Integer connectionTimeout = 60000;

        /**
         * 心跳间隔（秒） - 可选，默认60秒
         */
        private Integer requestedHeartbeat = 60;

        /**
         * 消费者并发数 - 可选，默认1个（安全起见）
         */
        private Integer concurrentConsumers = 1;

        /**
         * 最大消费者并发数 - 可选，默认5个
         */
        private Integer maxConcurrentConsumers = 5;

        /**
         * 预取数量 - 可选，默认10条
         */
        private Integer prefetchCount = 10;

        /**
         * 是否启用此连接 - 可选，默认启用
         */
        private Boolean enabled = true;

        public String getHost() {
            return host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getUsername() {
            return username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getVirtualHost() {
            return virtualHost;
        }

        public void setVirtualHost(String virtualHost) {
            this.virtualHost = virtualHost;
        }

        public List<String> getListenQueues() {
            return listenQueues;
        }

        public void setListenQueues(List<String> listenQueues) {
            this.listenQueues = listenQueues;
        }

        public Integer getConnectionTimeout() {
            return connectionTimeout;
        }

        public void setConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public Integer getRequestedHeartbeat() {
            return requestedHeartbeat;
        }

        public void setRequestedHeartbeat(Integer requestedHeartbeat) {
            this.requestedHeartbeat = requestedHeartbeat;
        }

        public Integer getConcurrentConsumers() {
            return concurrentConsumers;
        }

        public void setConcurrentConsumers(Integer concurrentConsumers) {
            this.concurrentConsumers = concurrentConsumers;
        }

        public Integer getMaxConcurrentConsumers() {
            return maxConcurrentConsumers;
        }

        public void setMaxConcurrentConsumers(Integer maxConcurrentConsumers) {
            this.maxConcurrentConsumers = maxConcurrentConsumers;
        }

        public Integer getPrefetchCount() {
            return prefetchCount;
        }

        public void setPrefetchCount(Integer prefetchCount) {
            this.prefetchCount = prefetchCount;
        }

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

}