/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.logic.service;

import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.context.GlobalVisualThreadContext;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.enums.Logical;
import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.expression.Expression;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.resource.constant.CacheKey;
import com.af.v4.system.common.resource.mapper.LogicMapper;
import com.af.v4.system.common.resource.mapper.PluginMapper;
import com.af.v4.system.common.security.auth.AuthLogic;
import java.lang.invoke.StringConcatFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StopWatch;

@Primary
@Service
@Transactional(rollbackFor={Exception.class})
public class LogicService
implements ILogicServiceProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicService.class);
    private static final org.apache.logging.log4j.Logger LOG4J_LOGGER = LogManager.getLogger(LogicService.class);
    private final Semaphore DEFAULT_ASYNC_LOGIC_SEMAPHORE;
    private final DynamicFeignClientFactory<RemoteLogicService> dynamicFeignClientFactory;
    private final LogicMapper logicMapper;
    private final ApplicationService applicationService;
    private final RedisService redisService;
    private final PlatformTransactionManager transactionManager;
    private final AuthLogic authLogic = new AuthLogic();

    public LogicService(DynamicFeignClientFactory<RemoteLogicService> dynamicFeignClientFactory, LogicMapper logicMapper, ApplicationService applicationService, RedisService redisService, PlatformTransactionManager transactionManager) {
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
        this.logicMapper = logicMapper;
        this.applicationService = applicationService;
        this.redisService = redisService;
        this.transactionManager = transactionManager;
        int maxPoolSize = DynamicDataSource.getWrapper().getDataSource().getMaximumPoolSize();
        int permits = (int)((double)maxPoolSize * 0.9);
        permits = Math.max(permits, 4);
        this.DEFAULT_ASYNC_LOGIC_SEMAPHORE = new Semaphore(permits);
    }

    private static String getDataSourceName(String dataSourceName, LogicMapper.LogicResource resource) {
        return dataSourceName != null ? dataSourceName : (resource.getDataSource() != null ? resource.getDataSource() : DynamicDataSource.getDataSource());
    }

    public boolean has(String logicName) {
        return this.logicMapper.hasResource(logicName);
    }

    public Object run(String logicName, JSONObject param, String dataSourceName) {
        LogicMapper.LogicResource resource = (LogicMapper.LogicResource)this.logicMapper.getResource(logicName);
        this.performAuthorizationCheck(resource);
        String name = resource.getAlias();
        boolean cache = resource.isCache();
        String dataSource = LogicService.getDataSourceName(dataSourceName, resource);
        LOGGER.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u6267\u884cLogic[{}]\uff0cisSupportCache: {}\uff0cparams: {}\uff0cdataSource\uff1a{}"})), new Object[]{name, cache, param, dataSource});
        if (this.applicationService.getEnvType() == EnvType.LOCAL && resource.isDeprecated()) {
            String replacedBy = resource.getReplacedBy();
            if (replacedBy != null) {
                LOGGER.warn("Logic[{}]\u5df2\u6807\u8bb0\u5e9f\u5f03\uff0c\u53ef\u80fd\u4f1a\u5728\u540e\u7eed\u7248\u672c\u4e2d\u79fb\u9664\uff0c\u8bf7\u8fc1\u79fb\u5230\u65b0API[{}]", (Object)name, (Object)replacedBy);
            } else {
                LOGGER.warn("Logic[{}]\u5df2\u6807\u8bb0\u5e9f\u5f03\uff0c\u53ef\u80fd\u4f1a\u5728\u540e\u7eed\u7248\u672c\u4e2d\u79fb\u9664", (Object)name);
            }
        }
        String source = resource.getSource();
        HashMap<String, Object> params = new HashMap<String, Object>(((PluginMapper)SpringUtils.getBean(PluginMapper.class)).getPluginMap());
        params.put("data", param);
        params.put("log", LOG4J_LOGGER);
        params.put("ENV", this.applicationService.getValues());
        params.put("RESOURCE", resource.getJsonParams());
        params.put("logic", this);
        params.put("authTools", this.authLogic);
        return this.logicMonitor(name, resource.getPath(), dataSource, param.toString(), () -> this.runExpression(source, params));
    }

    public Object run(String name, JSONObject param) {
        return this.run(name, param, null);
    }

    public Object run(String name, String str) {
        return this.run(name, this.buildLogicParams(str));
    }

    public CompletableFuture<Object> runAsync(String name, JSONObject param, Semaphore semaphore) {
        CompletionStage future;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Logic \u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Semaphore finalSemaphore = Objects.requireNonNullElse(semaphore, this.DEFAULT_ASYNC_LOGIC_SEMAPHORE);
        try {
            finalSemaphore.acquire();
            future = GlobalVisualThreadContext.runAsync(() -> this.run(name, param)).whenComplete((result, throwable) -> finalSemaphore.release());
        }
        catch (InterruptedException e) {
            LOGGER.error("\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38. Logic \u540d\u79f0: {}", (Object)name, (Object)e);
            Thread.currentThread().interrupt();
            throw new ServiceException("\u7ebf\u7a0b\u88ab\u4e2d\u65ad");
        }
        return future;
    }

    public CompletableFuture<Object> runAsync(String name, JSONObject param) {
        return this.runAsync(name, param, null);
    }

    public CompletableFuture<Object> runAsync(String name, String str) {
        return this.runAsync(name, this.buildLogicParams(str));
    }

    public JSONObject remoteRun(String serviceName, String logicName, String params) {
        LOGGER.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u8fdc\u7a0b\u8c03\u7528{}\u7684Logic[{}]\uff0c\u53c2\u6570\uff1a{}"})), new Object[]{serviceName, logicName, params});
        return (JSONObject)this.logicMonitor(logicName, "http://" + serviceName + "/logic/" + logicName, null, params, () -> {
            RemoteLogicService remoteLogicService = (RemoteLogicService)this.dynamicFeignClientFactory.getFeignClient(RemoteLogicService.class, serviceName);
            R logicResult = remoteLogicService.run(logicName, params, "inner");
            return logicResult.parseResponseJson();
        });
    }

    public JSONObject remoteRun(String serviceName, String logicName, JSONObject params) {
        return this.remoteRun(serviceName, logicName, params.toString());
    }

    public Object runExpression(String source, Map<String, Object> params) {
        return Expression.run((String)source, params);
    }

    private JSONObject buildLogicParams(String str) {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                Object dataParam;
                JSONObject st = (JSONObject)json;
                param = st;
                if (!param.isNull("data") && param.keySet().size() == 1 && (dataParam = param.get("data")) instanceof JSONObject) {
                    param = (JSONObject)dataParam;
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                JSONArray ar = (JSONArray)json;
                param = new JSONObject();
                param.put("arr", (Object)ar);
            }
        }
        return param;
    }

    private Object logicMonitor(String name, String path, String dataSource, String params, Supplier<Object> business) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            Object object = DynamicDataSource.withDataSource((String)dataSource, business);
            return object;
        }
        catch (Exception e) {
            throw this.buildServiceException(name, path, params, e);
        }
        finally {
            stopWatch.stop();
            this.logExecutionTime(name, stopWatch);
        }
    }

    private void logExecutionTime(String name, StopWatch stopWatch) {
        long elapsedTime = stopWatch.getTotalTimeMillis();
        String message = "Logic[" + name + "]\u5904\u7406\u8017\u65f6:" + elapsedTime + "ms";
        if (elapsedTime >= 8000L) {
            LOGGER.error(message);
        } else if (elapsedTime >= 4000L) {
            LOGGER.warn(message);
        } else {
            LOGGER.info(message);
        }
    }

    private Object runWithTransaction(Supplier<Object> business) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            Object result = business.get();
            this.transactionManager.commit(status);
            return result;
        }
        catch (Exception e) {
            this.transactionManager.rollback(status);
            throw e;
        }
    }

    private LogicException buildServiceException(String logicName, String logicPath, String logicParams, Exception ex) {
        Throwable cause = ex.getCause();
        LogicException originalLogicException = this.findOriginalLogicException(cause);
        if (originalLogicException != null) {
            return new LogicException(ex, originalLogicException.getCode(), logicName, logicParams, logicPath, originalLogicException);
        }
        if (cause instanceof LogicException) {
            LogicException logicException = (LogicException)cause;
            return new LogicException(logicException.getMessage(), logicException.getCode(), ex, logicName, logicParams, logicPath, logicException);
        }
        if (cause instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)cause;
            return new LogicException(serviceException.getMessage(), serviceException.getCode(), ex, logicName, logicParams, logicPath);
        }
        return new LogicException(ex, null, logicName, logicParams, logicPath, null);
    }

    private LogicException findOriginalLogicException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof LogicException) {
            LogicException logicException = (LogicException)throwable;
            for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof LogicException)) continue;
                LogicException deeper = this.findOriginalLogicException(cause);
                if (deeper != null) {
                    return deeper;
                }
                return (LogicException)cause;
            }
            return logicException;
        }
        return this.findOriginalLogicException(throwable.getCause());
    }

    public void deleteCache(String logicName) {
        String cacheKey = CacheKey.getLogicDataCacheKey((String)logicName, (String)"*");
        this.redisService.deleteKeysByPatternSafely(cacheKey);
        LOGGER.info("\u624b\u52a8\u6e05\u9664Logic[{}]\u7f13\u5b58\u5b8c\u6210", (Object)logicName);
    }

    private void performAuthorizationCheck(LogicMapper.LogicResource resource) {
        String[] permissions = resource.getPermissions();
        String[] roles = resource.getRoles();
        if (permissions != null && permissions.length > 0) {
            Logical permissionLogic = resource.getPermissionLogic();
            if (permissionLogic == Logical.AND) {
                this.authLogic.checkPermiAnd(permissions);
            } else {
                this.authLogic.checkPermiOr(permissions);
            }
        }
        if (roles != null && roles.length > 0) {
            Logical roleLogic = resource.getRoleLogic();
            if (roleLogic == Logical.AND) {
                this.authLogic.checkRoleAnd(roles);
            } else {
                this.authLogic.checkRoleOr(roles);
            }
        }
    }
}

