/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.utils.enums.LiuLiClientOperationalModeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@ConfigurationProperties(prefix="liuli")
@Component
public class LiuLiClientConfig {
    private static final Logger logger = LoggerFactory.getLogger(LiuLiClientConfig.class);
    private LiuLiClientOperationalModeEnum liuLiClientOperationalMode;
    private String apiUrl;
    private Boolean heartbeat;
    private Boolean uploadErrorLog;

    public Boolean getHeartbeat() {
        if (this.heartbeat == null) {
            this.heartbeat = true;
        }
        return this.heartbeat;
    }

    public void setHeartbeat(Boolean heartbeat) {
        this.heartbeat = heartbeat;
    }

    public Boolean getUploadErrorLog() {
        if (this.uploadErrorLog == null) {
            this.uploadErrorLog = true;
        }
        return this.uploadErrorLog;
    }

    public void setUploadErrorLog(Boolean uploadErrorLog) {
        this.uploadErrorLog = uploadErrorLog;
    }

    public LiuLiClientOperationalModeEnum getLiuLiClientOperationalMode() {
        if (this.liuLiClientOperationalMode == null) {
            this.liuLiClientOperationalMode = LiuLiClientOperationalModeEnum.NORMAL;
        }
        return this.liuLiClientOperationalMode;
    }

    public void setLiuLiClientOperationalMode(String liuLiClientOperationalMode) {
        this.liuLiClientOperationalMode = LiuLiClientOperationalModeEnum.toType(liuLiClientOperationalMode);
        if (this.liuLiClientOperationalMode == null) {
            throw new ServiceException("\u7409\u7483\u5ba2\u6237\u7aef\u8fd0\u884c\u6a21\u5f0f\u9519\u8bef\uff1a" + liuLiClientOperationalMode);
        }
        if (this.liuLiClientOperationalMode == LiuLiClientOperationalModeEnum.OFFLINE) {
            logger.warn("\u5df2\u5f00\u542f\u7409\u7483\u5ba2\u6237\u7aef**\u79bb\u7ebf\u5b89\u5168\u6a21\u5f0f**\uff0c\u8be5\u6a21\u5f0f\u4e0b\u6240\u6709\u4e1a\u52a1\u5c06\u4e0d\u518d\u5c1d\u8bd5\u8bbf\u95ee\u7409\u7483\u4e2d\u5fc3\uff0c\u4e14\u914d\u7f6e\u53ef\u80fd\u4f1a\u4ece\u5feb\u7167\u5907\u4efd\u4e2d\u83b7\u53d6\uff0c\u6240\u9020\u6210\u7684\u4e1a\u52a1\u98ce\u9669\u9700\u81ea\u884c\u627f\u62c5\uff01");
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }
}

