package com.af.v4.system.common.liuli.business.service;

import com.af.v4.system.api.RemoteLiuLiService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.constant.SecurityConstants;
import com.af.v4.system.common.core.constant.ServiceNameConstants;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.liuli.api.LiuLiApi;
import com.af.v4.system.common.liuli.config.LiuLiClientConfig;
import com.af.v4.system.common.liuli.utils.enums.LiuLiClientOperationalModeEnum;
import com.af.v4.system.common.plugins.http.RestAsyncTools;
import com.af.v4.system.common.plugins.http.config.HttpLogSuppressor;
import com.af.v4.system.common.plugins.http.core.response.EmptyAsyncResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * 琉璃-业务服务
 *
 * @author Mr.river
 * @since 2.13.0
 */
@Component
public class LiuLiBusinessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiBusinessService.class);

    private final ApplicationService applicationService;
    private final LiuLiClientConfig liuLiClientConfig;
    private final DynamicFeignClientFactory dynamicFeignClientFactory;
    private final LiuLiApi liuLiApi;

    public LiuLiBusinessService(ApplicationService applicationService, LiuLiClientConfig liuLiClientConfig, DynamicFeignClientFactory dynamicFeignClientFactory, LiuLiApi liuLiApi) {
        this.applicationService = applicationService;
        this.liuLiClientConfig = liuLiClientConfig;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
        this.liuLiApi = liuLiApi;
    }

    /**
     * 上报运行时错误记录
     */
    public void uploadRuntimeErrorRecord(JSONObject runtimeErrorRecord) {
        if (liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            return;
        }
        EnvType envType = applicationService.getEnvType();
        if (envType == EnvType.LOCAL) {
            return;
        }
        //调用琉璃中心需传递的参数
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantUUID", applicationService.getTenantName());
        jsonObject.put("applicationName", applicationService.getApplicationName());
        jsonObject.put("applicationVersion", ApplicationService.getAppVersion());
        jsonObject.put("coreVersion", ApplicationService.getSystemV4Version());
        jsonObject.put("osType", ApplicationService.getOSType());
        jsonObject.put("environment", applicationService.getEnvType().getValue());
        if (runtimeErrorRecord.has("errorMsg")) {
            jsonObject.put("errorMsg", StringUtils.substring(runtimeErrorRecord.getString("errorMsg").replace("'", "''"), 0, 8000));
        }
        if (runtimeErrorRecord.has("businessTitle")) {
            jsonObject.put("businessTitle", StringUtils.substring(runtimeErrorRecord.getString("businessTitle").replace("'", "''"), 0, 300));
        }

        HttpLogSuppressor.run(() -> {
            if (applicationService.getApplicationName().equals(ServiceNameConstants.LIULI_SERVICE)) {
                // 琉璃自身调用
                try {
                    SpringUtils.getBean(ILogicServiceProxy.class).run("uploadRuntimeErrorRecord", jsonObject);
                } catch (ServiceException ignored) {
                }
            } else if (liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
                RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService) dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, ServiceNameConstants.LIULI_SERVICE);
                remoteLiuLiService.uploadRuntimeErrorRecord(jsonObject.toString(), SecurityConstants.INNER);
            } else {
                RestAsyncTools.post(liuLiApi.getUploadRuntimeErrorRecordUrl(), jsonObject.toString(), null, new EmptyAsyncResponse());
            }
        });
    }
}
