/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.monitor.service;

import com.af.v4.system.api.RemoteLiuLiService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.proxy.liuli.ILiuLiMonitorServiceProxy;
import com.af.v4.system.common.core.proxy.logic.ILogicServiceProxy;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.liuli.api.LiuLiApi;
import com.af.v4.system.common.liuli.config.LiuLiClientConfig;
import com.af.v4.system.common.liuli.utils.enums.LiuLiClientOperationalModeEnum;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.plugins.http.RestAsyncTools;
import com.af.v4.system.common.plugins.http.config.HttpLogSuppressor;
import com.af.v4.system.common.plugins.http.core.response.EmptyAsyncResponse;
import com.af.v4.system.common.plugins.http.core.response.StandardAsyncResponse;
import com.af.v4.system.common.redis.RedisService;
import jakarta.annotation.PostConstruct;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class LiuLiMonitorService
implements ILiuLiMonitorServiceProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiMonitorService.class);
    private final ApplicationService applicationService;
    private final LiuLiClientConfig liuLiClientConfig;
    private final RedisService redisService;
    private final DynamicFeignClientFactory dynamicFeignClientFactory;
    private final LiuLiApi liuLiApi;

    public LiuLiMonitorService(ApplicationService applicationService, LiuLiClientConfig liuLiClientConfig, RedisService redisService, DynamicFeignClientFactory dynamicFeignClientFactory, LiuLiApi liuLiApi) {
        this.applicationService = applicationService;
        this.liuLiClientConfig = liuLiClientConfig;
        this.redisService = redisService;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
        this.liuLiApi = liuLiApi;
    }

    public static String geApplicationLockKey(String namespaceName) {
        return "LiuLiApplication@" + namespaceName;
    }

    public static String geApplicationHeartLockKey(String namespaceName) {
        return "LiuLiApplicationHeart@" + namespaceName;
    }

    @PostConstruct
    public void init() {
        if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            return;
        }
        EnvType envType = this.applicationService.getEnvType();
        String nowVersion = ApplicationService.getSystemV4Version();
        LOGGER.info("\ud83d\udc95\u6b22\u8fce\u4f7f\u7528Glaze Framework\uff0c\u7248\u672c\uff1aV{}", (Object)nowVersion);
        LOGGER.info("\ud83c\udf89\u7409\u7483\u6846\u67b6\u53d1\u5e03\u4e09\u5468\u5e74\uff0c\u611f\u8c22\u6709\u4f60");
        if (envType == EnvType.LOCAL) {
            this.checkV4Version(nowVersion);
        } else if (envType == EnvType.PROD) {
            this.uploadApplicationInfo();
        }
    }

    private void uploadApplicationInfo() {
        String applicationName = this.applicationService.getApplicationName();
        if (applicationName.equals("af-runtime")) {
            return;
        }
        String applicationLockKey = LiuLiMonitorService.geApplicationLockKey(applicationName);
        String flagKey = applicationLockKey + "Flag";
        this.redisService.lock(applicationLockKey, Integer.valueOf(60), Integer.valueOf(300), () -> {
            Object isUploadApplicationInfo = this.redisService.get(flagKey);
            if (isUploadApplicationInfo != null) {
                return;
            }
            JSONObject params = new JSONObject().put("tenantUUID", (Object)this.applicationService.getTenantName()).put("name", (Object)applicationName).put("coreVersion", (Object)ApplicationService.getSystemV4Version()).put("applicationVersion", (Object)ApplicationService.getAppVersion()).put("lastStartDate", (Object)DateTools.getNow2());
            StandardAsyncResponse.SuccessHandler handler = response -> {
                R result = R.build((JSONObject)new JSONObject(response));
                if (!result.isSuccess().booleanValue()) {
                    LOGGER.warn("\u5e94\u7528\u4fe1\u606f\u4e0a\u4f20\u5931\u8d25:{}", (Object)result.getMsg());
                }
            };
            if (applicationName.equals("af-liuli")) {
                JSONObject response2 = new JSONObject();
                try {
                    Object localResult = ((ILogicServiceProxy)SpringUtils.getBean(ILogicServiceProxy.class)).run("saveApplicationInfo", params);
                    response2.put("code", 200);
                    response2.put("data", localResult);
                }
                catch (ServiceException e) {
                    response2.put("code", (Object)e.getCode());
                    response2.put("msg", (Object)e.getMessage());
                }
                handler.run(response2.toString());
            } else if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
                RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
                R remoteResult = remoteLiuLiService.saveApplicationInfo(params.toString(), "inner");
                handler.run(remoteResult.parseResponseJson().toString());
            } else {
                HttpLogSuppressor.run(() -> RestAsyncTools.post((String)this.liuLiApi.getSaveApplicationInfoUrl(), (String)params.toString(), null, (FutureCallback)new StandardAsyncResponse(handler, e -> LOGGER.error("\u5e94\u7528\u4fe1\u606f\u4e0a\u4f20\u5931\u8d25:{}", (Object)e.getMessage()))));
            }
            this.redisService.set(flagKey, (Object)1, (Object)20);
        });
    }

    public void uploadLogicErrorLog(JSONObject operLog) {
        if (!this.liuLiClientConfig.getUploadErrorLog().booleanValue()) {
            return;
        }
        if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            return;
        }
        EnvType envType = this.applicationService.getEnvType();
        if (envType == EnvType.LOCAL) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantUUID", (Object)this.applicationService.getTenantName());
        jsonObject.put("applicationName", (Object)this.applicationService.getApplicationName());
        jsonObject.put("applicationVersion", (Object)ApplicationService.getAppVersion());
        jsonObject.put("coreVersion", (Object)ApplicationService.getSystemV4Version());
        jsonObject.put("osType", (Object)ApplicationService.getOSType());
        jsonObject.put("environment", (Object)this.applicationService.getEnvType().getValue());
        jsonObject.put("method", operLog.opt("f_method"));
        jsonObject.put("requestMethod", operLog.opt("f_request_method"));
        jsonObject.put("operIp", operLog.opt("f_oper_ip"));
        jsonObject.put("operUrl", operLog.opt("f_oper_url"));
        jsonObject.put("operName", operLog.opt("f_oper_name"));
        jsonObject.put("operParam", operLog.opt("f_oper_param"));
        jsonObject.put("errorMsg", operLog.opt("f_error_msg"));
        jsonObject.put("businessTitle", operLog.opt("f_title"));
        jsonObject.put("businessType", operLog.opt("f_business_type"));
        jsonObject.put("operatorType", operLog.opt("f_operator_type"));
        jsonObject.put("costTime", operLog.opt("f_cost_time"));
        HttpLogSuppressor.run(() -> {
            if (this.applicationService.getApplicationName().equals("af-liuli")) {
                try {
                    ((ILogicServiceProxy)SpringUtils.getBean(ILogicServiceProxy.class)).run("uploadErrorLog", jsonObject);
                }
                catch (ServiceException serviceException) {}
            } else if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
                RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
                remoteLiuLiService.uploadErrorLog(jsonObject.toString(), "inner");
            } else {
                RestAsyncTools.post((String)this.liuLiApi.getUploadErrorLogUrl(), (String)jsonObject.toString(), null, (FutureCallback)new EmptyAsyncResponse());
            }
        });
    }

    private void checkV4Version(String nowVersion) {
        String applicationName = this.applicationService.getApplicationName();
        if (applicationName.equals("af-runtime")) {
            return;
        }
        JSONObject params = new JSONObject().put("version", (Object)nowVersion);
        StandardAsyncResponse.SuccessHandler handler = response -> {
            R result = R.build((JSONObject)new JSONObject(response));
            if (result.isSuccess().booleanValue()) {
                if (((JSONObject)result.getData()).getBoolean("hasUpdate")) {
                    LOGGER.warn(((JSONObject)result.getData()).getString("msg"));
                }
            } else {
                LOGGER.warn("\u68c0\u67e5\u7409\u7483\u67b6\u6784\u7248\u672c\u5931\u8d25:{}", (Object)result.getMsg());
            }
        };
        if (applicationName.equals("af-liuli")) {
            JSONObject response2 = new JSONObject();
            try {
                Object localResult = ((ILogicServiceProxy)SpringUtils.getBean(ILogicServiceProxy.class)).run("checkV4Version", params);
                response2.put("code", 200);
                response2.put("data", localResult);
            }
            catch (ServiceException e) {
                response2.put("code", (Object)e.getCode());
                response2.put("msg", (Object)e.getMessage());
            }
            handler.run(response2.toString());
        } else if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
            RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
            R remoteResult = remoteLiuLiService.checkV4Version(params.toString(), "inner");
            handler.run(remoteResult.parseResponseJson().toString());
        } else {
            HttpLogSuppressor.run(() -> RestAsyncTools.post((String)this.liuLiApi.getCheckV4VersionUrl(), (String)params.toString(), null, (FutureCallback)new StandardAsyncResponse(handler, e -> LOGGER.error("\u68c0\u67e5\u7409\u7483\u67b6\u6784\u7248\u672c\u5931\u8d25:{}", (Object)e.getMessage()))));
        }
    }

    public void uploadTableInfo(JSONArray allTableInfo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantUUID", (Object)this.applicationService.getTenantName());
        jsonObject.put("tableArray", (Object)allTableInfo);
        HttpLogSuppressor.run(() -> {
            if (this.applicationService.getApplicationName().equals("af-liuli")) {
                try {
                    ((ILogicServiceProxy)SpringUtils.getBean(ILogicServiceProxy.class)).run("uploadTableInfo", jsonObject);
                }
                catch (ServiceException serviceException) {}
            } else if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
                RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
                remoteLiuLiService.uploadErrorLog(jsonObject.toString(), "inner");
            } else {
                RestAsyncTools.post((String)this.liuLiApi.getUploadTableInfoUrl(), (String)jsonObject.toString(), null, (FutureCallback)new EmptyAsyncResponse());
            }
        });
    }

    public void uploadHeartbeat() {
        if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.OFFLINE) {
            return;
        }
        if (!this.liuLiClientConfig.getHeartbeat().booleanValue()) {
            return;
        }
        String applicationName = this.applicationService.getApplicationName();
        if (applicationName.equals("af-runtime")) {
            return;
        }
        String applicationHeartLockKey = LiuLiMonitorService.geApplicationHeartLockKey(applicationName);
        String flagKey = applicationHeartLockKey + "Flag";
        this.redisService.lock(applicationHeartLockKey, Integer.valueOf(60), Integer.valueOf(300), () -> {
            Object isUploadApplicationHeart = this.redisService.get(flagKey);
            if (isUploadApplicationHeart != null) {
                return;
            }
            JSONObject params = new JSONObject().put("tenantUUID", (Object)this.applicationService.getTenantName()).put("name", (Object)applicationName);
            StandardAsyncResponse.SuccessHandler handler = response -> {
                R result = R.build((JSONObject)new JSONObject(response));
                if (!result.isSuccess().booleanValue()) {
                    LOGGER.warn("\u5fc3\u8df3\u4e0a\u4f20\u5931\u8d25:{}", (Object)result.getMsg());
                }
            };
            if (applicationName.equals("af-liuli")) {
                JSONObject response2 = new JSONObject();
                try {
                    Object localResult = ((ILogicServiceProxy)SpringUtils.getBean(ILogicServiceProxy.class)).run("uploadHeartBeat", params);
                    response2.put("code", 200);
                    response2.put("data", localResult);
                }
                catch (ServiceException e) {
                    response2.put("code", (Object)e.getCode());
                    response2.put("msg", (Object)e.getMessage());
                }
                handler.run(response2.toString());
            } else if (this.liuLiClientConfig.getLiuLiClientOperationalMode() == LiuLiClientOperationalModeEnum.INTRANET) {
                RemoteLiuLiService remoteLiuLiService = (RemoteLiuLiService)this.dynamicFeignClientFactory.getFeignClient(RemoteLiuLiService.class, "af-liuli");
                R remoteResult = remoteLiuLiService.uploadHeartBeat(params.toString(), "inner");
                handler.run(remoteResult.parseResponseJson().toString());
            } else {
                HttpLogSuppressor.run(() -> RestAsyncTools.post((String)this.liuLiApi.getUploadHeartbeatUrl(), (String)params.toString(), null, (FutureCallback)new StandardAsyncResponse(handler, e -> LOGGER.error("\u5fc3\u8df3\u4e0a\u4f20\u5931\u8d25:{}", (Object)e.getMessage()))));
            }
            this.redisService.set(flagKey, (Object)1, (Object)300);
        });
    }
}

