package com.af.v4.system.common.jpa.dialect;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

import static org.hibernate.type.SqlTypes.*;

/**
 * Clickhouse方言
 */
public class MyClickHouseDialect extends MySQLDialect {

    public MyClickHouseDialect() {
        super();
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        final DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(BOOLEAN, "UInt8", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(TINYINT, "Int8", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(SMALLINT, "Int16", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(INTEGER, "Int32", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(BIGINT, "Int64", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(FLOAT, "Float32", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(DOUBLE, "Float64", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(DATE, "Date", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(TIMESTAMP, "DateTime", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(VARCHAR, "String", this));
    }

    @Override
    public String getTableTypeString() {
        return String.format(" %s = MergeTree", "ENGINE");
    }
}
