/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.sensitive;

import com.af.v4.system.common.jpa.types.MetaData;
import com.af.v4.system.common.plugins.security.SubstitutionCipherUtil;
import java.util.Set;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
@ConfigurationProperties(prefix="security.sensitive")
public class SensitiveDataInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SensitiveDataInterceptor.class);
    private static final String PROTECTED_ROW_LOG = "[PROTECTED]";
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void beforeSave(String entityName, JSONObject row, MetaData metaData) {
        if (!this.enabled) {
            return;
        }
        if (metaData == null || !metaData.hasMetaAttributes()) {
            return;
        }
        Set<String> sensitiveFields = metaData.getSensitiveFieldNames();
        if (sensitiveFields.isEmpty()) {
            return;
        }
        try {
            this.applySensitiveFieldEncryption(entityName, row, sensitiveFields);
        }
        catch (Exception e) {
            this.handleProcessingError(entityName, row, e);
        }
    }

    private void handleProcessingError(String entityName, JSONObject row, Exception e) {
        String rowInfo = row != null ? PROTECTED_ROW_LOG : "null";
        log.error("\u654f\u611f\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u5c06\u8df3\u8fc7\u5904\u7406: {} -> {}, row={}", new Object[]{"beforeSave\u5904\u7406\u5931\u8d25", entityName, rowInfo, e});
    }

    private void handleFieldError(String fieldName, Exception e) {
        log.warn("{} \u5b57\u6bb5\u5904\u7406\u51fa\u9519: {} - {}", new Object[]{"\u5b57\u6bb5\u52a0\u5bc6\u56de\u5199", fieldName, e.getMessage()});
        if (log.isDebugEnabled()) {
            log.debug("{} \u5b57\u6bb5\u5904\u7406\u8be6\u7ec6\u9519\u8bef\u4fe1\u606f:", (Object)"\u5b57\u6bb5\u52a0\u5bc6\u56de\u5199", (Object)e);
        }
    }

    private void applySensitiveFieldEncryption(String entityName, JSONObject row, Set<String> sensitiveFields) {
        log.debug("\u5904\u7406\u654f\u611f\u5b57\u6bb5(\u5c31\u5730\u52a0\u5bc6): {}, \u5b57\u6bb5\u6570={}", (Object)entityName, (Object)sensitiveFields.size());
        sensitiveFields.stream().filter(fieldName -> row.opt(fieldName) != null).forEach(fieldName -> this.processSingleField((String)fieldName, row));
    }

    private void processSingleField(String fieldName, JSONObject row) {
        String val = row.opt(fieldName).toString();
        if (val.isBlank()) {
            return;
        }
        if (this.isMaskedValue(val)) {
            row.remove(fieldName);
            log.debug("\u68c0\u6d4b\u5230\u5df2\u8131\u654f\u8f93\u5165\uff0c\u8df3\u8fc7\u5b57\u6bb5\u66f4\u65b0: {}", (Object)fieldName);
            return;
        }
        if (SubstitutionCipherUtil.isStrictCipher((String)val)) {
            log.debug("\u68c0\u6d4b\u5230\u5df2\u662f\u66ff\u4ee3\u5bc6\u7801\u5bc6\u6587\uff0c\u8df3\u8fc7\u52a0\u5bc6: {} (\u7248\u672c: {})", (Object)fieldName, (Object)SubstitutionCipherUtil.parseVersion((String)val));
            return;
        }
        try {
            String cipher = SubstitutionCipherUtil.encrypt((String)val);
            if (cipher != null) {
                row.put(fieldName, (Object)cipher);
                log.debug("\u654f\u611f\u5b57\u6bb5\u5df2\u52a0\u5bc6\u5199\u56de: {} (\u7248\u672c: {}, \u539f\u6587\u957f\u5ea6: {}, \u5bc6\u6587\u957f\u5ea6: {})", new Object[]{fieldName, SubstitutionCipherUtil.getCurrentVersion(), val.length(), cipher.length()});
            }
        }
        catch (Exception ex) {
            this.handleFieldError(fieldName, ex);
        }
    }

    private boolean isMaskedValue(String value) {
        return value != null && value.indexOf(42) >= 0;
    }
}

