package com.af.v4.system.common.jpa.config;

import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactory;
import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactoryImpl;
import com.af.v4.system.common.jpa.dynamic.DynamicTransactionManager;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.annotation.Nonnull;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractApplicationContext;

/**
 * Hibernate配置
 *
 * @author Mr.river
 */
@Configuration
@ConfigurationProperties(prefix = "spring.datasource")
public class HibernateConfig implements ApplicationContextInitializer<AbstractApplicationContext> {

    @Bean(name = "entityManagerFactory")
    public DynamicSessionFactory dynamicSessionFactory() {
        return new DynamicSessionFactoryImpl();
    }

    @Bean
    public DynamicTransactionManager transactionManager() {
        DynamicTransactionManager transactionManager = new DynamicTransactionManager();
        // 注入sessionFactory
        transactionManager.setSessionFactory(dynamicSessionFactory());
        return transactionManager;
    }

    @Override
    public void initialize(@Nonnull AbstractApplicationContext context) {
        DataSourceProperties dataSourceProperties = context.getBean(DataSourceProperties.class);
        // 强制设置数据源，对旧版本的druid数据源配置兼容
        dataSourceProperties.setType(HikariDataSource.class);
    }
}

