/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.sensitive;

import com.af.v4.system.common.plugins.security.SubstitutionCipherUtil;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
@ConfigurationProperties(prefix="security.sensitive")
public class ConditionalEncryption {
    private static final Logger log = LoggerFactory.getLogger(ConditionalEncryption.class);
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private void handleFieldError(String fieldName, Exception e) {
        log.warn("{} \u5b57\u6bb5\u5904\u7406\u51fa\u9519: {} - {}", new Object[]{"\u5b57\u6bb5\u52a0\u5bc6\u56de\u5199", fieldName, e.getMessage()});
        if (log.isDebugEnabled()) {
            log.debug("{} \u5b57\u6bb5\u5904\u7406\u8be6\u7ec6\u9519\u8bef\u4fe1\u606f:", (Object)"\u5b57\u6bb5\u52a0\u5bc6\u56de\u5199", (Object)e);
        }
    }

    public JSONObject processConditionalEncryption(JSONArray conditionConfig, JSONObject data) {
        if (!this.enabled || conditionConfig == null || data == null) {
            return data;
        }
        Set<String> encryptionFields = this.extractEncryptionFields(conditionConfig);
        if (encryptionFields.isEmpty()) {
            log.debug("\u6ca1\u6709\u627e\u5230\u9700\u8981\u52a0\u5bc6\u7684\u5b57\u6bb5\u914d\u7f6e");
            return data;
        }
        log.debug("\u57fa\u4e8e\u6761\u4ef6\u914d\u7f6e\u8fdb\u884c\u52a0\u5bc6\uff0c\u5b57\u6bb5\u6570: {}", (Object)encryptionFields.size());
        JSONObject result = new JSONObject(data.toString());
        encryptionFields.stream().filter(fieldName -> result.opt(fieldName) != null).forEach(fieldName -> this.processSingleField((String)fieldName, result));
        return result;
    }

    private Set<String> extractEncryptionFields(JSONArray conditionConfig) {
        HashSet<String> encryptionFields = new HashSet<String>();
        for (int i = 0; i < conditionConfig.length(); ++i) {
            JSONObject configItem = conditionConfig.getJSONObject(i);
            if (!configItem.has("conditionDESENS") || !configItem.getBoolean("conditionDESENS") || !configItem.has("model")) continue;
            String model = configItem.getString("model");
            encryptionFields.add(model);
            log.debug("\u627e\u5230\u6761\u4ef6\u52a0\u5bc6\u5b57\u6bb5: {} -> {}", (Object)configItem.optString("name", "\u672a\u77e5"), (Object)model);
        }
        return encryptionFields;
    }

    private void processSingleField(String fieldName, JSONObject row) {
        Object fieldValue = row.opt(fieldName);
        if (fieldValue == null || row.isNull(fieldName)) {
            log.debug("\u5b57\u6bb5 {} \u503c\u4e3a null\uff0c\u8df3\u8fc7\u5904\u7406", (Object)fieldName);
            return;
        }
        if (fieldValue instanceof String) {
            this.processStringField(fieldName, (String)fieldValue, row);
        } else if (fieldValue instanceof JSONArray) {
            this.processArrayField(fieldName, (JSONArray)fieldValue, row);
        } else if (fieldValue instanceof Boolean) {
            log.debug("\u5b57\u6bb5 {} \u4e3a\u5e03\u5c14\u7c7b\u578b [{}]\uff0c\u8df3\u8fc7\u52a0\u5bc6", (Object)fieldName, fieldValue);
        } else if (fieldValue instanceof Number) {
            log.debug("\u5b57\u6bb5 {} \u4e3a\u6570\u503c\u7c7b\u578b [{}]\uff0c\u8df3\u8fc7\u52a0\u5bc6", (Object)fieldName, fieldValue);
        } else if (fieldValue instanceof JSONObject) {
            log.debug("\u5b57\u6bb5 {} \u4e3a\u5bf9\u8c61\u7c7b\u578b\uff0c\u8df3\u8fc7\u52a0\u5bc6", (Object)fieldName);
        } else {
            log.debug("\u5b57\u6bb5 {} \u4e3a\u672a\u77e5\u7c7b\u578b [{}]\uff0c\u8df3\u8fc7\u52a0\u5bc6", (Object)fieldName, (Object)fieldValue.getClass().getSimpleName());
        }
    }

    private void processStringField(String fieldName, String value, JSONObject row) {
        if (value.isBlank()) {
            log.debug("\u5b57\u6bb5 {} \u503c\u4e3a\u7a7a\u5b57\u7b26\u4e32\uff0c\u8df3\u8fc7\u5904\u7406", (Object)fieldName);
            return;
        }
        try {
            String cipher = SubstitutionCipherUtil.encrypt((String)value);
            if (cipher != null && !cipher.equals(value)) {
                row.put(fieldName, (Object)cipher);
                log.debug("\u654f\u611f\u5b57\u6bb5\u5df2\u52a0\u5bc6\u5199\u56de: {} (\u7248\u672c: {}, \u539f\u6587\u957f\u5ea6: {}, \u5bc6\u6587\u957f\u5ea6: {})", new Object[]{fieldName, SubstitutionCipherUtil.getCurrentVersion(), value.length(), cipher.length()});
            } else {
                log.warn("\u5b57\u6bb5 {} \u52a0\u5bc6\u5931\u8d25\u6216\u52a0\u5bc6\u524d\u540e\u65e0\u53d8\u5316", (Object)fieldName);
            }
        }
        catch (Exception ex) {
            this.handleFieldError(fieldName, ex);
        }
    }

    private void processArrayField(String fieldName, JSONArray array, JSONObject row) {
        boolean modified = false;
        for (int i = 0; i < array.length(); ++i) {
            String strElement;
            Object element = array.opt(i);
            if (!(element instanceof String) || (strElement = (String)element).isBlank()) continue;
            try {
                String cipher = SubstitutionCipherUtil.encrypt((String)strElement);
                if (cipher == null || cipher.equals(strElement)) continue;
                array.put(i, (Object)cipher);
                modified = true;
                log.debug("\u6570\u7ec4\u5b57\u6bb5 {}[{}] \u5df2\u52a0\u5bc6 (\u539f\u6587\u957f\u5ea6: {}, \u5bc6\u6587\u957f\u5ea6: {})", new Object[]{fieldName, i, strElement.length(), cipher.length()});
                continue;
            }
            catch (Exception ex) {
                log.error("\u52a0\u5bc6\u6570\u7ec4\u5b57\u6bb5 {}[{}] \u65f6\u51fa\u9519: {}", new Object[]{fieldName, i, ex.getMessage()});
            }
        }
        if (modified) {
            row.put(fieldName, (Object)array);
            log.info("\u6570\u7ec4\u5b57\u6bb5 {} \u52a0\u5bc6\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u4e2a\u5143\u7d20", (Object)fieldName, (Object)array.length());
        }
    }
}

