package com.af.v4.system.common.jpa.session;

import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.internal.SessionFactoryImpl;
import org.springframework.stereotype.Component;

/**
 * session池
 *
 * @author LocalUser
 */
@Component
public class SessionPool {
    private final DynamicSessionFactory dynamicSessionFactory;

    public SessionPool(DynamicSessionFactory dynamicSessionFactory) {
        this.dynamicSessionFactory = dynamicSessionFactory;
    }

    /**
     * 从sessionFactory中取
     *
     * @return session
     */
    public Session getSession() {
        SessionFactory factory = dynamicSessionFactory.getHibernateSessionFactory();
        return factory.getCurrentSession();
    }

    public SessionFactoryImpl getSessionFactory() {
        return dynamicSessionFactory.getHibernateSessionFactory().unwrap(SessionFactoryImpl.class);
    }

    public Metadata getMetaData() {
        return dynamicSessionFactory.getMetadata();
    }
}
