/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.utils;

import com.af.v4.system.common.core.proxy.jpa.IQueryParamsProxy;
import org.json.JSONObject;

public class QueryParams
implements IQueryParamsProxy {
    private final Integer pageNo;
    private final Integer pageSize;
    private final String dataSource;
    private final JSONObject parameterList;

    private QueryParams(Builder builder) {
        this.pageNo = builder.pageNo;
        this.pageSize = builder.pageSize;
        this.dataSource = builder.dataSource;
        this.parameterList = builder.parameterList;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public JSONObject getParameterList() {
        return this.parameterList;
    }

    public String toString() {
        return "pageNo = " + this.pageNo + ", pageSize = " + this.pageSize + ", dataSource = " + this.dataSource + ", params = " + String.valueOf(this.parameterList);
    }

    public static class Builder
    implements IQueryParamsProxy.Builder {
        private Integer pageNo;
        private Integer pageSize;
        private String dataSource;
        private JSONObject parameterList;

        public static Builder fromJSONObject(JSONObject jsonObject) {
            Builder builder = new Builder();
            if (jsonObject == null) {
                return builder;
            }
            if (jsonObject.has("pageNo")) {
                builder.pageNo(jsonObject.getInt("pageNo"));
            }
            if (jsonObject.has("pageSize")) {
                builder.pageSize(jsonObject.getInt("pageSize"));
            }
            if (jsonObject.has("dataSource")) {
                builder.dataSource(jsonObject.getString("dataSource"));
            }
            if (jsonObject.has("params")) {
                builder.parameterList(jsonObject.getJSONObject("params"));
            }
            return builder;
        }

        public Builder pageNo(Integer pageNo) {
            this.pageNo = pageNo;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder addParameter(String key, Object value) {
            if (this.parameterList == null) {
                this.parameterList = new JSONObject();
            }
            this.parameterList.put(key, (Object)value.toString());
            return this;
        }

        public boolean hasParameter(String key) {
            return this.parameterList != null && this.parameterList.has(key);
        }

        public Builder parameterList(JSONObject parameterList) {
            this.parameterList = parameterList;
            return this;
        }

        public IQueryParamsProxy build() {
            return new QueryParams(this);
        }
    }
}

