package com.af.v4.system.common.job.processer;

import com.af.v4.system.common.log.service.LogResolveService;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.json.JsonTools;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
 * Logic分页分批执行定时调度业务的简单封装
 */
@Component
public class SimpleLogicBatchPagingTimer extends GlazeBatchPagingTimer {
    /**
     * 获取批量数据的Logic名称
     */
    private static final String PARAMS_GET_BATCH_DATA_LOGIC_NAME = "getBatchDataLogicName";

    /**
     * 获取批量数据的Logic参数
     */
    private static final String PARAMS_GET_BATCH_DATA_LOGIC_PARAMS = "getBatchDataLogicParams";

    /**
     * 处理数据的Logic名称
     */
    private static final String PARAMS_HANDLE_DATA_LOGIC_NAME = "handleDataLogicName";

    public SimpleLogicBatchPagingTimer(LogResolveService logResolveService, LogicService logicService) {
        super(logResolveService, logicService);
    }

    @Override
    public JSONArray queryBatchData(JSONObject jobParams, int pageNo) {
        JSONObject queryParams = new JSONObject();
        JsonTools.addJSON(queryParams, jobParams.getJSONObject(PARAMS_GET_BATCH_DATA_LOGIC_PARAMS));
        queryParams.put("pageNo", pageNo);
        return (JSONArray) logicService.run(
                jobParams.getString(PARAMS_GET_BATCH_DATA_LOGIC_NAME),
                queryParams
        );
    }

    @Override
    public Object handle(JSONObject jobParams, JSONObject dataItem) {
        return logicService.run(jobParams.getString(PARAMS_HANDLE_DATA_LOGIC_NAME), dataItem);
    }
}
