/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.job.processer;

import com.af.v4.system.common.job.processer.GlazeBasicTimer;
import com.af.v4.system.common.log.service.LogResolveService;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.plugins.concurrent.LogicBatchTaskProcessor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.worker.core.processor.ProcessResult;

@Component
public abstract class GlazeBatchPagingTimer
extends GlazeBasicTimer {
    private final Logger LOGGER = LoggerFactory.getLogger(GlazeBatchPagingTimer.class);
    protected final LogicService logicService;

    public GlazeBatchPagingTimer(LogResolveService logResolveService, LogicService logicService) {
        super(logResolveService);
        this.logicService = logicService;
    }

    @Override
    public ProcessResult exec(JSONObject jobParams) throws InterruptedException {
        JSONObject batchResult = new JSONObject();
        LogicBatchTaskProcessor processor = new LogicBatchTaskProcessor();
        int pageNo = 1;
        int failCount = 0;
        int maxFail = 10;
        int totalItems = 0;
        int successCount = 0;
        int failureCount = 0;
        while (!Thread.currentThread().isInterrupted()) {
            JSONArray resultArray;
            try {
                resultArray = this.queryBatchData(jobParams, pageNo);
                failCount = 0;
            }
            catch (Exception e) {
                this.LOGGER.error("\u67e5\u8be2\u6570\u636e\u5931\u8d25", (Throwable)e);
                if (++failCount >= maxFail) {
                    this.LOGGER.error("\u67e5\u8be2\u6570\u636e\u5931\u8d25\u6b21\u6570\u8fc7\u591a\uff0c\u4efb\u52a1\u505c\u6b62");
                    break;
                }
                try {
                    TimeUnit.SECONDS.sleep(60L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw ie;
                }
            }
            if (resultArray == null || resultArray.isEmpty()) break;
            this.LOGGER.info("======\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\uff0c\u7b2c{}\u6279\u6b21\uff0c\u672c\u6279\u6b21\u5171{}\u6761=====", (Object)pageNo, (Object)resultArray.length());
            JSONObject result = processor.process(resultArray, item -> this.handle(jobParams, (JSONObject)item));
            totalItems += result.getInt("totalItems");
            successCount += result.getInt("successCount");
            failureCount += result.getInt("failureCount");
            this.LOGGER.info("======\u7b2c{}\u6279\u6b21\u6267\u884c\u5b8c\u6210=====", (Object)(++pageNo));
        }
        batchResult.put("totalItems", totalItems);
        batchResult.put("successCount", successCount);
        batchResult.put("failureCount", failureCount);
        this.LOGGER.info("\u5206\u9875\u6279\u91cf\u4efb\u52a1\u5904\u7406\u5b8c\u6210\uff0c\u7ed3\u679c\uff1a{}", (Object)batchResult);
        return new ProcessResult(true, batchResult.toString());
    }

    public abstract JSONArray queryBatchData(JSONObject var1, int var2);

    public abstract Object handle(JSONObject var1, JSONObject var2);
}

