/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.job.processer;

import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.log.enums.OperatorType;
import com.af.v4.system.common.log.service.LogResolveService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;

@Component
public abstract class GlazeBasicTimer
implements BasicProcessor {
    private final Logger LOGGER = LoggerFactory.getLogger(GlazeBasicTimer.class);
    private final LogResolveService logResolveService;

    protected GlazeBasicTimer(LogResolveService logResolveService) {
        this.logResolveService = logResolveService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult process(TaskContext taskContext) {
        this.LOGGER.info("\u5f00\u59cb\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff1a{}", (Object)taskContext.getTaskName());
        long beginTime = System.currentTimeMillis();
        JSONObject jobParams = taskContext.getJobParams() != null ? new JSONObject(taskContext.getJobParams()) : new JSONObject();
        try {
            ProcessResult result = this.exec(jobParams);
            long endTime = System.currentTimeMillis();
            this.handleLog(taskContext, null, endTime - beginTime);
            ProcessResult processResult = result;
            return processResult;
        }
        catch (Throwable e) {
            if (e instanceof LogicException) {
                LogicException ex = (LogicException)e;
                this.LOGGER.error("\u5b9a\u65f6\u4e1a\u52a1\u6267\u884c\u5931\u8d25\uff1a{}", (Object)ex.getStack());
            } else {
                this.LOGGER.error("\u5b9a\u65f6\u4e1a\u52a1\u6267\u884c\u5931\u8d25", e);
            }
            long endTime = System.currentTimeMillis();
            this.handleLog(taskContext, e, endTime - beginTime);
            ProcessResult processResult = new ProcessResult(false, "\u5b9a\u65f6\u4e1a\u52a1\u6267\u884c\u5931\u8d25:" + e.getMessage());
            return processResult;
        }
        finally {
            this.LOGGER.info("\u5b9a\u65f6\u4efb\u52a1\uff1a{}\u6267\u884c\u5b8c\u6210", (Object)taskContext.getTaskName());
        }
    }

    protected void handleLog(TaskContext taskContext, Throwable e, long costTime) {
        this.logResolveService.resolveLog(this.getClass().getName(), "process", BusinessType.LOGIC.name(), "\u6267\u884c\u5b9a\u65f6\u8c03\u5ea6\u4efb\u52a1\uff1a" + taskContext.getTaskName(), OperatorType.SYSTEM.name(), taskContext.getJobParams(), costTime, e);
    }

    public abstract ProcessResult exec(JSONObject var1);
}

