package com.af.v4.system.common.expression.core;

import org.springframework.lang.NonNull;

/**
 * Token
 *
 * @param type     Token类型
 * @param value    Token值
 * @param startPos 单词在串中的起始位置，包括空格
 * @author LocalUser
 */
public record Token(TokenType type, Object value, int startPos) {

    @Override
    @NonNull
    public String toString() {
        return type.toString() + value;
    }
}
