/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.expression.report.core;

import com.af.v4.system.common.expression.report.core.Block;
import com.af.v4.system.common.expression.report.core.BodyBlock;
import com.af.v4.system.common.expression.report.core.Cell;
import com.af.v4.system.common.expression.report.core.HeadBlock;
import com.af.v4.system.common.expression.report.core.LeftBlock;
import com.af.v4.system.common.expression.report.core.Report;
import com.af.v4.system.common.expression.report.core.Ret;
import java.util.List;
import org.dom4j.Element;

public class ReportBlock
extends Block {
    public final HeadBlock headBlock;
    public final LeftBlock leftBlock;
    public final BodyBlock bodyBlock;

    public ReportBlock(Element ele) {
        super(ele);
        Element eHead = ele.element("headblock");
        this.headBlock = new HeadBlock(eHead);
        Element eLeft = ele.element("leftblock");
        this.leftBlock = new LeftBlock(eLeft);
        Element eBody = ele.element("bodyblock");
        this.bodyBlock = new BodyBlock(eBody);
    }

    public ReportBlock(int row, int column, int rowSpan, int columnSpan, HeadBlock headBlock, LeftBlock leftBlock, BodyBlock bodyBlock) {
        super(row, column, rowSpan, columnSpan, "");
        this.headBlock = headBlock;
        this.leftBlock = leftBlock;
        this.bodyBlock = bodyBlock;
    }

    public void setRow(int row) {
        for (Cell cell : this.cells) {
            cell.row += row;
        }
        if (this.headBlock != null) {
            this.headBlock.setRow(row);
        }
        if (this.leftBlock != null) {
            this.leftBlock.setRow(row);
        }
        if (this.bodyBlock != null) {
            this.bodyBlock.setRowColumn(row, 0);
        }
    }

    @Override
    public void compile() {
        super.compile();
        if (this.headBlock != null) {
            this.headBlock.compile();
        }
        if (this.leftBlock != null) {
            this.leftBlock.compile();
        }
        if (this.bodyBlock != null) {
            this.bodyBlock.compile();
        }
    }

    @Override
    public void setReport(Report report) {
        super.setReport(report);
        if (this.headBlock != null) {
            this.headBlock.setReport(report);
        }
        if (this.leftBlock != null) {
            this.leftBlock.setReport(report);
        }
        if (this.bodyBlock != null) {
            this.bodyBlock.setReport(report);
        }
    }

    public int createCell(List<Cell> result) {
        this.headBlock.createCell(result);
        int copyRow = this.leftBlock.createCell(result);
        Ret ret = this.bodyBlock.createCell(result);
        for (Cell cell : this.cells) {
            if (cell instanceof Block) continue;
            result.add(cell.clone());
        }
        return copyRow + ret.copyRow;
    }
}

