package com.af.v4.system.common.excel.core;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.util.StyleUtil;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import org.apache.poi.ss.usermodel.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 样式
 *
 * @author Eraser
 */

public class CellColorSheetWriteHandler implements CellWriteHandler {
    /**
     * map
     * key：第i行--为-1时 则设置value中整列
     * value：第i行中单元格索引集合 --为List<-1>时 设置i整行
     */
    private final HashMap<Integer, List<Integer>> map;

    /**
     * 字体颜色
     */
    private final Short fontColorIndex;

    /**
     * 填充颜色
     */
    private final Short fullColorIndex;

    /**
     * 有参构造
     */
    public CellColorSheetWriteHandler(HashMap<Integer, List<Integer>> map, Short fontColorIndex, Short fullColorIndex) {
        this.map = map;
        this.fontColorIndex = fontColorIndex;
        this.fullColorIndex = fullColorIndex;
    }

    /**
     * 在单元上的所有操作完成后调用
     */
    @Override
    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        /*
          考虑到导出数据量过大的情况，不对每一行的每一个单元格进行样式设置，只设置必要行中的某个单元格的样式
         */
        //当前行的第col列
        int col = cell.getColumnIndex();
        int row = cell.getRowIndex();
        //不处理第一行
        if (0 != row) {
            List<Integer> integers = new ArrayList<>();
            if (map.get(-1) != null) {
                integers.addAll(map.get(-1));
            }
            if (map.get(row) != null) {
                integers.addAll(map.get(row));
            }
            if (!integers.isEmpty()) {
                if (integers.contains(col) || integers.contains(-1)) {
                    // 根据单元格获取workbook
                    Workbook workbook = cell.getSheet().getWorkbook();
                    // 单元格策略
                    WriteCellStyle contentCellStyle = getWriteCellStyle();
                    CellStyle cellStyle = StyleUtil.buildCellStyle(workbook, workbook.getCellStyleAt(0), contentCellStyle);
                    //设置当前行第col列的样式
                    cell.getRow().getCell(col).setCellStyle(cellStyle);
                }
            }
        }
    }

    private WriteCellStyle getWriteCellStyle() {
        WriteCellStyle contentCellStyle = new WriteCellStyle();
        // 设置水平居中为居中对齐
        contentCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        // 设置单元格上下左右边框为细边框
        contentCellStyle.setBorderBottom(BorderStyle.MEDIUM);
        contentCellStyle.setBorderLeft(BorderStyle.MEDIUM);
        contentCellStyle.setBorderRight(BorderStyle.MEDIUM);
        contentCellStyle.setBorderTop(BorderStyle.MEDIUM);
        // 创建字体实例
        WriteFont cellWriteFont = new WriteFont();
        //设置字体颜色
        cellWriteFont.setColor(fontColorIndex);
        //单元格颜色
        // 设置背景颜色
        contentCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        contentCellStyle.setFillForegroundColor(fullColorIndex);
        contentCellStyle.setWriteFont(cellWriteFont);
        return contentCellStyle;
    }
}
