/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.elasticsearch.common;

public class ESMappingGenerator {
    private final StringBuilder sb = new StringBuilder();
    private boolean isFirstField;

    public ESMappingGenerator() {
        this.sb.append("{\"properties\":{");
        this.isFirstField = true;
    }

    public void addField(String fieldName, String fieldType) {
        if (this.isFirstField) {
            this.sb.append("\"").append(fieldName).append("\"").append(":{\"type\":\"").append(fieldType).append("\", \"copy_to\":\"all_field_for_search\"}");
            this.isFirstField = false;
        } else {
            this.sb.append(",\"").append(fieldName).append("\"").append(":{\"type\":\"").append(fieldType).append("\", \"copy_to\":\"all_field_for_search\"}");
        }
    }

    public void addFieldWithAnalyzer(String fieldName, String analyzer) {
        if (this.isFirstField) {
            this.sb.append("\"").append(fieldName).append("\"").append(":{\"type\":\"text\", \"analyzer\":\"").append(analyzer).append("\", \"copy_to\":\"all_field_for_search\"}");
            this.isFirstField = false;
        } else {
            this.sb.append(",\"").append(fieldName).append("\"").append(":{\"type\":\"text\", \"analyzer\":\"").append(analyzer).append("\", \"copy_to\":\"all_field_for_search\"}");
        }
    }

    public String result() {
        this.sb.append(",\"all_field_for_search\":{\"type\":\"text\",\"analyzer\":\"ik_max_word\",\"store\":true}}}");
        return this.sb.toString();
    }
}

