package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.StrUtils;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;

import java.math.BigInteger;
import java.sql.Connection;
import java.util.UUID;

/**
 * Compress JDK UUID to 25 letters based on radix 36, use 0-9 a-z characters,
 * example: pbicz3grgu0zk3ipe1yur03h7
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class UUID25Generator implements IdGenerator {
    public static final UUID25Generator INSTANCE = new UUID25Generator();

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.UUID25;
    }

    @Override
    public String getIdGenName() {
        return "UUID25";
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        return getUUID25();
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }

    public static String getUUID25() {
        String uuidHex = UUID.randomUUID().toString().replace("-", "");
        BigInteger b = new BigInteger(uuidHex, 16);
        StringBuilder s = new StringBuilder(b.toString(36));
        while (s.length() < 25)
            s.append(StrUtils.getRandomChar());
        return s.toString();
    }

}
