package com.af.v4.system.common.datasource.dialects;

import java.io.Serial;

/**
 * DialectException for jDialects
 *
 * @since 1.0.0
 */
public class DialectException extends RuntimeException {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new runtime exception with {@code null} as its detail message.
     * The cause is not initialized, and may subsequently be initialized by a call to {@link #initCause}.
     */
    public DialectException() {
        // Default constructor
    }

    /**
     * Constructs a new runtime exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for later retrieval by the {@link #getMessage()} method.
     */
    public DialectException(String message) {
        super(message);
    }

    /**
     * Constructs a new runtime exception with the specified cause and a detail message of {@code (cause==null ? null : cause.toString())}
     * (which typically contains the class and detail message of {@code cause}).
     * This constructor is useful for runtime exceptions that are little more than wrappers for other throwables.
     *
     * @param cause the cause (which is saved for later retrieval by the {@link #getCause()} method).
     *              (A {@code null} value is permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public DialectException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new runtime exception with the specified detail message and cause.
     * <p>
     * Note that the detail message associated with {@code cause} is not automatically incorporated in this runtime exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the {@link #getCause()} method).
     *                (A {@code null} value is permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public DialectException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Throws a new {@code DialectException} with the specified error message and cause.
     *
     * @param errorMsg the error message.
     * @param e        the cause.
     * @return nothing as it always throws.
     */
    public static Object throwEX(String errorMsg, Throwable e) {
        throw new DialectException(errorMsg, e);
    }

    /**
     * Throws a new {@code DialectException} with the specified cause.
     *
     * @param cause the cause.
     * @return nothing as it always throws.
     */
    public static Object throwEX(Throwable cause) {
        throw new DialectException(cause);
    }

    /**
     * Throws a new {@code DialectException} with the specified error message.
     *
     * @param errorMsg the error message.
     * @return nothing as it always throws.
     */
    public static Object throwEX(String errorMsg) {
        throw new DialectException(errorMsg);
    }

    /**
     * Intentionally ignores the given exception.
     * This method can be used to silence exceptions that are deemed irrelevant or expected under certain circumstances.
     *
     * @param e the exception to be ignored.
     */
    public static void eatException(Exception e) {
        // Do nothing here
    }

    /**
     * Asserts that the specified object is not {@code null}.
     * Throws a {@code DialectException} with a default message or a given message if the object is {@code null}.
     *
     * @param obj            the object to check for nullity.
     * @param optionMessages optional messages to use if an assertion fails. If no messages are given, a default message is used.
     */
    public static void assureNotNull(Object obj, String... optionMessages) {
        if (obj == null)
            throw new DialectException(
                    optionMessages.length == 0 ? "Assert error, Object parameter can not be null" : optionMessages[0]);
    }

    /**
     * Asserts that the specified string is not {@code null} and not empty.
     * Throws a {@code DialectException} with a default message or a given message if the string is {@code null} or empty.
     *
     * @param str            the string to check for nullity and emptiness.
     * @param optionMessages optional messages to use if an assertion fails. If no messages are given, a default message is used.
     */
    public static void assureNotEmpty(String str, String... optionMessages) {
        if (str == null || str.isEmpty())
            throw new DialectException(
                    optionMessages.length == 0 ? "Assert error, String parameter can not be empty" : optionMessages[0]);
    }
}
