package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.DialectException;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;

import java.sql.Connection;

/**
 * SnowflakeGenerator is a special generator, only mark this column is a
 * snowflake type column, but getNextID() method does not work, because
 * snowflake value should generated by outside program, it depends on real
 * machine setting, in jDialects there is a SnowflakeCreator tool for these
 * outside program to use
 */
@SuppressWarnings("all")
public class SnowflakeGenerator implements IdGenerator {
    public final static SnowflakeGenerator INSTANCE = new SnowflakeGenerator();

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        throw new DialectException("Snowflake type column value should generated by outside program.");
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.SNOWFLAKE;
    }

    @Override
    public String getIdGenName() {
        return "SNOWFLAKE";
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

}