package com.af.v4.system.api.factory;

import com.af.v4.system.api.RemoteLogService;
import com.af.v4.system.common.core.domain.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 日志服务降级处理
 */
@Component
public class RemoteLogFallbackFactory implements FallbackFactory<RemoteLogService> {
    private static final Logger log = LoggerFactory.getLogger(RemoteLogFallbackFactory.class);

    @Override
    public RemoteLogService create(Throwable throwable) {
        log.warn("日志服务调用失败，{}", throwable.getMessage());
        return new RemoteLogService() {
            @Override
            public R<Boolean> saveLog(String sysOperLog, String source) {
                return R.fail(STR."保存操作日志失败:\{throwable.getMessage()}");
            }

            @Override
            public R<Boolean> saveLogininfor(String sysLogininfor, String source) {
                return R.fail(STR."保存登录日志失败:\{throwable.getMessage()}");
            }
        };

    }
}
