/*
 * Decompiled with CFR 0.152.
 */
package com.af.entity.ultils;

import com.af.entity.ultils.XMLColumnProperties;
import com.af.entity.ultils.scanHbmXmlToMD;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class XMLProperties {
    private String tableName;
    private String hbmPath;
    private String tableEntityName;
    private String PKName;
    private String PKType;
    private String PKGenerator;
    private String modalName;
    private List<XMLColumnProperties> columns = new ArrayList<XMLColumnProperties>();

    public String toString() {
        return "XMLProperties{tableName='" + this.tableName + "', tableEntityName='" + this.tableEntityName + "', PKName='" + this.PKName + "', PKType='" + this.PKType + "', PKGenerator='" + this.PKGenerator + "', columns=" + String.valueOf(this.columns) + "}";
    }

    public void toMD() {
        Map<String, String> tableCommentMap = scanHbmXmlToMD.allTableNameCommentMapping.get(this.modalName);
        int start = this.hbmPath.indexOf("hbm\\");
        String targetKey = this.hbmPath.substring(start + 4);
        String tableComment = "";
        if (!tableCommentMap.containsKey(targetKey)) {
            return;
        }
        tableComment = tableCommentMap.get(targetKey);
        StringBuilder sb = new StringBuilder();
        sb.append("# ").append(this.tableName).append("\n");
        sb.append("[HBM\u6587\u4ef6\u76f4\u8fbe\u94fe\u63a5](/").append(this.hbmPath.replaceAll("\\\\", "/")).append(")");
        sb.append("\n");
        sb.append("> \u8868\u540d\u5907\u6ce8\uff1a").append(tableComment).append("\n");
        sb.append(">\n");
        sb.append("> \u5b9e\u4f53\u540d\uff1a").append(this.tableEntityName).append("\n");
        sb.append("\n");
        sb.append("## \u4e3b\u952e\n");
        sb.append("> * \u4e3b\u952e\u540d\uff1a").append(this.PKName).append("\n");
        sb.append("> * \u4e3b\u952e\u7c7b\u578b\uff1a").append(this.PKType).append("\n");
        sb.append("> * \u4e3b\u952e\u751f\u6210\u7b56\u7565\uff1a").append(this.PKGenerator).append("\n");
        sb.append("\n");
        sb.append("## \u6570\u636e\n");
        sb.append("| \u6570\u636e\u540d | \u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u5217\u540d | \u6570\u636e\u7c7b\u578b | \u5907\u6ce8 |\n");
        sb.append("| :----: | :----------------: | :------: | :--: |\n");
        sb.append("| ").append(this.PKName).append(" | ").append(this.PKName).append(" | ").append(this.PKType).append(" | \u4e3b\u952e |\n");
        for (XMLColumnProperties properties : this.columns) {
            String name = properties.getName();
            String dbName = properties.getDBName();
            String type = properties.getType();
            String comment = properties.getComment();
            sb.append("| ").append(name).append(" | ").append(dbName).append(" | ").append(type).append(" | ").append(comment).append(" |\n");
        }
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        OutputStreamWriter fileWriter = null;
        try {
            File file = new File("doc/" + this.modalName + ".md");
            fileWriter = !file.exists() ? new FileWriter("doc/" + this.modalName + ".md", false) : new FileWriter("doc/" + this.modalName + ".md", true);
            fileWriter.write(sb.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                assert (fileWriter != null);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getModalName() {
        return this.modalName;
    }

    public String getHbmPath() {
        return this.hbmPath;
    }

    public void setHbmPath(String hbmPath) {
        this.hbmPath = hbmPath;
    }

    public void setModalName(String modalName) {
        this.modalName = modalName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableEntityName() {
        return this.tableEntityName;
    }

    public void setTableEntityName(String tableEntityName) {
        this.tableEntityName = tableEntityName;
    }

    public String getPKName() {
        return this.PKName;
    }

    public void setPKName(String PKName) {
        this.PKName = PKName;
    }

    public String getPKType() {
        return this.PKType;
    }

    public void setPKType(String PKType) {
        this.PKType = PKType;
    }

    public String getPKGenerator() {
        return this.PKGenerator;
    }

    public void setPKGenerator(String PKGenerator) {
        this.PKGenerator = PKGenerator;
    }

    public List<XMLColumnProperties> getColumns() {
        return this.columns;
    }

    public void setColumns(List<XMLColumnProperties> columns) {
        this.columns = columns;
    }
}

