/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.IndexOffsetOverflowException;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.MappedByteBuffers;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-e!B\u001d;\u0003\u0003y\u0004\u0002C+\u0001\u0005\u0003\u0007I\u0011\u0001,\t\u0011i\u0003!\u00111A\u0005\u0002mC\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006Ka\u0016\u0005\tS\u0002\u0011)\u0019!C\u0001U\"Aa\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005p\u0001\t\u0015\r\u0011\"\u0001q\u0011!!\bA!A!\u0002\u0013\t\b\u0002C;\u0001\u0005\u000b\u0007I\u0011\u0001<\t\u0011i\u0004!\u0011!Q\u0001\n]DQa\u001f\u0001\u0005\u0002qD!\"a\t\u0001\u0001\u0004\u0005\r\u0011\"\u0003k\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%I!a\n\t\u0015\u0005-\u0002\u00011A\u0001B\u0003&1\u000e\u0003\u0004\u00020\u00011\t\u0002\u001d\u0005\u0007\u0003c\u0001A\u0011\u00039\t\u0013\u0005M\u0002A1A\u0005\u0012\u0005U\u0002\u0002CA&\u0001\u0001\u0006I!a\u000e\t\u0013\u00055\u0003\u00011A\u0005\u0012\u0005=\u0003\"CA/\u0001\u0001\u0007I\u0011CA0\u0011!\t\u0019\u0007\u0001Q!\n\u0005E\u0003bBA4\u0001\u0001\u0006K!\u001d\u0005\t\u0003W\u0002\u0001\u0019!C\ta\"I\u0011Q\u000e\u0001A\u0002\u0013E\u0011q\u000e\u0005\b\u0003g\u0002\u0001\u0015)\u0003r\u0011\u0019\t9\b\u0001C\u0001m\"1\u0011\u0011\u0010\u0001\u0005\u0002ADa!a\u001f\u0001\t\u0003\u0001\bBBA?\u0001\u0011\u0005!\u000eC\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"9\u0011q\u0012\u0001\u0005\u0002\u0005E\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003/\u0003A\u0011AAI\u0011\u0019\tI\n\u0001C\u0001a\"9\u00111\u0014\u0001\u0005\u0002\u0005E\u0005bBAO\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003?\u0003a\u0011AAI\u0011\u001d\t\t\u000b\u0001D\t\u0003#Cq!a)\u0001\r\u0003\t)\u000bC\u0004\u0002,\u0002!\t!!%\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBA]\u0001\u0011E\u0011\u0011\u0013\u0005\t\u0003w\u0003A\u0011\u0003\u001e\u0002\u0012\"9\u0011Q\u0018\u0001\u0005\u0012\u0005}\u0006bBAo\u0001\u0019E\u0011q\u001c\u0005\b\u0003k\u0004A\u0011CA|\u0011\u001d\u0011\t\u0003\u0001C\t\u0005GAqAa\u000b\u0001\t\u0013\u0011i\u0003C\u0004\u0003<\u0001!IA!\u0010\t\u000f\t\u001d\u0003\u0001\"\u0003\u0003J!9!1\u000b\u0001\u0005\n\tUs!\u0003B0u\u0005\u0005\t\u0012\u0001B1\r!I$(!A\t\u0002\t\r\u0004BB>7\t\u0003\u0011Y\u0007C\u0005\u0003nY\n\n\u0011\"\u0001\u0003p\ti\u0011IY:ue\u0006\u001cG/\u00138eKbT!a\u000f\u001f\u0002\u00071|wMC\u0001>\u0003\u0015Y\u0017MZ6b\u0007\u0001)R\u0001QA\u0002\u0003/\u0019B\u0001A!J\u001fB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0005Y\u0006twMC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!\u001b%AB(cU\u0016\u001cG\u000f\u0005\u0002K\u001b6\t1J\u0003\u0002M\u000b\u0006\u0011\u0011n\\\u0005\u0003\u001d.\u0013\u0011b\u00117pg\u0016\f'\r\\3\u0011\u0005A\u001bV\"A)\u000b\u0005Ic\u0014!B;uS2\u001c\u0018B\u0001+R\u0005\u001daunZ4j]\u001e\fAAZ5mKV\tq\u000b\u0005\u0002K1&\u0011\u0011l\u0013\u0002\u0005\r&dW-\u0001\u0005gS2,w\fJ3r)\ta&\r\u0005\u0002^A6\taLC\u0001`\u0003\u0015\u00198-\u00197b\u0013\t\tgL\u0001\u0003V]&$\bbB2\u0003\u0003\u0003\u0005\raV\u0001\u0004q\u0012\n\u0014!\u00024jY\u0016\u0004\u0003FA\u0002g!\tiv-\u0003\u0002i=\nAao\u001c7bi&dW-\u0001\u0006cCN,wJ\u001a4tKR,\u0012a\u001b\t\u0003;2L!!\u001c0\u0003\t1{gnZ\u0001\fE\u0006\u001cXm\u00144gg\u0016$\b%\u0001\u0007nCbLe\u000eZ3y'&TX-F\u0001r!\ti&/\u0003\u0002t=\n\u0019\u0011J\u001c;\u0002\u001b5\f\u00070\u00138eKb\u001c\u0016N_3!\u0003!9(/\u001b;bE2,W#A<\u0011\u0005uC\u0018BA=_\u0005\u001d\u0011un\u001c7fC:\f\u0011b\u001e:ji\u0006\u0014G.\u001a\u0011\u0002\rqJg.\u001b;?)%i\u00181DA\u000f\u0003?\t\t\u0003E\u0003\u007f\u0001}\f)\"D\u0001;!\u0011\t\t!a\u0001\r\u0001\u00119\u0011Q\u0001\u0001C\u0002\u0005\u001d!!A&\u0012\t\u0005%\u0011q\u0002\t\u0004;\u0006-\u0011bAA\u0007=\n9aj\u001c;iS:<\u0007cA/\u0002\u0012%\u0019\u00111\u00030\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002\u0002\u0005]AaBA\r\u0001\t\u0007\u0011q\u0001\u0002\u0002-\")QK\u0003a\u0001/\")\u0011N\u0003a\u0001W\"9qN\u0003I\u0001\u0002\u0004\t\b\"B;\u000b\u0001\u00049\u0018aB0mK:<G\u000f[\u0001\f?2,gn\u001a;i?\u0012*\u0017\u000fF\u0002]\u0003SAqa\u0019\u0007\u0002\u0002\u0003\u00071.\u0001\u0005`Y\u0016tw\r\u001e5!Q\tia-A\u0005f]R\u0014\u0018pU5{K\u0006aql^1s[\u0016sGO]5fg\u0006!An\\2l+\t\t9\u0004\u0005\u0003\u0002:\u0005\u001dSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u000b1|7m[:\u000b\t\u0005\u0005\u00131I\u0001\u000bG>t7-\u001e:sK:$(bAA#\u000b\u0006!Q\u000f^5m\u0013\u0011\tI%a\u000f\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003\u0015awnY6!\u0003\u0011iW.\u00199\u0016\u0005\u0005E\u0003\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]S)A\u0002oS>LA!a\u0017\u0002V\t\u0001R*\u00199qK\u0012\u0014\u0015\u0010^3Ck\u001a4WM]\u0001\t[6\f\u0007o\u0018\u0013fcR\u0019A,!\u0019\t\u0011\r\u001c\u0012\u0011!a\u0001\u0003#\nQ!\\7ba\u0002B#\u0001\u00064\u0002\u0017}k\u0017\r_#oiJLWm\u001d\u0015\u0003+\u0019\f\u0001bX3oiJLWm]\u0001\r?\u0016tGO]5fg~#S-\u001d\u000b\u00049\u0006E\u0004bB2\u0018\u0003\u0003\u0005\r!]\u0001\n?\u0016tGO]5fg\u0002B#\u0001\u00074\u0002\r%\u001ch)\u001e7m\u0003)i\u0017\r_#oiJLWm]\u0001\bK:$(/[3t\u0003\u0019aWM\\4uQ\u00061!/Z:ju\u0016$2a^AB\u0011\u0019\t))\ba\u0001c\u00069a.Z<TSj,\u0017\u0001\u0003:f]\u0006lW\rV8\u0015\u0007q\u000bY\t\u0003\u0004\u0002\u000ez\u0001\raV\u0001\u0002M\u0006)a\r\\;tQR\tA,\u0001\beK2,G/Z%g\u000bbL7\u000f^:\u0015\u0003]\fq\u0002\u001e:j[R{g+\u00197jINK'0Z\u0001\fg&TX-\u00138CsR,7/A\u0003dY>\u001cX-\u0001\u0007dY>\u001cX\rS1oI2,'/A\u0006tC:LG/_\"iK\u000e\\\u0017\u0001\u0003;sk:\u001c\u0017\r^3\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000eF\u0002]\u0003OCa!!+(\u0001\u0004Y\u0017AB8gMN,G/A\u0003sKN,G/\u0001\bsK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\u0007E\f\t\f\u0003\u0004\u0002*&\u0002\ra[\u0001\u0010G\u0006t\u0017\t\u001d9f]\u0012|eMZ:fiR\u0019q/a.\t\r\u0005%&\u00061\u0001l\u00039\u0019\u0018MZ3G_J\u001cW-\u00168nCB\f!BZ8sG\u0016,f.\\1q\u0003%i\u0017-\u001f2f\u0019>\u001c7.\u0006\u0003\u0002B\u0006\u001dG\u0003BAb\u0003+$B!!2\u0002LB!\u0011\u0011AAd\t\u001d\tI-\fb\u0001\u0003\u000f\u0011\u0011\u0001\u0016\u0005\t\u0003\u001blC\u00111\u0001\u0002P\u0006\u0019a-\u001e8\u0011\u000bu\u000b\t.!2\n\u0007\u0005MgL\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\t\u0019$\fa\u0001\u0003/\u0004B!!\u000f\u0002Z&!\u00111\\A\u001e\u0005\u0011aunY6\u0002\u0015A\f'o]3F]R\u0014\u0018\u0010\u0006\u0004\u0002b\u0006\u001d\u0018\u0011\u001f\t\u0004}\u0006\r\u0018bAAsu\tQ\u0011J\u001c3fq\u0016sGO]=\t\u000f\u0005%h\u00061\u0001\u0002l\u00061!-\u001e4gKJ\u0004B!a\u0015\u0002n&!\u0011q^A+\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0007\u0003gt\u0003\u0019A9\u0002\u00039\f\u0001\u0004\\1sO\u0016\u001cH\u000fT8xKJ\u0014u.\u001e8e'2|GOR8s)\u001d\t\u0018\u0011`A\u007f\u0005\u0003Aq!a?0\u0001\u0004\tY/A\u0002jIbDa!a@0\u0001\u0004Y\u0017A\u0002;be\u001e,G\u000fC\u0004\u0003\u0004=\u0002\rA!\u0002\u0002\u0019M,\u0017M]2i\u000b:$\u0018\u000e^=\u0011\t\t\u001d!1\u0004\b\u0005\u0005\u0013\u00119B\u0004\u0003\u0003\f\tUa\u0002\u0002B\u0007\u0005'i!Aa\u0004\u000b\u0007\tEa(\u0001\u0004=e>|GOP\u0005\u0002{%\u00111\bP\u0005\u0004\u00053Q\u0014aD%oI\u0016D8+Z1sG\"$\u0016\u0010]3\n\t\tu!q\u0004\u0002\u0012\u0013:$W\r_*fCJ\u001c\u0007.\u00128uSRL(b\u0001B\ru\u0005I2/\\1mY\u0016\u001cH/\u00169qKJ\u0014u.\u001e8e'2|GOR8s)\u001d\t(Q\u0005B\u0014\u0005SAq!a?1\u0001\u0004\tY\u000f\u0003\u0004\u0002\u0000B\u0002\ra\u001b\u0005\b\u0005\u0007\u0001\u0004\u0019\u0001B\u0003\u0003EIg\u000eZ3y'2|GOU1oO\u00164uN\u001d\u000b\t\u0005_\u0011)Da\u000e\u0003:A)QL!\rrc&\u0019!1\u00070\u0003\rQ+\b\u000f\\33\u0011\u001d\tY0\ra\u0001\u0003WDa!a@2\u0001\u0004Y\u0007b\u0002B\u0002c\u0001\u0007!QA\u0001\u0012G>l\u0007/\u0019:f\u0013:$W\r_#oiJLHcB9\u0003@\t\r#Q\t\u0005\b\u0005\u0003\u0012\u0004\u0019AAq\u0003)Ig\u000eZ3y\u000b:$(/\u001f\u0005\u0007\u0003\u007f\u0014\u0004\u0019A6\t\u000f\t\r!\u00071\u0001\u0003\u0006\u0005A\"o\\;oI\u0012{wO\u001c+p\u000bb\f7\r^'vYRL\u0007\u000f\\3\u0015\u000bE\u0014YEa\u0014\t\r\t53\u00071\u0001r\u0003\u0019qW/\u001c2fe\"1!\u0011K\u001aA\u0002E\faAZ1di>\u0014\u0018A\u0003;p%\u0016d\u0017\r^5wKR!!q\u000bB/!\u0011i&\u0011L9\n\u0007\tmcL\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003S#\u0004\u0019A6\u0002\u001b\u0005\u00137\u000f\u001e:bGRLe\u000eZ3y!\tqhgE\u00027\u0005K\u00022!\u0018B4\u0013\r\u0011IG\u0018\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u0005\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0004\u0003r\t\u001d%\u0011R\u000b\u0003\u0005gR3!\u001dB;W\t\u00119\b\u0005\u0003\u0003z\t\rUB\u0001B>\u0015\u0011\u0011iHa \u0002\u0013Ut7\r[3dW\u0016$'b\u0001BA=\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015%1\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GaBA\u0003q\t\u0007\u0011q\u0001\u0003\b\u00033A$\u0019AA\u0004\u0001")
public abstract class AbstractIndex<K, V>
implements Closeable,
Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long _length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    private volatile int _maxEntries;
    private volatile int _entries;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractIndex abstractIndex = this;
        synchronized (abstractIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    private long _length() {
        return this._length;
    }

    private void _length_$eq(long x$1) {
        this._length = x$1;
    }

    public abstract int entrySize();

    public int _warmEntries() {
        return 8192 / this.entrySize();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this._maxEntries;
    }

    public int maxEntries() {
        return this._maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this._length();
    }

    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            int roundedNewSize = this.roundDownToExactMultiple(newSize, this.entrySize());
            if (this._length() == (long)roundedNewSize) {
                bl = false;
            } else {
                RandomAccessFile raf = new RandomAccessFile(this.file(), "rw");
                try {
                    int position = this.mmap().position();
                    if (OperatingSystem.IS_WINDOWS) {
                        this.safeForceUnmap();
                    }
                    raf.setLength(roundedNewSize);
                    this._length_$eq(roundedNewSize);
                    this.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    $this._maxEntries = this.mmap().limit() / this.entrySize();
                    this.mmap().position(position);
                    bl = true;
                }
                finally {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
            }
            return bl;
        }));
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.mmap().force());
    }

    public boolean deleteIfExists() {
        this.closeHandler();
        return Files.deleteIfExists(this.file().toPath());
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.resize(this.entrySize() * this._entries()));
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    @Override
    public void close() {
        this.trimToValidSize();
        this.closeHandler();
    }

    public void closeHandler() {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.safeForceUnmap());
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public int relativeOffset(long offset) {
        Option<Object> relativeOffset = this.toRelative(offset);
        if (relativeOffset.isEmpty()) {
            throw new IndexOffsetOverflowException(new StringBuilder(32).append("Integer overflow for offset: ").append(offset).append(" (").append(this.file().getAbsoluteFile()).append(")").toString());
        }
        return BoxesRunTime.unboxToInt((Object)relativeOffset.get());
    }

    public boolean canAppendOffset(long offset) {
        return this.toRelative(offset).isDefined();
    }

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error unmapping index ").append(this.file()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap((String)this.file().getAbsolutePath(), (MappedByteBuffer)this.mmap());
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock, Function0<T> fun) {
        Object object;
        if (OperatingSystem.IS_WINDOWS) {
            lock.lock();
        }
        try {
            object = fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock.unlock();
            }
        }
        return (T)object;
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        int firstHotEntry = Math.max(0, this._entries() - 1 - this._warmEntries());
        if (this.compareIndexEntry(this.parseEntry(idx, firstHotEntry), target, searchEntity) < 0) {
            return this.binarySearch$1(firstHotEntry, this._entries() - 1, idx, target, searchEntity);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        return this.binarySearch$1(0, firstHotEntry, idx, target, searchEntity);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        int n;
        Enumeration.Value value = searchEntity;
        Enumeration.Value value2 = IndexSearchType$.MODULE$.KEY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
        } else {
            Enumeration.Value value4 = IndexSearchType$.MODULE$.VALUE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            } else {
                throw new MatchError((Object)value);
            }
        }
        return n;
    }

    private int roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private Option<Object> toRelative(long offset) {
        long relativeOffset = offset - this.baseOffset();
        return relativeOffset < 0L || relativeOffset > Integer.MAX_VALUE ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((int)relativeOffset)));
    }

    private final Tuple2 binarySearch$1(int begin, int end, ByteBuffer idx$1, long target$1, Enumeration.Value searchEntity$1) {
        int lo = begin;
        int hi = end;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx$1, mid);
            int compareResult = this.compareIndexEntry(found, target$1, searchEntity$1);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        MappedByteBuffer mappedByteBuffer;
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        Logging.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder(24).append("Invalid max index size: ").append(maxIndexSize).toString());
                }
                raf.setLength(this.roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this._length_$eq(raf.length());
            MappedByteBuffer idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this._length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this._length());
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.roundDownToExactMultiple(idx.limit(), this.entrySize()));
            mappedByteBuffer = idx;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        this.mmap = mappedByteBuffer;
        this._maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

