/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

public class Log {
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARN = 3;
    public static final int LEVEL_ERROR = 4;
    public static final int LEVEL_FATAL = 5;
    private static int MSG_LEVEL = 0;
    private static int currentDevelopState = 3;
    private static MessageHandler gHandler = new MessageHandler(){

        @Override
        public int onOutput(int level, String tag, String msg, Throwable tr) {
            if (!Log.checkLevel(level)) {
                return 0;
            }
            if (tr != null) {
                switch (level) {
                    case 0: {
                        return android.util.Log.v((String)tag, (String)msg, (Throwable)tr);
                    }
                    case 1: {
                        return android.util.Log.d((String)tag, (String)msg, (Throwable)tr);
                    }
                    case 2: {
                        return android.util.Log.i((String)tag, (String)msg, (Throwable)tr);
                    }
                    case 3: {
                        return android.util.Log.w((String)tag, (String)msg, (Throwable)tr);
                    }
                    case 4: {
                        return android.util.Log.e((String)tag, (String)msg, (Throwable)tr);
                    }
                    case 5: {
                        return android.util.Log.wtf((String)tag, (String)msg, (Throwable)tr);
                    }
                }
            } else {
                switch (level) {
                    case 0: {
                        return android.util.Log.v((String)tag, (String)msg);
                    }
                    case 1: {
                        return android.util.Log.d((String)tag, (String)msg);
                    }
                    case 2: {
                        return android.util.Log.i((String)tag, (String)msg);
                    }
                    case 3: {
                        return android.util.Log.w((String)tag, (String)msg);
                    }
                    case 4: {
                        return android.util.Log.e((String)tag, (String)msg);
                    }
                    case 5: {
                        return android.util.Log.wtf((String)tag, (String)msg);
                    }
                }
            }
            return 0;
        }
    };

    private static boolean checkLevel(int level) {
        if (currentDevelopState == 1 && level < 3) {
            return false;
        }
        return level >= MSG_LEVEL;
    }

    public static void setLogLevel(int level) {
        MSG_LEVEL = level;
    }

    public static void setMessageHandler(MessageHandler handler) {
        if (handler == null) {
            return;
        }
        gHandler = handler;
    }

    public static int v(String tag, String msg) {
        return gHandler.onOutput(0, tag, msg, null);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return gHandler.onOutput(0, tag, msg, tr);
    }

    public static int d(String tag, String msg) {
        return gHandler.onOutput(1, tag, msg, null);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return gHandler.onOutput(1, tag, msg, tr);
    }

    public static int w(String tag, String msg) {
        return gHandler.onOutput(3, tag, msg, null);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return gHandler.onOutput(3, tag, msg, tr);
    }

    public static int e(String tag, String msg) {
        return gHandler.onOutput(4, tag, msg, null);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return gHandler.onOutput(4, tag, msg, tr);
    }

    public static int i(String tag, String msg) {
        return gHandler.onOutput(2, tag, msg, null);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return gHandler.onOutput(2, tag, msg, tr);
    }

    public static int wtf(String tag, String msg) {
        return gHandler.onOutput(5, tag, msg, null);
    }

    public static int wtf(String tag, String msg, Throwable tr) {
        return gHandler.onOutput(5, tag, msg, tr);
    }

    public static interface MessageHandler {
        public int onOutput(int var1, String var2, String var3, Throwable var4);
    }
}

