/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import com.landicorp.android.eptapi.utils.BinaryData;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class CStruct
implements BinaryData,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean fromBinary(byte[] data) {
        String[] fieldNames = this.getDeclaredMemberNames();
        int offset = 0;
        for (int i = 0; i < fieldNames.length; ++i) {
            Field field = null;
            try {
                field = this.getClass().getDeclaredField(fieldNames[i]);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            Class<Object> type = field.getType();
            try {
                if (type.isAssignableFrom(byte[].class)) {
                    byte[] d = (byte[])field.get(this);
                    CStruct.ensureBinaryDataSource(data, offset, d.length);
                    System.arraycopy(data, offset, d, 0, d.length);
                    offset += d.length;
                } else if (type.isAssignableFrom(Byte.TYPE)) {
                    CStruct.ensureBinaryDataSource(data, offset, 1);
                    field.setByte(this, data[offset]);
                    ++offset;
                } else if (type.isAssignableFrom(Boolean.TYPE)) {
                    CStruct.ensureBinaryDataSource(data, offset, 1);
                    field.setBoolean(this, data[offset] != 0);
                    ++offset;
                } else if (type.isAssignableFrom(Integer.TYPE)) {
                    CStruct.ensureBinaryDataSource(data, offset, 4);
                    int paddingLen = 4 - offset % 4;
                    if (paddingLen != 4) {
                        offset += paddingLen;
                    }
                    field.setInt(this, (data[offset + 3] & 0xFF) << 24 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 1] & 0xFF) << 8 | data[offset] & 0xFF);
                    offset += 4;
                } else if (type.isAssignableFrom(Short.TYPE)) {
                    CStruct.ensureBinaryDataSource(data, offset, 2);
                    int paddingLen = 2 - offset % 2;
                    if (paddingLen != 2) {
                        offset += paddingLen;
                    }
                    field.setShort(this, (short)((data[offset + 1] & 0xFF) << 8 | data[offset] & 0xFF));
                    offset += 2;
                }
                if (accessible) continue;
                field.setAccessible(false);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static void ensureBinaryDataSource(byte[] src, int offset, int size) {
        if (src == null || src.length == 0) {
            throw new IndexOutOfBoundsException("source binary data is null or empty!");
        }
        if (offset + size > src.length) {
            throw new IndexOutOfBoundsException(String.format("source length: %d, offset: %d, size: %d", src.length, offset, size));
        }
    }

    @Override
    public byte[] toBinary() {
        String[] fieldNames = this.getDeclaredMemberNames();
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        int totalSize = 0;
        boolean hasInt = false;
        boolean hasShort = false;
        for (int i = 0; i < fieldNames.length; ++i) {
            Field field = null;
            try {
                field = this.getClass().getDeclaredField(fieldNames[i]);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            Class<Object> type = field.getType();
            try {
                byte[] padding;
                if (type.isAssignableFrom(byte[].class)) {
                    byte[] d = (byte[])field.get(this);
                    data.add(d);
                    totalSize += d.length;
                } else if (type.isAssignableFrom(Byte.TYPE)) {
                    data.add(this.makeByteArray(field.getByte(this)));
                    ++totalSize;
                } else if (type.isAssignableFrom(Boolean.TYPE)) {
                    data.add(this.makeByteArray(field.getBoolean(this)));
                    ++totalSize;
                } else if (type.isAssignableFrom(Integer.TYPE)) {
                    hasInt = true;
                    padding = this.makePadding(4 - totalSize % 4, true);
                    if (padding != null) {
                        data.add(padding);
                        totalSize += padding.length;
                    }
                    data.add(this.makeByteArray(field.getInt(this)));
                    totalSize += 4;
                } else if (type.isAssignableFrom(Short.TYPE)) {
                    hasShort = false;
                    padding = this.makePadding(2 - totalSize % 2, false);
                    if (padding != null) {
                        data.add(padding);
                        totalSize += padding.length;
                    }
                    data.add(this.makeByteArray(field.getShort(this)));
                    totalSize += 2;
                }
                if (accessible) continue;
                field.setAccessible(false);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        int lastPaddingLen = hasInt ? 4 - totalSize % 4 : (hasShort ? 2 - totalSize % 2 : 0);
        byte[] padding = this.makePadding(lastPaddingLen, hasInt);
        if (padding != null) {
            data.add(padding);
            totalSize += padding.length;
        }
        byte[] result = new byte[totalSize];
        totalSize = 0;
        for (byte[] d : data) {
            System.arraycopy(d, 0, result, totalSize, d.length);
            totalSize += d.length;
        }
        return result;
    }

    private byte[] makeByteArray(int data) {
        return new byte[]{(byte)(data & 0xFF), (byte)(data >> 8), (byte)(data >> 16), (byte)(data >> 24)};
    }

    private byte[] makeByteArray(boolean data) {
        return new byte[]{(byte)(data ? 1 : 0)};
    }

    private byte[] makeByteArray(byte data) {
        return new byte[]{data};
    }

    private byte[] makeByteArray(short data) {
        return new byte[]{(byte)(data & 0xFF), (byte)(data >> 8)};
    }

    private byte[] makePadding(int len, boolean pad4) {
        if (len == 0) {
            return null;
        }
        if (pad4 && len == 4) {
            return null;
        }
        if (!pad4 && len == 2) {
            return null;
        }
        return new byte[len];
    }

    protected void setString(byte[] member, String value) {
        try {
            System.arraycopy(value.getBytes("GBK"), 0, member, 0, value.length());
            for (int i = value.length(); i < member.length; ++i) {
                member[i] = 0;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected int strlen(byte[] value) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] != 0) continue;
            return i;
        }
        return value.length;
    }

    protected String getString(byte[] strData) {
        return StringUtil.fromGBK(strData);
    }

    protected void setBytes(byte[] member, byte[] value) {
        if (member == null) {
            return;
        }
        if (value == null) {
            Arrays.fill(member, (byte)0);
            return;
        }
        int copySize = Math.min(member.length, value.length);
        System.arraycopy(value, 0, member, 0, copySize);
    }

    protected abstract String[] getDeclaredMemberNames();
}

