/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class BytesUtil {
    private static final String EMPTY_STRING = "";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String CHARSET_ISO8859_1 = "ISO-8859-1";
    private static final String CHARSET_GBK = "GBK";
    private static final String CHARSET_GB2312 = "GB2312";
    private static final String CHARSET_UTF8 = "UTF-8";

    private BytesUtil() {
    }

    public static String bytes2HexString(byte[] data) {
        if (BytesUtil.isNullEmpty(data)) {
            return EMPTY_STRING;
        }
        StringBuilder buffer = new StringBuilder();
        for (byte b : data) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                buffer.append('0');
            }
            buffer.append(hex);
        }
        return buffer.toString().toUpperCase();
    }

    public static byte[] hexString2Bytes(String data) {
        if (BytesUtil.isNullEmpty(data)) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[(data.length() + 1) / 2];
        if ((data.length() & 1) == 1) {
            data = data + "0";
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(BytesUtil.hex2byte(data.charAt(i * 2 + 1)) | BytesUtil.hex2byte(data.charAt(i * 2)) << 4);
        }
        return result;
    }

    public static byte hex2byte(char hex) {
        if (hex <= 'f' && hex >= 'a') {
            return (byte)(hex - 97 + 10);
        }
        if (hex <= 'F' && hex >= 'A') {
            return (byte)(hex - 65 + 10);
        }
        if (hex <= '9' && hex >= '0') {
            return (byte)(hex - 48);
        }
        return 0;
    }

    public static byte[] subBytes(byte[] data, int offset, int len) {
        if (BytesUtil.isNullEmpty(data)) {
            return null;
        }
        if (offset < 0 || data.length <= offset) {
            return null;
        }
        if (len < 0 || data.length < offset + len) {
            len = data.length - offset;
        }
        byte[] ret = new byte[len];
        System.arraycopy(data, offset, ret, 0, len);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] merage(byte[] ... data) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            for (byte[] d : data) {
                if (d == null) {
                    throw new IllegalArgumentException(EMPTY_STRING);
                }
                buffer.write(d);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                buffer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public static int bytesToInt(byte[] bytes) {
        if (BytesUtil.isNullEmpty(bytes)) {
            return 0;
        }
        if (bytes.length > 4) {
            return -1;
        }
        int lastIndex = bytes.length - 1;
        int result = 0;
        for (int i = 0; i < bytes.length; ++i) {
            result |= (bytes[i] & 0xFF) << (lastIndex - i << 3);
        }
        return result;
    }

    public static int littleEndianBytesToInt(byte[] bytes) {
        if (BytesUtil.isNullEmpty(bytes)) {
            return 0;
        }
        if (bytes.length > 4) {
            return -1;
        }
        int result = 0;
        for (int i = 0; i < bytes.length; ++i) {
            result |= (bytes[i] & 0xFF) << (i << 3);
        }
        return result;
    }

    public static byte[] intToBytes(int intValue) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(intValue >> (3 - i << 3) & 0xFF);
        }
        return bytes;
    }

    public static byte[] intToLittleEndianBytes(int intValue) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(intValue >> (i << 3) & 0xFF);
        }
        return bytes;
    }

    public static String bcd2Ascii(byte[] bcd) {
        if (BytesUtil.isNullEmpty(bcd)) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder(bcd.length << 1);
        for (byte ch : bcd) {
            byte half;
            sb.append((char)(half + ((half = (byte)((ch & 0xF0) >> 4)) > 9 ? 55 : 48)));
            half = (byte)(ch & 0xF);
            sb.append((char)(half + (half > 9 ? 55 : 48)));
        }
        return sb.toString();
    }

    public static byte[] ascii2Bcd(String ascii) {
        if (BytesUtil.isNullEmpty(ascii)) {
            return EMPTY_BYTE_ARRAY;
        }
        if ((ascii.length() & 1) == 1) {
            ascii = "0" + ascii;
        }
        byte[] asc = ascii.getBytes();
        byte[] bcd = new byte[ascii.length() >> 1];
        for (int i = 0; i < bcd.length; ++i) {
            bcd[i] = (byte)(BytesUtil.hex2byte((char)asc[2 * i]) << 4 | BytesUtil.hex2byte((char)asc[2 * i + 1]));
        }
        return bcd;
    }

    public static byte[] toBytes(String data, String charsetName) {
        if (BytesUtil.isNullEmpty(data)) {
            return EMPTY_BYTE_ARRAY;
        }
        try {
            return data.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] toBytes(String data) {
        return BytesUtil.toBytes(data, CHARSET_ISO8859_1);
    }

    public static byte[] toGBK(String data) {
        return BytesUtil.toBytes(data, CHARSET_GBK);
    }

    public static byte[] toGB2312(String data) {
        return BytesUtil.toBytes(data, CHARSET_GB2312);
    }

    public static byte[] toUtf8(String data) {
        return BytesUtil.toBytes(data, CHARSET_UTF8);
    }

    public static String fromBytes(byte[] data, String charsetName) {
        try {
            return new String(data, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String fromBytes(byte[] data) {
        return BytesUtil.fromBytes(data, CHARSET_ISO8859_1);
    }

    public static String fromGBK(byte[] data) {
        return BytesUtil.fromBytes(data, CHARSET_GBK);
    }

    public static String fromGB2312(byte[] data) {
        return BytesUtil.fromBytes(data, CHARSET_GB2312);
    }

    public static String fromUtf8(byte[] data) {
        return BytesUtil.fromBytes(data, CHARSET_UTF8);
    }

    public static int bcd2Int(byte[] data) {
        if (BytesUtil.isNullEmpty(data)) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < data.length; ++i) {
            byte bcd = data[i];
            int part = (bcd >> 4 & 0xF) * 10 + (bcd & 0xF);
            result = result * 100 + part;
        }
        return result;
    }

    public static boolean isAllNullEmpty(String ... strings) {
        for (String str : strings) {
            if (BytesUtil.isNullEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNullEmpty(byte[] ... arrays) {
        for (byte[] array : arrays) {
            if (BytesUtil.isNullEmpty(array)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNullEmpty(byte[] array) {
        return array == null || array.length == 0;
    }
}

