/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import com.landicorp.android.eptapi.utils.BytesUtil;

public class BytesBuffer {
    private byte[] data;

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toHexString() {
        if (this.data == null) {
            return null;
        }
        return BytesUtil.bytes2HexString(this.data);
    }

    public BytesBuffer subBytes(int offset, int len) {
        BytesBuffer buffer = new BytesBuffer();
        buffer.setData(BytesUtil.subBytes(this.data, offset, len));
        return buffer;
    }

    public boolean contains(byte[] data) {
        return this.indexOf(data) > -1;
    }

    public boolean startsWith(byte[] data) {
        return this.indexOf(data) == 0;
    }

    public boolean endsWith(byte[] data) {
        return this.lastIndexOf(data) + data.length == this.data.length;
    }

    public int lastIndexOf(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("param is null!");
        }
        if (this.data == null || this.data.length < data.length) {
            return -1;
        }
        byte last = data[data.length - 1];
        int secondLen = data.length - 1;
        for (int i = this.data.length - 1; i >= secondLen; --i) {
            int n;
            if (this.data[i] != last) continue;
            for (n = 0; n < secondLen && this.data[i - data.length + n + 1] == data[n]; ++n) {
            }
            if (n != secondLen) continue;
            return i - data.length + 1;
        }
        return -1;
    }

    public int indexOf(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("param is null!");
        }
        if (this.data == null || this.data.length < data.length) {
            return -1;
        }
        int limit = this.data.length - data.length + 1;
        for (int i = 0; i < limit; ++i) {
            int n;
            if (this.data[i] != data[0]) continue;
            for (n = 1; n < data.length && this.data[i + n] == data[n]; ++n) {
            }
            if (n != data.length) continue;
            return i;
        }
        return -1;
    }
}

