/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.service;

import android.os.Binder;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.SparseArray;
import com.landicorp.android.eptapi.listener.EventCode;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.ApplicationController;
import java.util.LinkedList;

class ObserverBinder
extends Binder {
    static final Logger logger = Logger.getLogger(ObserverBinder.class);
    private SparseArray<LinkedList<RemoteListener>> mListeners = new SparseArray();
    private ApplicationController mAppCtl = null;

    ObserverBinder() {
    }

    public void setApplicationController(ApplicationController ctl) {
        this.mAppCtl = ctl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        logger.debug("## onTransact | code: 0x" + Integer.toHexString(code) + ", tid: " + Thread.currentThread().getId() + ", thread; " + Thread.currentThread().getName() + ", callingPid: " + ObserverBinder.getCallingPid(), new Object[0]);
        if (code == 256 && this.mAppCtl != null) {
            this.mAppCtl.quitApp();
            return super.onTransact(code, data, reply, flags);
        }
        try {
            int callingPid = ObserverBinder.getCallingPid();
            this.mAppCtl.setIPCInvokePid(callingPid);
            SparseArray<LinkedList<RemoteListener>> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                int eventCode = data.readInt();
                logger.info("# [MC EVENT] -> " + EventCode.getDescription(eventCode), new Object[0]);
                LinkedList listeners = (LinkedList)this.mListeners.get(eventCode);
                if (listeners != null && !listeners.isEmpty()) {
                    logger.info("------------------LISTENER IS OK--------------", new Object[0]);
                    RemoteListener listener = (RemoteListener)listeners.getFirst();
                    if (listener != null) {
                        Parcel newData = Parcel.obtain();
                        newData.appendFrom(data, data.dataPosition(), data.dataSize() - data.dataPosition());
                        newData.setDataPosition(0);
                        listener.notifyData(newData);
                        logger.info("------------------LISTENER done--------------", new Object[0]);
                    } else {
                        logger.info("------------------LISTENER IS null--------------", new Object[0]);
                    }
                } else {
                    logger.info("------------------LISTENER IS null--------------", new Object[0]);
                }
                boolean bl = super.onTransact(code, data, reply, flags);
                return bl;
            }
        }
        finally {
            this.mAppCtl.clearIPCInvokePid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installListener(RemoteListener listener) {
        SparseArray<LinkedList<RemoteListener>> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            LinkedList<RemoteListener> list = (LinkedList<RemoteListener>)this.mListeners.get(listener.getEventId());
            if (list == null) {
                list = new LinkedList<RemoteListener>();
                this.mListeners.put(listener.getEventId(), list);
                list.add(listener);
            } else if (!list.contains(listener)) {
                list.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallListener(RemoteListener listener) {
        SparseArray<LinkedList<RemoteListener>> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            LinkedList list = (LinkedList)this.mListeners.get(listener.getEventId());
            if (list != null) {
                list.remove(listener);
                listener.onDetached();
                if (list.isEmpty()) {
                    this.mListeners.remove(listener.getEventId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallListeners(int id) {
        SparseArray<LinkedList<RemoteListener>> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            LinkedList list = (LinkedList)this.mListeners.get(id);
            this.mListeners.remove(id);
            if (list != null) {
                for (RemoteListener listener : list) {
                    listener.onDetached();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySerivceCrash() {
        SparseArray<LinkedList<RemoteListener>> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            int size = this.mListeners.size();
            for (int i = 0; i < size; ++i) {
                for (RemoteListener listener : (LinkedList)this.mListeners.valueAt(i)) {
                    if (listener == null) continue;
                    listener.notifyRemoteCrash();
                }
            }
            this.mListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        SparseArray<LinkedList<RemoteListener>> sparseArray = this.mListeners;
        synchronized (sparseArray) {
            int size = this.mListeners.size();
            for (int i = 0; i < size; ++i) {
                for (RemoteListener listener : (LinkedList)this.mListeners.valueAt(i)) {
                    if (listener == null) continue;
                    listener.onDetached();
                }
            }
            this.mListeners.clear();
        }
    }
}

