/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.service;

import android.net.LocalServerSocket;
import android.net.LocalSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class LocalSocketService {
    private LocalServerSocket listenSocket;
    private String serviceName;
    private Thread workThread;
    private LocalSocket clientSocket;
    private boolean isOneTimeMode;
    private boolean isAbort;

    public LocalSocketService(String serviceName, boolean isOneTimeMode) {
        this.serviceName = serviceName;
        this.isOneTimeMode = isOneTimeMode;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public boolean isRunning() {
        return this.workThread != null && this.workThread.isAlive();
    }

    public void startup() {
        if (this.isRunning()) {
            return;
        }
        this.isAbort = false;
        this.workThread = this.createWorkThread();
        this.workThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownListenSocket() {
        block5: {
            try {
                LocalServerSocket socket = this.listenSocket;
                if (socket == null) break block5;
                LocalServerSocket localServerSocket = socket;
                synchronized (localServerSocket) {
                    socket.close();
                    this.listenSocket = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownClientSocket() {
        block5: {
            try {
                LocalSocket socket = this.clientSocket;
                if (socket == null) break block5;
                LocalSocket localSocket = socket;
                synchronized (localSocket) {
                    socket.close();
                    this.clientSocket = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdown() {
        this.shutdownListenSocket();
        this.shutdownClientSocket();
        this.isAbort = true;
    }

    private Thread createWorkThread() {
        return new Thread(){

            @Override
            public void run() {
                try {
                    LocalSocketService.this.shutdownListenSocket();
                    LocalServerSocket socket = LocalSocketService.this.createServerSocket();
                    do {
                        LocalSocket client = LocalSocketService.this.socketAccept(socket);
                        if (LocalSocketService.this.isOneTimeMode) {
                            LocalSocketService.this.shutdownListenSocket();
                        }
                        LocalSocketService.this.doClientWork(client);
                    } while (!LocalSocketService.this.isOneTimeMode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private LocalServerSocket createServerSocket() throws IOException {
        LocalServerSocket socket;
        this.listenSocket = socket = new LocalServerSocket(this.serviceName);
        return socket;
    }

    private LocalSocket socketAccept(LocalServerSocket socket) throws IOException {
        LocalSocket client;
        this.clientSocket = client = socket.accept();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doClientWork(LocalSocket clientSocket) {
        try {
            InputStream stream = clientSocket.getInputStream();
            while (true) {
                if (stream.available() == 0) {
                    if (!this.isAbort) continue;
                    return;
                }
                LocalSocket localSocket = clientSocket;
                synchronized (localSocket) {
                    if (!this.onDataAvailable(stream, clientSocket.getOutputStream())) {
                        return;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected LocalSocket getClientSocket() {
        return this.clientSocket;
    }

    protected abstract boolean onDataAvailable(InputStream var1, OutputStream var2);
}

