/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.log;

import android.text.TextUtils;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARN = 3;
    public static final int LEVEL_ERROR = 4;
    public static final int LEVEL_FATAL = 5;
    public static final int LEVEL_CLOSE = 10;
    private static final String TAG_LOGGER = "[Logger]";
    private static volatile int sLogLevel = 0;
    private static LoggerHandler sLoggerHandler = new LoggerHandler(){

        @Override
        public void onOutput(int level, String tag, String msg, Throwable tr) {
            if (tr != null) {
                switch (level) {
                    case 0: {
                        Log.v((String)tag, (String)msg, (Throwable)tr);
                        break;
                    }
                    case 1: {
                        Log.d((String)tag, (String)msg, (Throwable)tr);
                        break;
                    }
                    case 2: {
                        Log.i((String)tag, (String)msg, (Throwable)tr);
                        break;
                    }
                    case 3: {
                        Log.w((String)tag, (String)msg, (Throwable)tr);
                        break;
                    }
                    case 4: {
                        Log.e((String)tag, (String)msg, (Throwable)tr);
                        break;
                    }
                    case 5: {
                        Log.wtf((String)tag, (String)msg, (Throwable)tr);
                        break;
                    }
                }
            } else {
                switch (level) {
                    case 0: {
                        Log.v((String)tag, (String)msg);
                        break;
                    }
                    case 1: {
                        Log.d((String)tag, (String)msg);
                        break;
                    }
                    case 2: {
                        Log.i((String)tag, (String)msg);
                        break;
                    }
                    case 3: {
                        Log.w((String)tag, (String)msg);
                        break;
                    }
                    case 4: {
                        Log.e((String)tag, (String)msg);
                        break;
                    }
                    case 5: {
                        Log.wtf((String)tag, (String)msg);
                        break;
                    }
                }
            }
        }
    };
    private static Map<String, Logger> LOGGER_CACHE = new HashMap<String, Logger>();
    private String tagName;

    private Logger(String tagName) {
        this.tagName = Logger.safeGetName(tagName);
    }

    private static String safeGetName(String tagName) {
        return TextUtils.isEmpty((CharSequence)tagName) ? TAG_LOGGER : tagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String tagName) {
        Map<String, Logger> map = LOGGER_CACHE;
        synchronized (map) {
            if (LOGGER_CACHE.containsKey(tagName)) {
                return LOGGER_CACHE.get(tagName);
            }
            Logger logger = new Logger(tagName);
            LOGGER_CACHE.put(tagName, logger);
            return logger;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getSimpleName());
    }

    public static void setLogLevel(int level) {
        if (level >= 0) {
            sLogLevel = level;
        }
    }

    public static void setLoggerHandler(LoggerHandler handler) {
        if (handler != null) {
            sLoggerHandler = handler;
        }
    }

    public void detail(String msg, Object ... args) {
        Logger.output(0, this.tagName, null, msg, args);
    }

    public void detail(Throwable tr, String msg, Object ... args) {
        Logger.output(0, this.tagName, tr, msg, args);
    }

    public void debug(String msg, Object ... args) {
        Logger.output(1, this.tagName, null, msg, args);
    }

    public void debug(Throwable tr, String msg, Object ... args) {
        Logger.output(1, this.tagName, tr, msg, args);
    }

    public void info(String msg, Object ... args) {
        Logger.output(2, this.tagName, null, msg, args);
    }

    public void info(Throwable tr, String msg, Object ... args) {
        Logger.output(2, this.tagName, tr, msg, args);
    }

    public void warn(String msg, Object ... args) {
        Logger.output(3, this.tagName, null, msg, args);
    }

    public void warn(Throwable tr, String msg, Object ... args) {
        Logger.output(3, this.tagName, tr, msg, args);
    }

    public void error(String msg, Object ... args) {
        Logger.output(4, this.tagName, null, msg, args);
    }

    public void error(Throwable tr, String msg, Object ... args) {
        Logger.output(4, this.tagName, tr, msg, args);
    }

    public void wtf(String msg, Object ... args) {
        Logger.output(5, this.tagName, null, msg, args);
    }

    public void wtf(Throwable tr, String msg, Object ... args) {
        Logger.output(5, this.tagName, tr, msg, args);
    }

    private static void output(int level, String tag, Throwable tr, String msg, Object ... args) {
        if (level >= sLogLevel) {
            String message = Logger.buildMessage(msg, args);
            sLoggerHandler.onOutput(level, tag, message, tr);
        }
    }

    private static String buildMessage(String message, Object ... args) {
        return args == null || args.length == 0 ? message : String.format(message, args);
    }

    public static interface LoggerHandler {
        public void onOutput(int var1, String var2, String var3, Throwable var4);
    }
}

