/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.listener;

import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.text.TextUtils;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.utils.PausableHandler;

public abstract class RemoteListener {
    private static final Logger logger = Logger.getLogger(RemoteListener.class);
    public static final int FORBIDDEN = 1001;
    public static final int INTERRUPTED = 1002;
    private static Handler mMainHandler = new Handler(Looper.getMainLooper());
    private PausableHandler mPauseHandler = null;
    private Handler mHandler = null;
    private boolean runOnIPCThread;
    private String packageName;

    public RemoteListener() {
        this(Looper.getMainLooper());
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public RemoteListener(Looper l) {
        if (l != Looper.getMainLooper()) {
            this.mHandler = new Handler(l);
        }
    }

    public RemoteListener(PausableHandler handler) {
        this.mPauseHandler = handler;
    }

    public abstract int getEventId();

    public final void setRunOnIPCThread() {
        this.runOnIPCThread = true;
    }

    protected final Handler getHandler() {
        if (this.mHandler == null) {
            return mMainHandler;
        }
        return this.mHandler;
    }

    protected final PausableHandler getPausableHandler() {
        return this.mPauseHandler;
    }

    protected abstract void onListened(Parcel var1);

    public final void notifyData(final Parcel data) {
        this.post(new Runnable(){

            @Override
            public void run() {
                logger.debug("## onListened | packageName: " + (TextUtils.isEmpty((CharSequence)RemoteListener.this.packageName) ? "" : RemoteListener.this.packageName) + ", tid: " + Thread.currentThread().getId() + ", thread: " + Thread.currentThread().getName(), new Object[0]);
                RemoteListener.this.onListened(data);
                data.recycle();
            }
        });
    }

    protected final void post(Runnable r) {
        if (this.runOnIPCThread) {
            r.run();
            return;
        }
        if (this.getPausableHandler() != null) {
            this.getPausableHandler().post(r);
        } else {
            this.getHandler().post(r);
        }
    }

    protected final void runOnUIThread(Runnable task) {
        if (task != null) {
            mMainHandler.post(task);
        }
    }

    public final void notifyRemoteCrash() {
        this.post(new Runnable(){

            @Override
            public void run() {
                RemoteListener.this.onCrash();
            }
        });
    }

    public abstract void onCrash();

    public void onDetached() {
    }

    public void onInterrupted() {
    }
}

