/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.file;

import com.landicorp.android.eptapi.file.IBlackFile;

public class BlackFile {
    public static final int MIN_RECORD_SIZE = 1;
    public static final int MAX_RECORD_SIZE = 512;
    public static final int MIN_RECORD_COUNT = 1;
    private IBlackFile bFile;

    public BlackFile(String fileName) {
        this.bFile = new IBlackFile(fileName);
    }

    public boolean createFile(int size, int count) {
        BlackFile.checkRange(1, 512, size);
        BlackFile.checkFloor(1, count);
        return this.bFile.createFile(size, count);
    }

    public boolean isExists(byte[] record) {
        return this.bFile.isExists(record);
    }

    public int appendBase(byte[] record, int count) {
        return this.bFile.appendBase(record, count);
    }

    public int add(byte[] record, int count) {
        return this.bFile.add(record, count);
    }

    public boolean delete(byte[] record, int count) {
        return this.bFile.delete(record, count);
    }

    public boolean cleanFile() {
        return this.bFile.cleanFile();
    }

    public boolean deleteFile() {
        return this.bFile.deleteFile();
    }

    static void checkRange(int min, int max, int actual) {
        if (actual < min || actual > max) {
            throw new IllegalArgumentException("Actua: " + actual + " out of range[" + min + " - " + max + "]");
        }
    }

    static void checkFloor(int floor, int actual) {
        if (actual < floor) {
            throw new IllegalArgumentException("Actua: " + actual + " under limit: " + floor);
        }
    }
}

