/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.emv.kernel;

import android.os.Parcel;
import android.text.TextUtils;
import com.landicorp.android.eptapi.card.CpuCardDriver;
import com.landicorp.android.eptapi.card.InsertDriver;
import com.landicorp.android.eptapi.card.RFDriver;
import com.landicorp.android.eptapi.emv.EmvRequestExecutor;
import com.landicorp.android.eptapi.emv.data.EMVConfig;
import com.landicorp.android.eptapi.emv.kernel.EMVEventHandler;
import com.landicorp.android.eptapi.emv.process.data.CAPKey;
import com.landicorp.android.eptapi.emv.process.data.CVMData;
import com.landicorp.android.eptapi.emv.process.data.CandidateAIDInfo;
import com.landicorp.android.eptapi.emv.process.data.ECCLog;
import com.landicorp.android.eptapi.emv.process.data.FinalSelectData;
import com.landicorp.android.eptapi.emv.process.data.GroupParameter;
import com.landicorp.android.eptapi.emv.process.data.ICCLog;
import com.landicorp.android.eptapi.emv.process.data.RecCert;
import com.landicorp.android.eptapi.emv.process.data.RecordData;
import com.landicorp.android.eptapi.emv.process.data.SMCAPKey;
import com.landicorp.android.eptapi.emv.process.data.TransactionData;
import com.landicorp.android.eptapi.emv.process.data.VerifyOfflinePinResult;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BinaryData;
import com.landicorp.android.eptapi.utils.BooleanBuffer;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EMVKernel {
    private static final Logger logger = Logger.getLogger(EMVKernel.class);
    public static final int EMV_RESULT_NORMAL = 0;
    public static final int EMV_RESULT_BUSY = 60929;
    public static final int EMV_RESULT_NOAPP = 60930;
    public static final int EMV_RESULT_NOPUBKEY = 60931;
    public static final int EMV_RESULT_EXPIRY = 60932;
    public static final int EMV_RESULT_FLASHCARD = 60934;
    public static final int EMV_RESULT_STOP = 60935;
    public static final int EMV_RESULT_REPOWERICC = 60936;
    public static final int EMV_RESULT_REFUSESERVICE = 60937;
    public static final int EMV_RESULT_CARDLOCK = 60938;
    public static final int EMV_RESULT_APPLOCK = 60939;
    public static final int EMV_RESULT_EXCEED_CTLMT = 60940;
    public static final int EMV_RESULT_APDU_ERROR = 60941;
    public static final int EMV_RESULT_APDU_STATUS_ERROR = 60942;
    public static final int EMV_RESULT_ALL_FLASH_CARD = 60943;
    public static final int EMV_CONFIG_C0 = 192;
    public static final int EMV_CONFIG_C1 = 193;
    public static final int EMV_CONFIG_C2 = 194;
    public static final int EMV_CONFIG_C3 = 195;
    public static final int EMV_CONFIG_C4 = 196;
    public static final int EMV_CONFIG_C5 = 197;
    public static final int EMV_CONFIG_C6 = 198;
    public static final int EMV_KERNELID_UNIVERSAL = 0;
    public static final int EMV_KERNELID_EMV = 0;
    public static final int EMV_KERNELID_EMVCTLess = 1;
    public static final int EMV_KERNELID_MASTER = 2;
    public static final int EMV_KERNELID_VISA = 3;
    public static final int EMV_KERNELID_AMEX = 4;
    public static final int EMV_KERNELID_JCB = 5;
    public static final int EMV_KERNELID_DISCOVER = 6;
    public static final int EMV_KERNELID_PBOC = 7;
    public static final int EMV_KERNELID_PURE = 11;
    public static final int EMV_KERNELID_MIR = 12;
    public static final int EMV_KERNELID_RUPAY = 13;
    public static final int EMV_KERNELID_PAGO = 14;
    public static final int EMV_KERNELID_MB = 15;
    public static final int EMV_KERNELID_NSICC = 218;
    public static final int EMV_KERNELID_DEFINE = 222;
    public static final int EMV_FLOWTYPE_EMV = 1;
    public static final int EMV_FLOWTYPE_ECASH = 3;
    public static final int EMV_FLOWTYPE_QPBOC = 17;
    public static final int EMV_FLOWTYPE_PBOC_CTLESS = 18;
    public static final int EMV_FLOWTYPE_MSD = 19;
    public static final int EMV_FLOWTYPE_MSD_LEGACY = 20;
    public static final int EMV_FLOWTYPE_QVSDC = 33;
    public static final int EMV_FLOWTYPE_WAVE2 = 34;
    public static final int EMV_FLOWTYPE_M_CHIP = 49;
    public static final int EMV_FLOWTYPE_M_STRIPE = 50;
    public static final int EMV_FLOWTYPE_J_EMV = 51;
    public static final int EMV_FLOWTYPE_J_MAG = 52;
    public static final int EMV_FLOWTYPE_J_LEGACY = 53;
    public static final int EMV_FLOWTYPE_A_XP2_MS = 65;
    public static final int EMV_FLOWTYPE_A_XP2_EMV = 66;
    public static final int EMV_FLOWTYPE_A_XPM_MS = 67;
    public static final int EMV_FLOWTYPE_A_XPM_EMV = 68;
    public static final int EMV_FLOWTYPE_D_DPAS_MS = 81;
    public static final int EMV_FLOWTYPE_D_DPAS_EMV = 82;
    public static final int EMV_FLOWTYPE_D_ZIP = 83;
    public static final int EMV_FLOWTYPE_R_LEGACY = 97;
    public static final int EMV_FLOWTYPE_R_NONLEGACY = 98;
    public static final int EMV_FLOWTYPE_PAGO = 145;
    public static final int EMV_SERVETYPE_GOOD = 0;
    public static final int EMV_SERVETYPE_SERVICE = 0;
    public static final int EMV_SERVETYPE_CASH = 1;
    public static final int EMV_SERVETYPE_CASHBACK = 9;
    public static final int EMV_SERVETYPE_REFUND = 32;
    public static final int EMV_CVMFLAG_NOCVM = 0;
    public static final int EMV_CVMFLAG_OFFLINEPIN = 1;
    public static final int EMV_CVMFLAG_ONLINEPIN = 2;
    public static final int EMV_CVMFLAG_SIGNATURE = 3;
    public static final int EMV_CVMFLAG_OLPIN_SIGN = 4;
    public static final int EMV_CVMFLAG_CDV = 5;
    public static final int EMV_CVMFLAG_CCV = 6;
    public static final int EMV_CVMFLAG_CERTIFICATE = 17;
    public static final int EMV_CVMFLAG_ECASHPIN = 33;
    public static final int CERT_TYPE_IDENTITY_CARD = 0;
    public static final int CERT_TYPE_MILITARY_CARD = 1;
    public static final int CERT_TYPE_PASSPORT = 2;
    public static final int CERT_TYPE_ENTRY_PERMIT = 3;
    public static final int CERT_TYPE_TEMPORARY_IDCARD = 4;
    public static final int CERT_TYPE_OTHERS = 5;
    public static final int EMV_ACTION_AAC = 0;
    public static final int EMV_ACTION_TC = 1;
    public static final int EMV_ACTION_ARQC = 2;
    public static final int EMV_FLAG_ADD = 1;
    public static final int EMV_FLAG_DELETE = 2;
    public static final int EMV_FLAG_CLEAR = 3;
    public static final int DOL_TYPE_DDOL = 1;
    public static final int DOL_TYPE_TDOL = 2;
    public static final int DOL_TYPE_UDOL = 3;
    public static final int EMV_INS_SET_TORN = 161;
    public static final int EMV_INS_DEL_TORN = 209;
    public static final int EMV_INS_DISPLAY = 162;
    public static final int EMV_INS_TLVDATA = 163;
    public static final int EMV_INS_CLOSERF = 164;
    public static final int EMV_INS_DBLOG = 219;
    public static final int EMV_INS_GET_TORN = 177;
    public static final int EMV_INS_APPSELECT_DATA = 193;
    public static final int EMV_INS_SET_FAIL_WATER = 165;
    public static final int EMV_INS_DEL_FAIL_WATER = 166;
    public static final int EMV_MSGID_READCARD_OK = 23;
    public static final int EMV_MSGID_TRY_AGAIN = 33;
    public static final int EMV_MSGID_APPROVED = 3;
    public static final int EMV_MSGID_APPROVED_SIGN = 26;
    public static final int EMV_MSGID_DECLINED = 7;
    public static final int EMV_MSGID_ERR_OTH_CARD = 28;
    public static final int EMV_MSGID_INSERT_CARD = 29;
    public static final int EMV_MSGID_SEE_PHONE = 32;
    public static final int EMV_MSGID_AUTH_WAIT = 27;
    public static final int EMV_MSGID_CLEAR_DISPLAY = 30;
    public static final int EMV_MSGID_ICC_ACCOUNT = 31;
    public static final int EMV_MSGID_PCII = 241;
    public static final int EMV_MSGID_UNMATCH_PAN = 242;
    public static final int EMV_MSGID_READ_CARD_FAIL = 243;
    public static final int EMV_MSGID_ONLINE_ODA_RESULT = 244;
    public static final int EMV_L1_ERR_TIMEOUT = 1;
    public static final int EMV_L1_ERR_TRANSMISSION = 2;
    public static final int EMV_L1_ERR_PROTOCOL = 3;
    public static final int EMV_L2_ERR_ICC_DATA_MISS = 1;
    public static final int EMV_L2_ERR_CAM_FAILED = 2;
    public static final int EMV_L2_ERR_ICC_STATUS = 3;
    public static final int EMV_L2_ERR_PARSING = 4;
    public static final int EMV_L2_ERR_MAX_EXCEEDED = 5;
    public static final int EMV_L2_ERR_ICC_DATA = 6;
    public static final int EMV_L2_ERR_MAG_NOT_SUP = 7;
    public static final int EMV_L2_ERR_NO_PPSE = 8;
    public static final int EMV_L2_ERR_PPSE_FAULT = 9;
    public static final int EMV_L2_ERR_NO_CAND_AID = 10;
    public static final int EMV_L2_ERR_TERM_DATA = 15;
    public static final int EMV_L3_ERR_TIMEOUT = 1;
    public static final int EMV_L3_ERR_STOP = 2;
    public static final int EMV_L3_ERR_AMOOUNT = 3;
    public static final int EMV_FLAG_NORMAL = 0;
    public static final int EMV_FLAG_SHOW_CARD_AGAIN = 1;
    public static final int EMV_FLAG_ISS_SCRIPT_UPDATE = 2;
    public static final int EMV_FLAG_EXECUTE_CDCVM = 3;
    public static final int EMV_SIGNAL_ACT = 1;
    public static final int EMV_SIGNAL_NEXT = 2;
    public static final int EMV_SIGNAL_ACT_GPO = 17;
    public static final int EMV_SIGNAL_STOP = 240;
    public static final int EMV_SIGNAL_CLEAN = 192;
    public static final int DEBUG_MODE_AFTERTRANS = 1;
    public static final int DEBUG_MODE_REALTIME = 2;
    public static final int DEBUG_MODE_CLOSE = 3;
    private static final int REQ_INITIAL = 1;
    private static final int REQ_SETPARAMBASE = 2;
    private static final int REQ_SETPARAMPBOC = 3;
    private static final int REQ_SETPARAMVISA = 4;
    private static final int REQ_MANAGEAID = 5;
    private static final int REQ_UPDATECAINDEXLIST = 6;
    private static final int REQ_SETCAPUBKEY = 7;
    private static final int REQ_SETCAPUBKEY_SM = 8;
    private static final int REQ_MANAGERECCERT = 9;
    private static final int REQ_MANAGEDOL = 10;
    private static final int REQ_SIGNALIN = 11;
    private static final int REQ_GETTRANSDATA = 12;
    private static final int REQ_GETBALANCE = 13;
    private static final int REQ_GETDATAAPDU = 14;
    private static final int REQ_GETICCLOG = 15;
    private static final int REQ_GETECCLOG = 16;
    private static final int REQ_KERNELVERSION = 17;
    private static final int REQ_SETTLV = 18;
    private static final int REQ_SETTLVLIST = 19;
    private static final int REQ_GETTLV = 20;
    private static final int REQ_GETLOG = 21;
    private static final int REQ_SETCARDDRIVER = 22;
    private static final int REQ_SETVERIFYOFFLINEPINRESULT = 23;
    private static final int REQ_SIGNALINTLV = 24;
    private static final int REQ_CLEARCARDDRIVER = 25;
    private static final int REQ_SWITCHDEBUG = 26;
    private static final int REQ_TRANSFER = 101;
    private static final int REQ_SETEMVOPTIMIZATION = 102;
    private static final int REQ_MANAGECAPUBKEY = 103;
    private static final int REQ_MANAGESMCAPUBKEY = 104;
    private static final int REQ_PREPROCESS = 105;
    private static final int REQ_MANAGEAIDEX = 106;
    private static final int REQ_GETCHECKSUM = 107;
    private static final int CARD_TYPE_INSERT = 0;
    private static final int CARD_TYPE_RF = 1;
    private static final int CARD_TYPE_UNKNOWN = 9;
    private static final Map<String, EMVKernel> EMV_KERNELS = new ConcurrentHashMap<String, EMVKernel>();
    private String packageName;
    private int signalId = -1;
    private CpuCardDriver<?> cardDriver;
    private EMVEventHandler eventHandler;
    private EMVProcessListener processListener;
    private MasterController mMCtl = MasterController.getInstance();

    public static EMVKernel getInstance() {
        return EMVKernel.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EMVKernel getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, EMVKernel> map = EMV_KERNELS;
        synchronized (map) {
            if (EMV_KERNELS.containsKey(packageName)) {
                return EMV_KERNELS.get(packageName);
            }
            EMVKernel emvKernel = new EMVKernel(packageName);
            EMV_KERNELS.put(packageName, emvKernel);
            return emvKernel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, EMVKernel> map = EMV_KERNELS;
        synchronized (map) {
            if (EMV_KERNELS.containsKey(packageName)) {
                EMV_KERNELS.remove(packageName);
            }
        }
    }

    private EMVKernel(String packageName) {
        this.packageName = packageName;
    }

    public int initEMV() {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeInt(3);
            }
        };
        return invoker.invoke(1);
    }

    public int initEMV(final EMVConfig config, final int debugMode) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeInt(debugMode);
                if (config != null) {
                    data.writeByteArray(config.toBinary());
                }
            }
        };
        return invoker.invoke(1);
    }

    public int startEMV(String tlvData, CpuCardDriver<?> cardDriver, EMVEventHandler eventHandler) {
        Precondition.checkNotNull(eventHandler);
        this.cardDriver = cardDriver;
        this.eventHandler = eventHandler;
        this.processListener = new EMVProcessListener();
        this.mMCtl.uninstallListeners(this.packageName, this.processListener.getEventId());
        this.mMCtl.installListener(this.packageName, this.processListener);
        this.signalId = 24;
        return this.sendSignal(24, 1, TextUtils.isEmpty((CharSequence)tlvData) ? null : BytesUtil.hexString2Bytes(tlvData));
    }

    public int stopEMV() {
        return this.sendSignal(24, 240, null);
    }

    public void release() {
        this.mMCtl.uninstallListeners(this.packageName, this.processListener.getEventId());
        this.eventHandler = null;
        this.processListener = null;
    }

    public int manageAID(final int action, final int kernelId, final String aid, final int partSelect) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeInt(action);
                data.writeByteArray(BytesUtil.hexString2Bytes(aid));
                data.writeInt(partSelect);
                data.writeInt(kernelId);
            }
        };
        return invoker.invoke(5);
    }

    public int manageRecCert(final int action, final RecCert cert) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeInt(action);
                data.writeByteArray(cert == null ? null : cert.toBinary());
            }
        };
        return invoker.invoke(9);
    }

    public int setDOL(final int type, final String dol) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeInt(type);
                data.writeInt(1);
                data.writeByteArray(BytesUtil.hexString2Bytes(dol));
            }
        };
        return invoker.invoke(10);
    }

    public int getDOL(final int type, final BytesBuffer dol) {
        Precondition.checkNotNull(dol);
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeInt(type);
                data.writeInt(2);
            }

            @Override
            public void onResponse(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    dol.setData(resp.createByteArray());
                }
            }
        };
        return invoker.invoke(10);
    }

    public int setCAPubKey(final CAPKey capKey) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                if (capKey != null) {
                    data.writeByteArray(capKey.toBinary());
                }
            }
        };
        return invoker.invoke(7);
    }

    public int setCAPubKeySM(final SMCAPKey smCapKey) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                if (smCapKey != null) {
                    data.writeByteArray(smCapKey.toBinary());
                }
            }
        };
        return invoker.invoke(8);
    }

    public int updateCAIndexList(final String rid, final int[] indexList) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeByteArray(BytesUtil.hexString2Bytes(rid));
                if (indexList != null) {
                    byte[] indexs = new byte[indexList.length];
                    for (int i = 0; i < indexList.length; ++i) {
                        indexs[i] = (byte)indexList[i];
                    }
                    data.writeByteArray(indexs);
                } else {
                    data.writeByteArray(null);
                }
            }
        };
        return invoker.invoke(6);
    }

    public int signalInDriver(final CpuCardDriver<?> cardDriver) {
        Precondition.checkNotNull(cardDriver);
        this.cardDriver = cardDriver;
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                int cardType = 0;
                String deviceName = null;
                if (cardDriver instanceof InsertDriver) {
                    cardType = 0;
                    deviceName = ((InsertDriver)((Object)cardDriver)).getDeviceName();
                } else if (cardDriver instanceof RFDriver) {
                    cardType = 1;
                    deviceName = ((RFDriver)((Object)cardDriver)).getDeviceName();
                } else {
                    cardType = 9;
                    deviceName = "USERCARD";
                }
                data.writeInt(cardType);
                data.writeByteArray(StringUtil.getGBK(deviceName));
                data.writeInt(0);
            }
        };
        return invoker.invoke(22);
    }

    public int signalInNext(String tlvData) {
        return this.signalInTLV(2, tlvData);
    }

    public int signalInTLV(int signal, String tlvData) {
        if (this.signalId != 24) {
            throw new IllegalStateException("doesn't match the start mode!");
        }
        return this.sendSignal(24, signal, BytesUtil.hexString2Bytes(tlvData));
    }

    public int setTLV(final int kernelId, final String tag, final String value) {
        Precondition.checkNotEmpty(tag);
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel request) {
                request.writeInt(kernelId);
                request.writeByteArray(BytesUtil.hexString2Bytes(tag));
                request.writeByteArray(BytesUtil.hexString2Bytes(value));
            }
        };
        return invoker.invoke(18);
    }

    public int setTLVList(final int kernelId, final String tlvList) {
        Precondition.checkNotNull(tlvList);
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeInt(kernelId);
                data.writeByteArray(BytesUtil.hexString2Bytes(tlvList));
            }
        };
        return invoker.invoke(19);
    }

    public int getTLV(final String tag, final BytesBuffer value) {
        Precondition.checkNotNull(tag);
        Precondition.checkNotNull(value);
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeByteArray(BytesUtil.hexString2Bytes(tag));
            }

            @Override
            public void onResponse(Parcel resp) {
                if (value != null) {
                    value.setData(resp.createByteArray());
                }
            }
        };
        return invoker.invoke(20);
    }

    public int getBalance(final BytesBuffer balance) {
        Precondition.checkNotNull(balance);
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onResponse(Parcel resp) {
                if (balance != null) {
                    balance.setData(resp.createByteArray());
                }
            }
        };
        return invoker.invoke(13);
    }

    public int getDataAPDU(final int p1, final int p2, final BytesBuffer data) {
        Precondition.checkNotNull(data);
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel request) {
                request.writeInt(p1);
                request.writeInt(p2);
            }

            @Override
            public void onResponse(Parcel resp) {
                if (data != null) {
                    data.setData(resp.createByteArray());
                }
            }
        };
        return invoker.invoke(14);
    }

    public int getICCLog(final String aid, final List<ICCLog> logs) {
        Precondition.checkNotNull(aid);
        Precondition.checkNotNull(logs);
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel request) {
                request.writeByteArray(BytesUtil.hexString2Bytes(aid));
            }

            @Override
            public void onResponse(Parcel resp) {
                if (logs != null) {
                    EmvRequestExecutor.getList(resp, ICCLog.class, logs);
                }
            }
        };
        return invoker.invoke(15);
    }

    public int getECCLog(final String aid, final List<ECCLog> logs) {
        Precondition.checkNotNull(aid);
        Precondition.checkNotNull(logs);
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel request) {
                request.writeByteArray(BytesUtil.hexString2Bytes(aid));
            }

            @Override
            public void onResponse(Parcel resp) {
                if (logs != null) {
                    EmvRequestExecutor.getList(resp, ECCLog.class, logs);
                }
            }
        };
        return invoker.invoke(16);
    }

    public void switchDebug(final int debugMode) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeInt(debugMode);
            }
        };
        invoker.invoke(26);
    }

    public int transferEMV(final String appName) {
        Precondition.checkNotEmpty(appName);
        int result = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeByteArray(StringUtil.getGBK(appName));
            }
        }.invoke(101);
        if (result == 0 && this.processListener != null) {
            this.mMCtl.uninstallListener(this.packageName, this.processListener.getEventId());
        }
        return result;
    }

    public void updateCallback() {
        if (this.processListener != null) {
            this.mMCtl.installListener(this.packageName, this.processListener);
        }
    }

    public void setEMVOptimization(final boolean optimization, final BooleanBuffer isSupported) {
        new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeInt(optimization ? 1 : 0);
            }

            @Override
            public void onResponse(Parcel resp) {
                if (isSupported != null) {
                    if (resp.dataAvail() == 0) {
                        isSupported.setData(false);
                    } else {
                        isSupported.setData(resp.readInt() == 1);
                    }
                }
            }
        }.invoke(102);
    }

    public int manageCAPubKey(final int action, final CAPKey capKey) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(action);
                data.writeByteArray(capKey == null ? null : capKey.toBinary());
            }
        };
        return invoker.invoke(103);
    }

    public int manageSMCAPubKey(final int action, final SMCAPKey smcapKey, final GroupParameter groupParameter) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(action);
                data.writeByteArray(smcapKey == null ? null : smcapKey.toBinary());
                if (groupParameter != null) {
                    groupParameter.writeToParcel(data);
                }
            }
        };
        return invoker.invoke(104);
    }

    public int preProcess(final String tlvList, final BytesBuffer result) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(tlvList == null ? null : BytesUtil.hexString2Bytes(tlvList));
            }

            @Override
            public void onResponse(Parcel resp) {
                if (result != null) {
                    result.setData(resp.createByteArray());
                }
            }
        };
        return invoker.invoke(105);
    }

    public int manageAIDEx(final int action, final String aid, final String kid, final String tlvList) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(action);
                data.writeByteArray(aid == null ? null : BytesUtil.hexString2Bytes(aid));
                data.writeByteArray(kid == null ? null : BytesUtil.hexString2Bytes(kid));
                data.writeByteArray(tlvList == null ? null : BytesUtil.hexString2Bytes(tlvList));
            }
        };
        return invoker.invoke(106);
    }

    public int getCheckSum(final int flag, final StringBuilder checkSum) {
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(flag);
            }

            @Override
            public void onResponse(Parcel resp) {
                if (checkSum != null) {
                    checkSum.setLength(0);
                    checkSum.append(resp.readString());
                }
            }
        };
        return invoker.invoke(107);
    }

    private int sendSignal(int requestCode, final int action, final byte[] param) {
        RemoteInvoker executor = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                data.writeInt(action);
                if (action == 1) {
                    int cardType = 0;
                    String deviceName = "USERCARD";
                    if (EMVKernel.this.cardDriver instanceof InsertDriver) {
                        cardType = 0;
                        deviceName = ((InsertDriver)((Object)EMVKernel.this.cardDriver)).getDeviceName();
                    } else if (EMVKernel.this.cardDriver instanceof RFDriver) {
                        cardType = 1;
                        deviceName = ((RFDriver)((Object)EMVKernel.this.cardDriver)).getDeviceName();
                    } else {
                        cardType = 9;
                        deviceName = "";
                    }
                    data.writeInt(cardType);
                    data.writeByteArray(BytesUtil.toGBK(deviceName));
                }
                if (param != null) {
                    data.writeByteArray(param);
                }
            }
        };
        return executor.invoke(requestCode);
    }

    private void setVerifyOfflinePinResult(final VerifyOfflinePinResult result) {
        Precondition.checkNotNull(result);
        RemoteInvoker invoker = new RemoteInvoker(this.packageName){

            @Override
            public void onRequest(Parcel data) {
                result.writeToParcel(data);
            }
        };
        invoker.invoke(23);
    }

    private class EMVProcessListener
    extends RemoteListener {
        private static final int EVENT_WAIT_CARD = 1;
        private static final int EVENT_APP_SELECTION = 2;
        private static final int EVENT_FINAL_SELECT = 3;
        private static final int EVENT_READ_RECORD = 4;
        private static final int EVENT_CARD_HOLDER_VERIFY = 5;
        private static final int EVENT_ONLINE_PROCESS = 6;
        private static final int EVENT_END_PROCESS = 8;
        private static final int EVENT_SEND_OUT = 9;
        private static final int EVENT_OBTAIN = 10;
        private static final int EVENT_VERIFY_OFFLINE_PIN = 11;
        private static final int EVENT_TRANSFER_EMV = 12;

        public EMVProcessListener() {
            this.setRunOnIPCThread();
        }

        @Override
        public int getEventId() {
            return 1538;
        }

        @Override
        protected void onListened(Parcel data) {
            int eventType = data.readInt();
            logger.debug("## [EMVKernel] event  ->  " + this.getEventDescription(eventType) + " ##", new Object[0]);
            switch (eventType) {
                case 1: {
                    this.onWaitCard(data);
                    break;
                }
                case 2: {
                    this.onAppSelection(data);
                    break;
                }
                case 3: {
                    this.onFinalSelect(data);
                    break;
                }
                case 4: {
                    this.onReadRecord(data);
                    break;
                }
                case 5: {
                    this.onCardHolderVerify(data);
                    break;
                }
                case 6: {
                    this.onOnlineProcess(data);
                    break;
                }
                case 8: {
                    this.onEndProcess(data);
                    break;
                }
                case 9: {
                    this.onSendOut(data);
                    break;
                }
                case 10: {
                    this.onObtain(data);
                    break;
                }
                case 12: {
                    this.onTransferEMV(data);
                    break;
                }
                case 11: {
                    this.onVerifyOfflinePin(data);
                    break;
                }
                default: {
                    logger.error("unknown EMV event!", new Object[0]);
                }
            }
        }

        private String getEventDescription(int eventType) {
            switch (eventType) {
                case 1: {
                    return "EVENT_WAIT_CARD";
                }
                case 2: {
                    return "EVENT_APP_SELECTION";
                }
                case 3: {
                    return "EVENT_FINAL_SELECT";
                }
                case 4: {
                    return "EVENT_READ_RECORD";
                }
                case 5: {
                    return "EVENT_CARD_HOLDER_VERIFY";
                }
                case 6: {
                    return "EVENT_ONLINE_PROCESS";
                }
                case 8: {
                    return "EVENT_END_PROCESS";
                }
                case 9: {
                    return "EVENT_SEND_OUT";
                }
                case 10: {
                    return "EVENT_OBTAIN";
                }
                case 11: {
                    return "EVENT_VERIFY_OFFLINE_PIN";
                }
                case 12: {
                    return "EVENT_TRANSFER_EMV";
                }
            }
            return Integer.toHexString(eventType);
        }

        private void onWaitCard(Parcel data) {
            final int flag = data.readInt();
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (EMVKernel.this.eventHandler != null) {
                        EMVKernel.this.eventHandler.onWaitCard(flag);
                    }
                }
            });
        }

        private void onAppSelection(Parcel data) {
            final boolean reselect = data.readInt() != 0;
            final List<CandidateAIDInfo> candList = EmvRequestExecutor.getList(data, CandidateAIDInfo.class);
            final byte[] selectedAid = data.createByteArray();
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (EMVKernel.this.eventHandler != null) {
                        EMVKernel.this.eventHandler.onAppSelection(reselect, candList, selectedAid);
                    }
                }
            });
        }

        private void onFinalSelect(Parcel data) {
            final FinalSelectData finalData = this.load(data, new FinalSelectData());
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (EMVKernel.this.eventHandler != null) {
                        EMVKernel.this.eventHandler.onFinalSelect(finalData);
                    }
                }
            });
        }

        private void onReadRecord(Parcel data) {
            final RecordData recordData = this.load(data, new RecordData());
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (EMVKernel.this.eventHandler != null) {
                        EMVKernel.this.eventHandler.onReadRecord(recordData);
                    }
                }
            });
        }

        private void onCardHolderVerify(Parcel data) {
            final CVMData cvmData = this.load(data, new CVMData());
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (EMVKernel.this.eventHandler != null) {
                        EMVKernel.this.eventHandler.onCardHolderVerify(cvmData);
                    }
                }
            });
        }

        private void onOnlineProcess(Parcel data) {
            final TransactionData transactionData = this.load(data, new TransactionData());
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (EMVKernel.this.eventHandler != null) {
                        EMVKernel.this.eventHandler.onOnlineProcess(transactionData);
                    }
                }
            });
        }

        private void onEndProcess(Parcel data) {
            final int result = data.readInt();
            final TransactionData transactionData = this.load(data, new TransactionData());
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (EMVKernel.this.eventHandler != null) {
                        EMVKernel.this.eventHandler.onEndProcess(result, transactionData);
                    }
                }
            });
        }

        private void onSendOut(Parcel data) {
            final int ins = data.readInt();
            final byte[] outData = data.createByteArray();
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (EMVKernel.this.eventHandler != null) {
                        EMVKernel.this.eventHandler.onSendOut(ins, outData);
                    }
                }
            });
        }

        private void onObtain(Parcel data) {
            final int ins = data.readInt();
            final byte[] inData = data.createByteArray();
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (EMVKernel.this.eventHandler != null) {
                        EMVKernel.this.eventHandler.onObtain(ins, inData);
                    }
                }
            });
        }

        private void onVerifyOfflinePin(Parcel data) {
            int flag = data.readInt();
            byte[] random = data.createByteArray();
            CAPKey key = this.load(data, new CAPKey());
            logger.debug("## onVerifyOfflinePin | flag: " + flag + ", random: " + (random == null ? "null" : BytesUtil.bytes2HexString(random)), new Object[0]);
            if (EMVKernel.this.eventHandler != null) {
                logger.debug("# begin verify offline PIN #", new Object[0]);
                VerifyOfflinePinResult result = EMVKernel.this.eventHandler.onVerifyOfflinePin(flag, random.length == 0 ? null : random, key);
                logger.debug("# end verify offline PIN, result: " + result.getResult() + ", sw12: " + result.getSw1Sw2(), new Object[0]);
                int apduRet = result.getResult() & 0xFF;
                if (apduRet == 230 || apduRet == 231) {
                    result.setResult(0);
                }
                EMVKernel.this.setVerifyOfflinePinResult(result);
            }
        }

        private void onTransferEMV(Parcel data) {
            if (data.dataAvail() > 0) {
                EMVKernel.this.signalId = data.readInt();
                logger.debug("# onTransferEMV | signalId = " + EMVKernel.this.signalId, new Object[0]);
            }
        }

        @Override
        public void onCrash() {
            logger.error("MC service is down!!!", new Object[0]);
        }

        private <T extends BinaryData> T load(Parcel data, T b) {
            byte[] d = data.createByteArray();
            if (d.length == 0) {
                return null;
            }
            b.fromBinary(d);
            return b;
        }
    }

    private static abstract class RemoteInvoker {
        static final int ERROR_NONE = 0;
        static final int ERROR_FAIL = 1;
        private String packageName;

        public RemoteInvoker(String packageName) {
            this.packageName = packageName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int invoke(int code) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeInt(code);
                this.onRequest(data);
                MasterController.getInstance().request(this.packageName, 0xFF0003, data, reply);
                if (reply.dataAvail() == 0) {
                    logger.debug("# execute[" + code + " ] | no reply data!", new Object[0]);
                    int n = code == 101 ? 1 : 0;
                    return n;
                }
                int errorCode = reply.readInt();
                logger.debug("# execute[" + code + " ] | ret: " + errorCode, new Object[0]);
                if (errorCode != 0) {
                    int n = errorCode;
                    return n;
                }
                if (reply.dataAvail() > 0) {
                    this.onResponse(reply);
                }
                int n = errorCode;
                return n;
            }
            catch (RequestException e) {
                e.printStackTrace();
                int n = 1;
                return n;
            }
            finally {
                reply.recycle();
                data.recycle();
            }
        }

        protected void onRequest(Parcel data) {
        }

        protected void onResponse(Parcel resp) {
        }
    }
}

