/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.emv;

import android.os.Parcel;
import com.landicorp.android.eptapi.card.RFCpuCardDriver;
import com.landicorp.android.eptapi.device.factory.CardDriverFactory;
import com.landicorp.android.eptapi.emv.EmvRequestExecutor;
import com.landicorp.android.eptapi.emv.data.AIDInfo;
import com.landicorp.android.eptapi.emv.data.AmexRespData;
import com.landicorp.android.eptapi.emv.data.AppInitData;
import com.landicorp.android.eptapi.emv.data.CandidateAppInfo;
import com.landicorp.android.eptapi.emv.data.CardLogInfo;
import com.landicorp.android.eptapi.emv.data.CardTypeInfo;
import com.landicorp.android.eptapi.emv.data.CertificateInfo;
import com.landicorp.android.eptapi.emv.data.GMPublicKeyInfo;
import com.landicorp.android.eptapi.emv.data.PayPassRespData;
import com.landicorp.android.eptapi.emv.data.PublicKeyInfo;
import com.landicorp.android.eptapi.emv.data.StartAppData;
import com.landicorp.android.eptapi.emv.data.TerminalConfiguration;
import com.landicorp.android.eptapi.emv.data.TerminalFixData;
import com.landicorp.android.eptapi.emv.data.TransData;
import com.landicorp.android.eptapi.emv.process.data.VerifyOfflinePinResult;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BinaryData;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.CStruct;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EMVL2 {
    static final Logger logger = Logger.getLogger(EMVL2.class);
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAILED = 143;
    public static final int ERROR_PARAM = 139;
    public static final int CVM_ONLINE_PIN = 1;
    public static final int CVM_OFFLINE_PIN = 2;
    public static final int CVM_PBOC_CERT = 5;
    public static final int AARESULT_TC = 0;
    public static final int AARESULT_AAC = 1;
    public static final int AARESULT_ARQC = 2;
    public static final int AARESULT_AAR = 3;
    public static final int AARESULT_ARQC_TO_AAC = 4;
    public static final int ERROR_FCI_FMT = 48;
    public static final int ERROR_TAG = 50;
    public static final int ERROR_NUM_EXCEED = 51;
    public static final int ERROR_NOVALUE = 52;
    public static final int ERROR_NOSUCHDATA = 53;
    public static final int ERROR_TAGLEN = 54;
    public static final int ERROR_NOLIST = 64;
    public static final int ERROR_PART_SLT_FLG = 66;
    public static final int ERROR_CARD_BLOCKED = 67;
    public static final int ERROR_APP_BLOCKED = 68;
    public static final int ERROR_READ_AD = 69;
    public static final int ERROR_SWDIFF = 231;
    public static final int ERROR_SW6985 = 70;
    public static final int ERROR_PADDING = 71;
    public static final int ERROR_TLV_FMT = 72;
    public static final int ERROR_GPO_SW = 73;
    public static final int ERROR_READ_LAST = 113;
    public static final int ERROR_DATA_MISSING = 74;
    public static final int ERROR_GET_CAPK = 75;
    public static final int ERROR_ISSPK_REC = 76;
    public static final int ERROR_ICCPK_SSD_REC = 77;
    public static final int ERROR_INTERAUTH = 78;
    public static final int ERROR_GET_SDD = 79;
    public static final int ERROR_SDD_REC = 80;
    public static final int ERROR_CID_INCONSISTENT = 81;
    public static final int ERROR_SPECIAL_PROC = 82;
    public static final int AARESULT_PIN_TRYAGAIN = 83;
    public static final int AARESULT_PIN_CHALLENGEERR = 84;
    public static final int AARESULT_PIN_VERIFYERR = 85;
    public static final int ERROR_MUST_USE_AIDLST = 116;
    public static final int ERROR_INTERNATION_CARD = 209;
    public static final int ERROR_DDAVER = 210;
    public static final int ERROR_DELAY = 211;
    public static final int ERROR_CARDTIMEOUT = 212;
    public static final int ERROR_USCARD = 213;
    public static final int ERROR_DATA_DUP = 231;
    public static final int MAX_MODULUS_LEN = 248;
    public static final int ISS_SCRPT_RSLT_MAX = 60;
    public static final int MAX_PKFILE_NUM = 18;
    public static final int MAX_CERT_FILE = 100;
    public static final int AID_LIST_MAX_NUM = 128;
    public static final int CAND_LIST_MAX_NUM = 16;
    public static final int QPBOC_TC = 97;
    public static final int QPBOC_AAC = 96;
    public static final int QPBOC_ARQC = 98;
    public static final int QPBOC_CONT = 99;
    public static final int MSD_READ = 101;
    public static final int MSD_NOREAD = 102;
    public static final int WAVE2_OFFLINE = 103;
    public static final int WAVE2_ONLINE = 104;
    public static final int ERROR_DATE_OUT = 238;
    public static final int AARESULT_AAC_FILL = 33;
    public static final int AARESULT_ARQC_FILL = 34;
    public static final int KERNOPT_TRAN_RESTORE = 1;
    public static final int KERNOPT_PIN_BYPASS = 2;
    public static final int KERNOPT_CHK_KEYIDX = 4;
    public static final int KERNOPT_LOAD_LOG = 5;
    public static final int KERNOPT_DATE_CEN = 6;
    public static final int KERNOPT_AUTO_QPASS = 7;
    public static final int KERNOPT_LOG_FILE = 8;
    public static final int KERNOPT_SND_APPOUT = 11;
    public static final int KERNOPT_DZIP_AID_SELE = 17;
    public static final int KERNOPT_APPROVAL = 20;
    public static final int KERNOPT_SET_CID = 22;
    public static final int KERNOPT_NEW_OFFPIN = 23;
    public static final int KERNOPT_LOG = 52;
    public static final int KERNOPT_LOGCAT = 53;
    public static final int PAYPASS_MOD_MCHIP = 1;
    public static final int PAYPASS_MOD_MAG = 0;
    public static final int PAYPASS_RESULT_APPROVED = 1;
    public static final int PAYPASS_RESULT_DECLINED = 2;
    public static final int PAYPASS_RESULT_ONLINEREQ = 3;
    public static final int PAYPASS_RESULT_ENDAPP = 4;
    public static final int PAYPASS_RESULT_SELENEXT = 5;
    public static final int PAYPASS_RESULT_TRYOTHER = 6;
    public static final int PAYPASS_RESULT_TRYAGAIN = 7;
    public static final int PAYPASS_CVM_NOCVM = 0;
    public static final int PAYPASS_CVM_SIGN = 1;
    public static final int PAYPASS_CVM_ONLINEPIN = 2;
    public static final int PAYPASS_CVM_CONFCODE = 3;
    public static final int JCB_TRANMODE_UNDEFINE = 0;
    public static final int JCB_TRANMODE_EMV = 1;
    public static final int JCB_TRANMODE_MAG = 2;
    public static final int JCB_TRANMODE_LEGACY = 3;
    public static final int JCB_TRANRESULT_DECLINE = 0;
    public static final int JCB_TRANRESULT_APPROVED = 1;
    public static final int JCB_TRANRESULT_APPROVED_SIGN = 2;
    public static final int JCB_TRANRESULT_ONLINE = 3;
    public static final int JCB_TRANRESULT_ONLINE_TWOPRE = 4;
    public static final int JCB_TRANRESULT_ONLINE_HOLD = 5;
    public static final int JCB_TRANRESULT_ONLINE_PIN = 6;
    public static final int JCB_TRANRESULT_TEMINATE = 7;
    public static final int JCB_CVM_NOCVM = 0;
    public static final int JCB_CVM_SIGN = 1;
    public static final int JCB_CVM_ONLINEPIN = 2;
    public static final int JCB_CVM_CONFIRM = 3;
    public static final int JCB_CVM_NOT_APPLICAPLE = 4;
    public static final int AMEX_CVM_SIGN = 1;
    public static final int AMEX_CVM_ONLINEPIN = 2;
    public static final int AMEX_STATUS_DECLINE = 0;
    public static final int AMEX_STATUS_APPROVED = 1;
    public static final int AMEX_STATUS_ONLINE = 2;
    public static final int AMEX_STATUS_TERMINATE = 4;
    public static final int AMEX_STATUS_TRY_OTHER = 6;
    public static final int AMEX_STATUS_NOT_ALLOWED = 9;
    public static final int AMEX_STATUS_REQ_USE_OTHER = 13;
    public static final int AMEX_STATUS_TRY_AGAIN = 226;
    public static final int AMEX_TRANSMODE_XP2_MS = 0;
    public static final int AMEX_TRANSMODE_XP2_EMV = 1;
    public static final int AMEX_TRANSMODE_XPM_MS = 2;
    public static final int AMEX_TRANSMODE_XPM_EMV = 3;
    private static final int REQUEST_CODE = 0xFF0002;
    private static final int EMVL2_INIT_TERM_FIX_DATA = 1;
    private static final int EMVL2_INIT_CARD_APP_INFO = 2;
    private static final int EMVL2_START_APP_SELECTION = 3;
    private static final int EMVL2_SET_ACCOUNT_TYPE = 4;
    private static final int EMVL2_START_APPLICATION = 5;
    private static final int EMVL2_READ_APP_DATA = 6;
    private static final int EMVL2_OFFLINE_DATA_AUTH = 7;
    private static final int EMVL2_TERMINAL_RISK_MANAGE = 8;
    private static final int EMVL2_PROCESS_RESTRICT = 9;
    private static final int EMVL2_ACTION_ANALYSIS = 10;
    private static final int EMVL2_ONLINE_DATA_PROCESS = 11;
    private static final int EMVL2_SET_MCK_CONFIG = 12;
    private static final int EMVL2_SET_DATA = 13;
    private static final int EMVL2_GET_DATA = 14;
    private static final int EMVL2_APP_DATA = 15;
    private static final int EMVL2_SET_RAND_SELECTION_DATA = 17;
    private static final int EMVL2_SET_CERT_SN = 18;
    private static final int EMVL2_DEL_ALL_CA_PKEY_CERT_SN = 19;
    private static final int EMVL2_DEL_CA_PKEY = 20;
    private static final int EMVL2_DEL_ALL_TERMINAL_AID_LIST = 21;
    private static final int EMVL2_DEL_AID = 22;
    private static final int EMVL2_SET_TERM_AID_LIST = 23;
    private static final int EMVL2_SET_AID_LIST_ITEM = 24;
    private static final int EMVL2_GET_AID_LIST_AID_NUM = 25;
    private static final int EMVL2_GET_ALL_AID_INFO = 26;
    private static final int EMVL2_DEL_ALL_CA_PKEY = 27;
    private static final int EMVL2_GET_AID_BY_NO = 28;
    private static final int EMVL2_DEL_CA_PKEY_BY_RID_INDEX = 29;
    private static final int EMVL2_SET_CA_PKEY = 30;
    private static final int EMVL2_CHANGE_CA_PKEY_EXPDATE = 31;
    private static final int EMVL2_GET_CA_PKEY_NUM = 32;
    private static final int EMVL2_GET_CA_PKEY_BY_RID_INDEX = 33;
    private static final int EMVL2_GET_CA_PKEY_INFO = 34;
    private static final int EMVL2_GET_CA_PKEY_INFO_BY_NO = 35;
    private static final int EMVL2_GET_EMV_DEVICE_SN = 36;
    private static final int EMVL2_SET_DEBUG_SHOW = 37;
    private static final int EMVL2_SET_KERN_KIND = 38;
    private static final int EMVL2_GET_RAND_NUM = 39;
    private static final int EMVL2_GET_TRANS_DATA = 40;
    private static final int EMVL2_GET_EC_BALANCE = 41;
    private static final int EMVL2_CARD_HOLDER_VALIDATE = 42;
    private static final int EMVL2_FINAL_SELECT = 43;
    private static final int EMVL2_GET_PROC_OPTION = 44;
    private static final int EMVL2_GET_DATA_FROM_CARD = 45;
    private static final int EMVL2_GET_VISA_EMV_TAG = 46;
    private static final int EMVL2_GET_CVR = 47;
    private static final int EMVL2_GET_VALUE_FROM_TLV = 48;
    private static final int EMVL2_SET_KERNEL_OPTION = 49;
    private static final int EMVL2_GET_KERNEL_VERSION = 50;
    private static final int EMVL2_GET_KERNEL_LOG = 51;
    private static final int EMVL2_CARD_LOG_APP_SELECT = 52;
    private static final int EMVL2_GET_CARD_LOG_FORMAT = 53;
    private static final int EMVL2_GET_CARD_RECORD = 54;
    private static final int EMVL2_SET_QPASS_SAVE_NUM = 55;
    private static final int EMVL2_SET_QPASS_SAVE_TIME = 56;
    private static final int EMVL2_GET_QPASS_FILE_REC = 57;
    private static final int EMVL2_DEL_ALL_CA_PKEY_GM = 58;
    private static final int EMVL2_SET_CA_PKEY_GM = 59;
    private static final int EMVL2_GET_PROC_OPTION_BASE = 60;
    private static final int EMVL2_GET_QVSDC_CVM = 61;
    private static final int EMVL2_SET_BLACK_MATCH_RESULT = 62;
    private static final int EMVL2_GET_ERROR_CODE = 63;
    private static final int EMVL2_SET_VERIFY_OFFLINE_PIN_RESULT = 64;
    private static final int EMVL2_SET_READ_RECORD_OPTION = 65;
    private static final int EMVL2_IS_SUPPORT_ONLINE_ODA = 66;
    private static final int EMVL2_SET_DEV_HANDLE = 67;
    private static final int EMVL2_SET_DEFAULT_KID = 68;
    private static final int EMVL2_PAYPASS_OFFSET = 100;
    private static final int EMVL2_PAYPASS_APP_SELECT = 101;
    private static final int EMVL2_PAYPASS_FINAL_SELECT = 102;
    private static final int EMVL2_PAYPASS_GPO_PROCESS = 103;
    private static final int EMVL2_PAYPASS_GET_TRANS_MODE = 104;
    private static final int EMVL2_PAYPASS_READ_APP_DATA = 105;
    private static final int EMVL2_PAYPASS_COMP_CRYPT_CHECK_SUM_PPMAG = 106;
    private static final int EMVL2_PAYPASS_GAC_PROCESS = 107;
    private static final int EMVL2_PAYPASS_GET_TRANS_RESULT = 108;
    private static final int EMVL2_PAYPASS_CLEAR_TORN = 109;
    private static final int EMVL2_DISCOVER_OFFSET = 200;
    private static final int EMVL2_DISCOVER_FINAL_SELECT = 201;
    private static final int EMVL2_DISCOVER_GPO_PROCESS = 202;
    private static final int EMVL2_DISCOVER_GET_TRANS_MODE = 203;
    private static final int EMVL2_DISCOVER_READ_APP_DATA = 204;
    private static final int EMVL2_DISCOVER_CVM_PROC = 205;
    private static final int EMVL2_DISCOVER_PROCESS_RESTRICT = 206;
    private static final int EMVL2_DISCOVER_TERM_ACTION_ANALYSIS = 207;
    private static final int EMVL2_DISCOVER_ISS_CMD_PROC = 208;
    private static final int EMVL2_DISCOVER_OFFLINE_AUTH = 209;
    private static final int EMVL2_JCB_OFFSET = 300;
    private static final int EMVL2_JCB_FINAL_SELECT = 301;
    private static final int EMVL2_JCB_GPO_PROCESS = 302;
    private static final int EMVL2_JCB_GET_TRANS_MODE = 303;
    private static final int EMVL2_JCB_READ_APP_DATA = 304;
    private static final int EMVL2_JCB_GAC_PROCESS = 305;
    private static final int EMVL2_JCB_ONLINE_DATA_PROCESS = 306;
    private static final int EMVL2_AMEX_OFFSET = 400;
    private static final int EMVL2_AMEX_FINAL_SELECT = 401;
    private static final int EMVL2_AMEX_INIT_APP = 402;
    private static final int EMVL2_AMEX_READ_APP_DATA = 403;
    private static final int EMVL2_AMEX_GAC_PROCESS = 404;
    private static final int EMVL2_AMEX_GET_CVM_RESULT = 405;
    private static final int EMVL2_AMEX_GET_TRANS_RESULT = 406;
    private static final int EMVL2_TXN_OFFSET = 65280;
    private static final int EMVL2_TXN_QPBOC = 65281;
    private static final int EMVL2_TXN_QPBOC_ABORT = 65282;
    private static final int EMVL2_TXN_QPBOC_V2 = 65283;
    private static final int EMVL2_TXN_QPBOC_FAIL_REDO = 65284;
    private static Map<String, EMVL2> sInstances = new ConcurrentHashMap<String, EMVL2>();
    private PaypassEventHandler paypassHandler;
    private BlackEventHandler blackHandler;
    private VerifyOfflinePinHandler verifyOfflinePinHandler;
    private ShowPanEventHandler showPanEventHandler;
    private EMVL2EventListener eventListener;
    private String packageName;
    public static final int QPBOC_TXN_SALE = 1;
    public static final int QPBOC_TXN_QUERY = 2;

    public static EMVL2 getInstance() {
        return EMVL2.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EMVL2 getInstance(String packageName) {
        Map<String, EMVL2> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                return sInstances.get(packageName);
            }
            EMVL2 instance = new EMVL2();
            instance.packageName = packageName;
            sInstances.put(packageName, instance);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, EMVL2> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                sInstances.remove(packageName);
            }
        }
    }

    private EMVL2() {
    }

    public void setVerifyOfflinePinHandler(VerifyOfflinePinHandler handler) {
        this.verifyOfflinePinHandler = handler;
        this.installEventListener();
    }

    public void setBlackEventHandler(BlackEventHandler handler) {
        this.blackHandler = handler;
        this.installEventListener();
    }

    public void setShowPanEventHandler(ShowPanEventHandler handler) {
        this.showPanEventHandler = handler;
        this.installEventListener();
    }

    public void setPaypassEventHandler(PaypassEventHandler handler) {
        this.paypassHandler = handler;
        this.installEventListener();
    }

    private void installEventListener() {
        if (this.eventListener != null) {
            MasterController.getInstance().uninstallListener(this.packageName, this.eventListener);
        }
        this.eventListener = new EMVL2EventListener();
        MasterController.getInstance().installListener(this.packageName, this.eventListener);
    }

    public void clearEMVEventListener() {
        this.paypassHandler = null;
        this.verifyOfflinePinHandler = null;
        this.blackHandler = null;
        this.showPanEventHandler = null;
        if (this.eventListener != null) {
            MasterController.getInstance().uninstallListener(this.packageName, this.eventListener);
            this.eventListener = null;
        }
    }

    public int initTerminalFixData(final TerminalFixData data) {
        Precondition.checkNotNull(data);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                this.parcelBinaryData(request, data);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(1);
    }

    public int initApplicationInfo(final AppInitData data) {
        Precondition.checkNotNull(data);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                this.parcelBinaryData(request, data);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(2);
    }

    public int startAppSelection(final CardTypeInfo info, final int selectionType, final List<CandidateAppInfo> infoList) {
        Precondition.checkNotNull(info);
        Precondition.checkNotNull(infoList);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(info.getProtocol());
                request.writeInt(info.getCardType());
                request.writeInt(selectionType);
                if (info.getDeviceName() != null) {
                    request.writeByteArray(StringUtil.getGBK(info.getDeviceName()));
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
                3.getList(resp, CandidateAppInfo.class, infoList);
            }
        };
        return executer.execute(3);
    }

    public int setAccountType(final int accountType) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(accountType);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(4);
    }

    public int startApplication(final int aidNo, final StartAppData appData, final List<CandidateAppInfo> infoList) {
        Precondition.checkNotNull(appData);
        Precondition.checkNotNull(infoList);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(aidNo);
                this.parcelBinaryData(request, appData);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                5.getList(resp, CandidateAppInfo.class, infoList);
            }
        };
        return executer.execute(5);
    }

    public int readAppData(final BytesBuffer data) {
        Precondition.checkNotNull(data);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                data.setData(resp.createByteArray());
            }
        };
        return executer.execute(6);
    }

    public int offlineDataAuth() {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(7);
    }

    public int terminalRiskManage(final boolean isBlackCard, final int lastPanAmount, final RiskResult result) {
        Precondition.checkNotNull(result);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(isBlackCard ? 1 : 0);
                request.writeInt(lastPanAmount);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                result.setData((byte)resp.readInt());
            }
        };
        return executer.execute(8);
    }

    public int processRestrict(final ProcessRestrict result) {
        Precondition.checkNotNull(result);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                result.setData((byte)resp.readInt());
            }
        };
        return executer.execute(9);
    }

    public int actionAnalysis(final int command, final TransData data) {
        Precondition.checkNotNull(data);
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(command);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                10.readBinaryDataFromParcel(resp, data);
            }
        };
        return executor.execute(10);
    }

    public int onlineDataProcess(final byte[] issData, final TransData data) {
        Precondition.checkNotNull(data);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(issData);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                11.readBinaryDataFromParcel(resp, data);
            }
        };
        return executer.execute(11);
    }

    public int setMCKConfig(final TerminalConfiguration config) {
        Precondition.checkNotNull(config);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                this.parcelBinaryData(request, config);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(12);
    }

    public int setData(final byte[] tlvData) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(tlvData);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(13);
    }

    public int getData(final String tagName, final BytesBuffer data) {
        Precondition.checkNotNull(tagName);
        Precondition.checkNotNull(data);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(BytesUtil.hexString2Bytes(tagName));
            }

            @Override
            public void handleResponseData(Parcel resp) {
                data.setData(resp.createByteArray());
            }
        };
        return executer.execute(14);
    }

    public int getAppData(final String tagName, final BytesBuffer data) {
        Precondition.checkNotNull(tagName);
        Precondition.checkNotNull(data);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(BytesUtil.hexString2Bytes(tagName));
            }

            @Override
            public void handleResponseData(Parcel resp) {
                data.setData(resp.createByteArray());
            }
        };
        return executer.execute(15);
    }

    @Deprecated
    public int setRandSelectionData(final int lmt, final int percent, final int maxPercent) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(lmt);
                request.writeInt(percent);
                request.writeInt(maxPercent);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(17);
    }

    public int setRandSelectionData(final long lmt, final long percent, final long maxPercent) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeLong(lmt);
                request.writeLong(percent);
                request.writeLong(maxPercent);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(17);
    }

    public int setCertSn(final List<CertificateInfo> info) {
        Precondition.checkNotNull(info);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                this.parcelList(request, info);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(18);
    }

    public void delAllCAPKeyCertSn() {
        this.simpleRequest(19);
    }

    public int delCAPKeyCertSn(final byte[] certSn, final byte[] rid, final int index) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(certSn);
                request.writeByteArray(rid);
                request.writeInt(index);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(20);
    }

    public void delAllTerminalAIDList() {
        this.simpleRequest(21);
    }

    public int delAID(final byte[] aid) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(aid);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(22);
    }

    public int setTermAIDList(final List<AIDInfo> aidList) {
        Precondition.checkNotNull(aidList);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                this.parcelList(request, aidList);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(23);
    }

    public int setAidListItem(final byte[] aid, final int flag) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(aid);
                request.writeInt(flag);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(24);
    }

    public int getAidNum() {
        return this.simpleRequest(25);
    }

    public int getAllAidInfo(final List<AIDInfo> aidList) {
        Precondition.checkNotNull(aidList);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    23.getList(resp, AIDInfo.class, aidList);
                }
            }
        };
        return executer.execute(26);
    }

    public int getAidByNo(final int no, final AIDInfo aidInfo) {
        Precondition.checkNotNull(aidInfo);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(no);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    24.readBinaryDataFromParcel(resp, aidInfo);
                }
            }
        };
        return executer.execute(28);
    }

    public void delAllCAPKey() {
        this.simpleRequest(27);
    }

    public void delAllCAPKeyGM() {
        this.simpleRequest(58);
    }

    public int delCAPKeyByRidIndex(final byte[] rid, final int index) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(rid);
                request.writeInt(index);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(29);
    }

    public int setCAPKey(final PublicKeyInfo info) {
        Precondition.checkNotNull(info);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                this.parcelBinaryData(request, info);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(30);
    }

    public int setCAPKeyGM(final GMPublicKeyInfo info) {
        Precondition.checkNotNull(info);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                this.parcelBinaryData(request, info);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(59);
    }

    public int getqVSDCCVM(final int reqType) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(reqType);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(61);
    }

    public void setBlackMatchResult(final int match) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(match);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        executer.execute(62);
    }

    void setVerifyOfflinePinResult(final VerifyOfflinePinResult result) {
        Precondition.checkNotNull(result);
        RequestExecutor executer = new RequestExecutor(){

            @Override
            public void makeRequestData(Parcel request) {
                result.writeToParcel(request);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        executer.execute(64);
    }

    public void setReadRecordOption(final int option) {
        new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(option);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        }.execute(65);
    }

    public int isSupportOnlineODA() {
        return this.simpleRequest(66);
    }

    public int setDeviceHandle(final CardTypeInfo info) {
        Precondition.checkNotNull(info);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(info.getProtocol());
                request.writeInt(info.getCardType());
                if (info.getDeviceName() != null) {
                    request.writeByteArray(StringUtil.getGBK(info.getDeviceName()));
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(67);
    }

    public int setDefaultKid(final int kid, final byte[] aid) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(kid);
                request.writeByteArray(aid);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(68);
    }

    public int getErrorCode(final int mode, final BytesBuffer errCode) {
        Precondition.checkNotNull(errCode);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(mode);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    errCode.setData(resp.createByteArray());
                }
            }
        };
        return executer.execute(63);
    }

    public int changeCAPKeyExpDate(final byte[] rid, final int index, final byte[] expDate) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(rid);
                request.writeInt(index);
                request.writeByteArray(expDate);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(31);
    }

    public int getCAPKeyNum() {
        return this.simpleRequest(32);
    }

    public int getCAPKeyByRidIndex(final byte[] rid, final int index, final PublicKeyInfo publicKeyInfo) {
        Precondition.checkNotNull(publicKeyInfo);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(rid);
                request.writeInt(index);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    36.readBinaryDataFromParcel(resp, publicKeyInfo);
                }
            }
        };
        return executer.execute(33);
    }

    public int getCAPKeyInfo(final int num, final List<PublicKeyInfo> publicKeyInfo) {
        Precondition.checkNotNull(publicKeyInfo);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(num);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                37.getList(resp, PublicKeyInfo.class, publicKeyInfo);
            }
        };
        return executer.execute(34);
    }

    public int getCAPKeyInfoByNo(final int no, final PublicKeyInfo publicKeyInfo) {
        Precondition.checkNotNull(publicKeyInfo);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(no);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    38.readBinaryDataFromParcel(resp, publicKeyInfo);
                }
            }
        };
        return executer.execute(35);
    }

    public int getEMVDeviceSn(final StringBuffer sn) {
        Precondition.checkNotNull(sn);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                sn.setLength(0);
                sn.append(StringUtil.fromGBK(resp.createByteArray()));
            }
        };
        return executer.execute(36);
    }

    public int setDebugShow(final int flag) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(flag);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(37);
    }

    public void setKernKind(final int kind) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(kind);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        executer.execute(38);
    }

    public int getRandNum(final IntegerBuffer buffer) {
        Precondition.checkNotNull(buffer);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                buffer.setData(resp.readInt());
            }
        };
        return executer.execute(39);
    }

    public int getTransactionData(final TransData data) {
        Precondition.checkNotNull(data);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                43.readBinaryDataFromParcel(resp, data);
            }
        };
        return executer.execute(40);
    }

    public int getECBalance(final BytesBuffer balance) {
        Precondition.checkNotNull(balance);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                balance.setData(resp.createByteArray());
            }
        };
        return executer.execute(41);
    }

    public int cardHolderValidate(final int flag, final int command, final BytesBuffer data) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(flag);
                request.writeInt(command);
                if (data != null && data.getData() != null) {
                    request.writeByteArray(data.getData());
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (data != null) {
                    data.setData(resp.createByteArray());
                }
            }
        };
        return executer.execute(42);
    }

    public int finalSelect(final int aidNo, final List<CandidateAppInfo> infoList, final BytesBuffer dol) {
        Precondition.checkNotNull(infoList);
        Precondition.checkNotNull(dol);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(aidNo);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                46.getList(resp, CandidateAppInfo.class, infoList);
                if (dol != null) {
                    dol.setData(resp.createByteArray());
                }
            }
        };
        return executer.execute(43);
    }

    public int getProcOptionBase(final int aidNo, final List<CandidateAppInfo> infoList) {
        Precondition.checkNotNull(infoList);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(aidNo);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                47.getList(resp, CandidateAppInfo.class, infoList);
            }
        };
        return executer.execute(60);
    }

    public int getProcOption(final int aidNo, final StartAppData appData, final List<CandidateAppInfo> infoList) {
        Precondition.checkNotNull(appData);
        Precondition.checkNotNull(infoList);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(aidNo);
                this.parcelBinaryData(request, appData);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                48.getList(resp, CandidateAppInfo.class, infoList);
            }
        };
        return executer.execute(44);
    }

    public int getDataFromCard(final String tagName, final BytesBuffer data) {
        Precondition.checkNotNull(tagName);
        Precondition.checkNotNull(data);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(BytesUtil.hexString2Bytes(tagName));
            }

            @Override
            public void handleResponseData(Parcel resp) {
                data.setData(resp.createByteArray());
            }
        };
        return executer.execute(45);
    }

    public int getVISAEMVTag(final List<String> tagList, final int format, final BytesBuffer data) {
        Precondition.checkNotNull(tagList);
        Precondition.checkNotNull(data);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                this.parcelStringList(request, tagList);
                request.writeInt(format);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                data.setData(resp.createByteArray());
            }
        };
        return executer.execute(46);
    }

    public int getCVR(final BytesBuffer data) {
        Precondition.checkNotNull(data);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                data.setData(resp.createByteArray());
            }
        };
        return executer.execute(47);
    }

    public int getValueFromTLV(final byte[] tlvData, final String tagName, final BytesBuffer value) {
        Precondition.checkNotNull(value);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(tlvData);
                request.writeByteArray(BytesUtil.hexString2Bytes(tagName));
            }

            @Override
            public void handleResponseData(Parcel resp) {
                value.setData(resp.createByteArray());
            }
        };
        return executer.execute(48);
    }

    public int setKernelOption(final int option, final int value) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(option);
                request.writeInt(value);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(49);
    }

    public String getKernelVersion(final int type) {
        final StringBuffer version = new StringBuffer();
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(type);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                version.append(StringUtil.fromGBK(resp.createByteArray()));
            }
        };
        executer.execute(50);
        return version.length() == 0 ? null : version.toString();
    }

    public String getKernelLog() {
        final StringBuffer log = new StringBuffer();
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(0);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                log.append(StringUtil.fromGBK(resp.createByteArray()));
            }
        };
        executer.execute(51);
        return log.length() == 0 ? null : log.toString();
    }

    public int startCardLogAppSelection(final CardTypeInfo cardTypeInfo, final int selectionType, final List<CardLogInfo> infoList) {
        Precondition.checkNotNull(cardTypeInfo);
        Precondition.checkNotNull(infoList);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(cardTypeInfo.getProtocol());
                request.writeInt(cardTypeInfo.getCardType());
                request.writeInt(selectionType);
                if (cardTypeInfo.getDeviceName() != null) {
                    request.writeByteArray(StringUtil.getGBK(cardTypeInfo.getDeviceName()));
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    56.getList(resp, CardLogInfo.class, infoList);
                }
            }
        };
        return executer.execute(52);
    }

    public int getCardLogFormat(final BytesBuffer formatData) {
        Precondition.checkNotNull(formatData);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                formatData.setData(resp.createByteArray());
            }
        };
        return executer.execute(53);
    }

    public int getRecordData(final int recordNo, final int sfi, final BytesBuffer record) {
        Precondition.checkNotNull(record);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(recordNo);
                request.writeInt(sfi);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                record.setData(resp.createByteArray());
            }
        };
        return executer.execute(54);
    }

    public int setQuickPassSaveNum(final int num) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(num);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(55);
    }

    public int setQuickPassSaveTime(final int waitSec) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(waitSec);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(56);
    }

    public int getQuickPassFileRec(final int flag, final BytesBuffer record) {
        Precondition.checkNotNull(record);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(flag);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                record.setData(resp.createByteArray());
            }
        };
        return executer.execute(57);
    }

    public int epAppSelect(final CardTypeInfo info, final KernID kernId, final List<CandidateAppInfo> infoList) {
        Precondition.checkNotNull(info);
        Precondition.checkNotNull(kernId);
        Precondition.checkNotNull(infoList);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(info.getProtocol());
                request.writeInt(info.getCardType());
                if (info.getDeviceName() != null) {
                    request.writeByteArray(StringUtil.getGBK(info.getDeviceName()));
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    kernId.setValue(resp.readInt());
                    62.getList(resp, CandidateAppInfo.class, infoList);
                }
            }
        };
        return executer.execute(101);
    }

    public int epFinalSelect() {
        return this.simpleRequest(102);
    }

    public int epGPOProcess() {
        return this.simpleRequest(103);
    }

    public int epGetTransMode() {
        return this.simpleRequest(104);
    }

    public int epReadAppData() {
        return this.simpleRequest(105);
    }

    public int epCompCryptCheckSumPPMag(final BytesBuffer track1, final BytesBuffer track2) {
        Precondition.checkNotNull(track1);
        Precondition.checkNotNull(track2);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    track1.setData(resp.createByteArray());
                    track2.setData(resp.createByteArray());
                }
            }
        };
        return executer.execute(106);
    }

    public int epGACProcess(final int cmd) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(cmd);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(107);
    }

    public int epGetTransResult(final PayPassRespData ppResult) {
        Precondition.checkNotNull(ppResult);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    65.readBinaryDataFromParcel(resp, ppResult);
                }
            }
        };
        return executer.execute(108);
    }

    public int epClearTorn(final int cFlag) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(cFlag);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(109);
    }

    public int dpFinalSelect() {
        return this.simpleRequest(201);
    }

    public int dpGPOProcess(final int cOverFloor) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(cOverFloor);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(202);
    }

    public int dpGetTransMode() {
        return this.simpleRequest(203);
    }

    public int dpReadAppData() {
        return this.simpleRequest(204);
    }

    public int dpCVMProcess() {
        return this.simpleRequest(205);
    }

    public int dpProcessRestrict() {
        return this.simpleRequest(206);
    }

    public int dpTermActionAnalysis() {
        return this.simpleRequest(207);
    }

    public int dpIssCmdProcess(final byte[] issData) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(issData);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(208);
    }

    public int dpOfflineAuth() {
        return this.simpleRequest(209);
    }

    public int jcbFinalSelect() {
        return this.simpleRequest(301);
    }

    public int jcbGPOProcess() {
        return this.simpleRequest(302);
    }

    public int jcbGetTransMode() {
        return this.simpleRequest(303);
    }

    public int jcbReadAppData() {
        return this.simpleRequest(304);
    }

    public int jcbGACProcess(final int cmd) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(cmd);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(305);
    }

    public int jcbOnlineDataProcess(final byte[] issData) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(issData);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(306);
    }

    public int amexFinalSelect() {
        return this.simpleRequest(401);
    }

    public int amexInitApp() {
        return this.simpleRequest(402);
    }

    public int amexReadAppData() {
        return this.simpleRequest(403);
    }

    public int amexGACProcess(final int preAgain) {
        return new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(preAgain);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        }.execute(404);
    }

    public int amexGetCVMResult() {
        return this.simpleRequest(405);
    }

    public int amexGetTransResult(final AmexRespData transResult) {
        Precondition.checkNotNull(transResult);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    72.readBinaryDataFromParcel(resp, transResult);
                }
            }
        };
        return executer.execute(406);
    }

    private int simpleRequest(int code) {
        return new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        }.execute(code);
    }

    public void startQPBOC(final QPBOCData qPBOCdata, QPBOCProcessListener listener) {
        Precondition.checkNotNull(qPBOCdata);
        Precondition.checkNotNull(listener);
        listener.prepare();
        listener.setPackageName(this.packageName);
        MasterController.getInstance().installListener(this.packageName, listener);
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeByteArray("QPBOC_SERV_CLIENT".getBytes());
                qPBOCdata.writeToParcel(data);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        executer.execute(qPBOCdata instanceof QPBOCDataV2 ? 65283 : 65281);
    }

    public boolean abortQPBOC() {
        if (this.simpleRequest(65282) == 1) {
            MasterController.getInstance().uninstallListeners(this.packageName, 1537);
            return true;
        }
        return false;
    }

    public int qFailRedo() {
        return this.simpleRequest(65284);
    }

    private class EMVL2EventListener
    extends RemoteListener {
        static final int EVENT_PAYPASS_PROCESS_MSG = 1;
        static final int EVENT_PAYPASS_PROCESS_OUT = 2;
        static final int EVENT_BLACK_CALLBACK = 3;
        static final int EVENT_VERIFY_OFFLINE_PIN = 4;
        static final int EVENT_SHOW_PAN_IN_READ_RECORD = 5;

        public EMVL2EventListener() {
            this.setRunOnIPCThread();
        }

        @Override
        public int getEventId() {
            return 1539;
        }

        @Override
        protected void onListened(Parcel data) {
            int event = data.readInt();
            switch (event) {
                case 1: {
                    this.onPaypassProcessMsgEvent(data);
                    break;
                }
                case 2: {
                    this.onPaypassProcessOutEvent(data);
                    break;
                }
                case 3: {
                    this.onBlackMatchCallbackEvent(data);
                    break;
                }
                case 4: {
                    this.onVerifyOfflinePinEvent(data);
                    break;
                }
                case 5: {
                    this.onShowPanInReadRecord(data);
                }
            }
        }

        private void onPaypassProcessMsgEvent(Parcel data) {
            if (EMVL2.this.paypassHandler != null && data.dataAvail() > 0) {
                BytesBuffer urid = new BytesBuffer();
                urid.setData(data.createByteArray());
                EMVL2.this.paypassHandler.onProcessMsg(urid);
            }
        }

        private void onPaypassProcessOutEvent(Parcel data) {
            if (EMVL2.this.paypassHandler != null && data.dataAvail() > 0) {
                BytesBuffer urid = new BytesBuffer();
                urid.setData(data.createByteArray());
                EMVL2.this.paypassHandler.onProcessOut(urid);
            }
        }

        private void onBlackMatchCallbackEvent(Parcel data) {
            if (EMVL2.this.blackHandler != null) {
                String pan = BytesUtil.bytes2HexString(data.createByteArray());
                String sn = BytesUtil.bytes2HexString(data.createByteArray());
                logger.debug("/// onBlackCallback | pan = " + pan + ", sn = " + sn, new Object[0]);
                EMVL2.this.blackHandler.onBlackCallback(pan, sn);
            }
        }

        private void onVerifyOfflinePinEvent(Parcel data) {
            if (EMVL2.this.verifyOfflinePinHandler != null) {
                VerifyOfflinePinResult result = new VerifyOfflinePinResult();
                int flag = data.readInt();
                byte[] random = data.createByteArray();
                PublicKeyInfo key = this.load(data, new PublicKeyInfo());
                logger.debug("/// onVerifyOfflinePin | flag = " + flag, new Object[0]);
                if (random != null && key != null) {
                    logger.debug("/// onVerifyOfflinePin | random = " + BytesUtil.bytes2HexString(random), new Object[0]);
                    logger.debug("/// onVerifyOfflinePin | Rid: " + key.getRid() + ", index: " + key.getIndex() + ",  modLen: " + key.getModLen() + ", expLen: " + (key.getExpLen() & 0xFF), new Object[0]);
                }
                EMVL2.this.verifyOfflinePinHandler.onVerifyOfflinePin(flag, random.length == 0 ? null : random, key, result);
                EMVL2.this.setVerifyOfflinePinResult(result);
            }
        }

        private void onShowPanInReadRecord(Parcel data) {
            logger.debug("/// onShowPanInReadRecord", new Object[0]);
            if (EMVL2.this.showPanEventHandler != null) {
                EMVL2.this.showPanEventHandler.onShowPanInReadRecord();
            } else {
                EMVL2.this.setReadRecordOption(0);
            }
        }

        private <T extends BinaryData> T load(Parcel data, T b) {
            byte[] d = data.createByteArray();
            if (d.length == 0) {
                return null;
            }
            b.fromBinary(d);
            return b;
        }

        @Override
        public void onCrash() {
            MasterController.getInstance().uninstallListener(EMVL2.this.packageName, this);
        }
    }

    public static interface ShowPanEventHandler {
        public void onShowPanInReadRecord();
    }

    public static interface VerifyOfflinePinHandler {
        public void onVerifyOfflinePin(int var1, byte[] var2, PublicKeyInfo var3, VerifyOfflinePinResult var4);
    }

    public static interface BlackEventHandler {
        public void onBlackCallback(String var1, String var2);
    }

    public static interface PaypassEventHandler {
        public void onProcessMsg(BytesBuffer var1);

        public void onProcessOut(BytesBuffer var1);
    }

    abstract class RequestExecutor
    extends EmvRequestExecutor {
        public RequestExecutor() {
            super(0xFF0002);
        }

        public RequestExecutor(String packageName) {
            super(packageName, 0xFF0002);
        }
    }

    public static class QPBOCResultData {
        private Date dateTime;
        private String balance;
        private String pan;
        private String cardSn;
        private String track2;
        private String expiredDate;
        private int appIndex;
        private byte[] terminalCap;
        private String deviceName;
        private CandidateAppInfo candidateAppInfo;
        private String currency;
        private String secCurrency;

        public Date getDateTime() {
            return this.dateTime;
        }

        void setDateTime(Date dateTime) {
            this.dateTime = dateTime;
        }

        public String getPan() {
            return this.pan;
        }

        void setPan(String pan) {
            this.pan = pan;
        }

        public String getCardSn() {
            return this.cardSn;
        }

        void setCardSn(String cardSn) {
            this.cardSn = cardSn;
        }

        public String getTrack2() {
            return this.track2;
        }

        void setTrack2(String track2) {
            this.track2 = track2;
        }

        public String getExpiredDate() {
            return this.expiredDate;
        }

        void setExpiredDate(String expiredDate) {
            this.expiredDate = expiredDate;
        }

        public String getBalance() {
            return this.balance;
        }

        void setBalance(String balance) {
            this.balance = balance;
        }

        public int getAppIndex() {
            return this.appIndex;
        }

        void setAppIndex(int index) {
            this.appIndex = index;
        }

        public CandidateAppInfo getCandidateAppInfo() {
            return this.candidateAppInfo;
        }

        void setCandidateAppInfo(CandidateAppInfo candidateAppInfo) {
            this.candidateAppInfo = candidateAppInfo;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public String getSecondCurrency() {
            return this.secCurrency;
        }

        public void setSecondCurrency(String secCurrency) {
            this.secCurrency = secCurrency;
        }

        public byte[] getTerminalCap() {
            return this.terminalCap;
        }

        void setTerminalCap(byte[] terminalCap) {
            this.terminalCap = terminalCap;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }
    }

    public static class QPBOCDataV2
    extends QPBOCData {
        private String largeAmount = "";
        private List<AppParam> allAppParams = new ArrayList<AppParam>();

        @Override
        public void setAmount(int amount) {
            this.setAmount(String.format("%012d", amount));
        }

        public void setAmount(String amount) {
            if (amount.length() != 12) {
                throw new IllegalArgumentException("amount format error!");
            }
            for (int i = 0; i < amount.length(); ++i) {
                char c = amount.charAt(i);
                if (c >= '0' && c <= '9') continue;
                throw new IllegalArgumentException("amount format error!");
            }
            this.largeAmount = amount;
        }

        @Override
        void writeAmountToParcel(Parcel data) {
            data.writeByteArray(StringUtil.getGBK(this.largeAmount));
        }

        @Override
        void writeAppParamsToParcel(Parcel data) {
            data.writeInt(this.allAppParams.size());
            for (int i = 0; i < this.allAppParams.size(); ++i) {
                data.writeByteArray(this.allAppParams.get(i).toBinary());
            }
        }

        @Override
        @Deprecated
        public void addAppParam(QPBOCData.AppParam appParam) {
            throw new IllegalAccessError("not support");
        }

        public void addAppParam(AppParam appParam) {
            this.allAppParams.add(appParam);
        }

        public static class AppParam
        extends CStruct {
            private byte[] aid = new byte[16];
            private int aidLen;
            private byte partSelect;
            private byte[] ddol = new byte[252];
            private int ddolLen;
            private byte[] tdol = new byte[252];
            private int tdolLen;
            private byte tmType;
            private byte tmCap;
            private byte[] tmCapAd = new byte[3];
            private byte[] appVerNo = new byte[2];
            private byte[] lmt = new byte[13];
            private byte[] percent = new byte[3];
            private byte[] maxPercent = new byte[3];
            private byte[] tac_Denial = new byte[5];
            private byte[] tac_Online = new byte[5];
            private byte[] tac_Default = new byte[5];
            private byte[] floorLmt = new byte[13];
            private byte ecflag;
            private byte[] ecLimt = new byte[13];
            private byte[] rfFloorLmt = new byte[13];
            private byte[] rfLimt = new byte[13];
            private byte[] rfCVMLimt = new byte[13];
            private byte forceOnline;
            private byte[] flag9F66 = new byte[4];

            @Override
            protected String[] getDeclaredMemberNames() {
                return new String[]{"aid", "aidLen", "partSelect", "ddol", "ddolLen", "tdol", "tdolLen", "tmType", "tmCap", "tmCapAd", "appVerNo", "lmt", "percent", "maxPercent", "tac_Denial", "tac_Online", "tac_Default", "floorLmt", "ecflag", "ecLimt", "rfFloorLmt", "rfLimt", "rfCVMLimt", "forceOnline", "flag9F66"};
            }

            public void setAid(byte[] aid) {
                this.setBytes(this.aid, aid);
                this.aidLen = aid.length;
            }

            public void setPartSelect(byte partSelect) {
                this.partSelect = partSelect;
            }

            public void setDdol(byte[] ddol) {
                this.setBytes(this.ddol, ddol);
                this.ddolLen = ddol.length;
            }

            public void setTdol(byte[] tdol) {
                this.setBytes(this.tdol, tdol);
                this.tdolLen = tdol.length;
            }

            public void setTmType(byte tmType) {
                this.tmType = tmType;
            }

            public void setTmCap(byte tmCap) {
                this.tmCap = tmCap;
            }

            public void setTmCapAd(byte[] tmCapAd) {
                this.setBytes(this.tmCapAd, tmCapAd);
            }

            public void setAppVerNo(byte[] appVerNo) {
                this.setBytes(this.appVerNo, appVerNo);
            }

            public void setLmt(byte[] lmt) {
                this.setBytes(this.lmt, lmt);
            }

            public void setPercent(byte[] percent) {
                this.setBytes(this.percent, percent);
            }

            public void setMaxPercent(byte[] maxPercent) {
                this.setBytes(this.maxPercent, maxPercent);
            }

            public void setTac_Denial(byte[] tac_Denial) {
                this.setBytes(this.tac_Denial, tac_Denial);
            }

            public void setTac_Online(byte[] tac_Online) {
                this.setBytes(this.tac_Online, tac_Online);
            }

            public void setTac_Default(byte[] tac_Default) {
                this.setBytes(this.tac_Default, tac_Default);
            }

            public void setFloorLmt(byte[] floorLmt) {
                this.setBytes(this.floorLmt, floorLmt);
            }

            public void setEcflag(byte ecflag) {
                this.ecflag = ecflag;
            }

            public void setEcLimt(byte[] ecLimt) {
                this.setBytes(this.ecLimt, ecLimt);
            }

            public void setRfFloorLmt(byte[] rfFloorLmt) {
                this.setBytes(this.rfFloorLmt, rfFloorLmt);
            }

            public void setRfLimt(byte[] rfLimt) {
                this.setBytes(this.rfLimt, rfLimt);
            }

            public void setRfCVMLimt(byte[] rfCVMLimt) {
                this.setBytes(this.rfCVMLimt, rfCVMLimt);
            }

            public void setForceOnline(boolean forceOnline) {
                this.forceOnline = (byte)(forceOnline ? 1 : 0);
            }

            public void setFlagFor9F66(byte[] flag) {
                this.setBytes(this.flag9F66, flag);
            }
        }
    }

    public static class QPBOCData {
        private int txnType;
        private int kernKind;
        private int logMode;
        private int amount;
        private int terminalTransactionCategoryCode;
        private int riskManageCheckFlag;
        private int procCode;
        private boolean supportEC = true;
        private byte[] terminalCap;
        private List<PublicKeyInfo> allKeyInfo = new ArrayList<PublicKeyInfo>();
        private List<AppParam> allAppParams = new ArrayList<AppParam>();
        private TerminalFixData tmFixData;
        private String merId;
        private String terId;
        private String merName;
        private String deviceName = "USERCARD";
        private boolean supportGM;
        private List<GMPublicKeyInfo> gmPublicKey = new ArrayList<GMPublicKeyInfo>();
        private boolean forceRflimitCheck;

        void writeToParcel(Parcel data) {
            data.writeInt(this.txnType);
            data.writeInt(this.kernKind);
            data.writeInt(this.logMode);
            data.writeByteArray(this.tmFixData.toBinary());
            this.writeAppParamsToParcel(data);
            data.writeInt(this.allKeyInfo.size());
            for (int i = 0; i < this.allKeyInfo.size(); ++i) {
                data.writeByteArray(this.allKeyInfo.get(i).toBinary());
            }
            this.writeAmountToParcel(data);
            data.writeInt(this.procCode);
            byte[] emptyStr = new byte[]{};
            data.writeByteArray(this.merId == null ? emptyStr : StringUtil.getGBK(this.merId));
            data.writeByteArray(this.terId == null ? emptyStr : StringUtil.getGBK(this.terId));
            data.writeByteArray(this.merName == null ? emptyStr : StringUtil.getGBK(this.merName));
            data.writeInt(this.terminalTransactionCategoryCode);
            data.writeInt(this.riskManageCheckFlag);
            data.writeInt(this.supportEC ? 1 : 0);
            data.writeByteArray(this.terminalCap);
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(this.supportGM ? 1 : 0);
            this.writeGMPublicKeyToParcel(data);
            data.writeInt(this.forceRflimitCheck ? 1 : 0);
        }

        void writeAmountToParcel(Parcel data) {
            data.writeInt(this.amount);
        }

        void writeAppParamsToParcel(Parcel data) {
            data.writeInt(this.allAppParams.size());
            for (int i = 0; i < this.allAppParams.size(); ++i) {
                data.writeByteArray(this.allAppParams.get(i).toBinary());
            }
        }

        void writeGMPublicKeyToParcel(Parcel data) {
            data.writeInt(this.gmPublicKey.size());
            for (GMPublicKeyInfo pubKey : this.gmPublicKey) {
                data.writeByteArray(pubKey.toBinary());
            }
        }

        public void setKernKind(int kernKind) {
            this.kernKind = kernKind;
        }

        public void setLogMode(int logMode) {
            this.logMode = logMode;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public void setTerminalTransactionCategoryCode(int terminalTransactionCategoryCode) {
            this.terminalTransactionCategoryCode = terminalTransactionCategoryCode;
        }

        public void setRiskManageCheckFlag(int riskManageCheckFlag) {
            this.riskManageCheckFlag = riskManageCheckFlag;
        }

        public void setProcCode(int procCode) {
            this.procCode = procCode;
        }

        public void setSupportEC(boolean supportEC) {
            this.supportEC = supportEC;
        }

        public void setTerminalCap(byte[] terminalCap) {
            this.terminalCap = terminalCap;
        }

        public void addKeyInfo(PublicKeyInfo keyInfo) {
            this.allKeyInfo.add(keyInfo);
        }

        public void addAppParam(AppParam appParam) {
            this.allAppParams.add(appParam);
        }

        public void setTerminalFixData(TerminalFixData tmFixData) {
            this.tmFixData = tmFixData;
        }

        public void setMerchantId(String merchantId) {
            this.merId = merchantId;
        }

        public void setTerminalId(String terminalId) {
            this.terId = terminalId;
        }

        public void setMerchantName(String merchantName) {
            this.merName = merchantName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public void setSupportGM(boolean supportGM) {
            this.supportGM = supportGM;
        }

        public void addPublicKeyGM(GMPublicKeyInfo keyInfo) {
            this.gmPublicKey.add(keyInfo);
        }

        public void setForceRflimitCheck(boolean forceCheck) {
            this.forceRflimitCheck = forceCheck;
        }

        public static class AppParam
        extends CStruct {
            private byte[] aid = new byte[16];
            private int aidLen;
            private byte partSelect;
            private byte[] ddol = new byte[252];
            private int ddolLen;
            private byte[] tdol = new byte[252];
            private int tdolLen;
            private byte tmType;
            private byte tmCap;
            private byte[] tmCapAd = new byte[3];
            private byte[] appVerNo = new byte[2];
            private int lmt;
            private byte[] percent = new byte[3];
            private byte[] maxPercent = new byte[3];
            private byte[] tac_Denial = new byte[5];
            private byte[] tac_Online = new byte[5];
            private byte[] tac_Default = new byte[5];
            private int floorLmt;
            private byte ecflag;
            private int ecLimt;
            private int rfFloorLmt;
            private int rfLimt;
            private int rfCVMLimt;
            private byte forceOnline;
            private byte[] flag9F66 = new byte[4];

            @Override
            protected String[] getDeclaredMemberNames() {
                return new String[]{"aid", "aidLen", "partSelect", "ddol", "ddolLen", "tdol", "tdolLen", "tmType", "tmCap", "tmCapAd", "appVerNo", "lmt", "percent", "maxPercent", "tac_Denial", "tac_Online", "tac_Default", "floorLmt", "ecflag", "ecLimt", "rfFloorLmt", "rfLimt", "rfCVMLimt", "forceOnline", "flag9F66"};
            }

            public void setAid(byte[] aid) {
                this.setBytes(this.aid, aid);
                this.aidLen = aid.length;
            }

            public void setPartSelect(byte partSelect) {
                this.partSelect = partSelect;
            }

            public void setDdol(byte[] ddol) {
                this.setBytes(this.ddol, ddol);
                this.ddolLen = ddol.length;
            }

            public void setTdol(byte[] tdol) {
                this.setBytes(this.tdol, tdol);
                this.tdolLen = tdol.length;
            }

            public void setTmType(byte tmType) {
                this.tmType = tmType;
            }

            public void setTmCap(byte tmCap) {
                this.tmCap = tmCap;
            }

            public void setTmCapAd(byte[] tmCapAd) {
                this.setBytes(this.tmCapAd, tmCapAd);
            }

            public void setAppVerNo(byte[] appVerNo) {
                this.setBytes(this.appVerNo, appVerNo);
            }

            public void setLmt(int lmt) {
                this.lmt = lmt;
            }

            public void setPercent(byte[] percent) {
                this.setBytes(this.percent, percent);
            }

            public void setMaxPercent(byte[] maxPercent) {
                this.setBytes(this.maxPercent, maxPercent);
            }

            public void setTac_Denial(byte[] tac_Denial) {
                this.setBytes(this.tac_Denial, tac_Denial);
            }

            public void setTac_Online(byte[] tac_Online) {
                this.setBytes(this.tac_Online, tac_Online);
            }

            public void setTac_Default(byte[] tac_Default) {
                this.setBytes(this.tac_Default, tac_Default);
            }

            public void setFloorLmt(int floorLmt) {
                this.floorLmt = floorLmt;
            }

            public void setEcflag(byte ecflag) {
                this.ecflag = ecflag;
            }

            public void setEcLimt(int ecLimt) {
                this.ecLimt = ecLimt;
            }

            public void setRfFloorLmt(int rfFloorLmt) {
                this.rfFloorLmt = rfFloorLmt;
            }

            public void setRfLimt(int rfLimt) {
                this.rfLimt = rfLimt;
            }

            public void setRfCVMLimt(int rfCVMLimt) {
                this.rfCVMLimt = rfCVMLimt;
            }

            public void setForceOnline(boolean forceOnline) {
                this.forceOnline = (byte)(forceOnline ? 1 : 0);
            }

            public void setFlagFor9F66(byte[] flag) {
                this.setBytes(this.flag9F66, flag);
            }
        }
    }

    public static abstract class QPBOCProcessListener
    extends RemoteListener {
        private static final int RESP_ERROR = 1;
        private static final int RESP_RESULT = 2;
        private static final int PROCESS_SEARCH_CARD = 1;
        private static final int PROCESS_ACTIVITE_CARD = 2;
        private static final int PROCESS_INIT_TXN = 3;
        private static final int PROCESS_SELECT_APP = 4;
        private static final int PROCESS_START_APP = 5;
        private static final int PROCESS_START_APP_PART2 = 6;
        private static final int PROCESS_READ_APP_DATA = 7;
        private static final int PROCESS_OFFLINE_AUTH = 8;
        private static final int EXTEND_ERR_OFFSET = 65280;
        public static final int EXTEND_ERR_NOT_CPU_CARD = 65281;
        public static final int EXTEND_ERR_NO_AMOUNT = 65282;
        public static final int EXTEND_ERR_NO_APP = 65283;
        public static final int EXTEND_ERR_AMOUNT_EXCEED_ON_RFLIMIT_CHECK = 65284;
        public static final int EXTEND_ERR_NOT_ECCARD = 65285;
        public static final int EXTEND_ERR_UNSUPPORT_ECCARD = 65286;
        public static final int EXTEND_ERR_AMOUNT_EXCEED_ON_PURELYEC = 65287;
        public static final int EXTEND_ERR_SET_PARAM_ERROR = 65288;
        public static final int EXTEND_ERR_BALANCE_INSUFFICIENT = 65289;
        public static final int EXTEND_ERR_DATA_AUTH_FAIL = 65290;
        public static final int EXTEND_ERR_QPBOC_ERROR = 65291;
        public static final int EXTEND_ERR_LOAD_CAPKEY_FAIL = 65292;
        public static final int EXTEND_ERR_PURELYEC_REJECT = 65293;
        private static final String SERVER_NAME = "QPBOC_SERV_CLIENT";
        private String packageName;

        public QPBOCProcessListener() {
        }

        public QPBOCProcessListener(PausableHandler handler) {
            super(handler);
        }

        private void prepare() {
        }

        @Override
        public void setPackageName(String clientPkgName) {
            this.packageName = clientPkgName;
        }

        @Override
        public String getPackageName() {
            return this.packageName;
        }

        @Override
        public int getEventId() {
            return 1537;
        }

        @Override
        protected void onListened(Parcel data) {
            int responseType = data.readInt();
            switch (responseType) {
                case 1: {
                    MasterController.getInstance().uninstallListener(this.packageName, this);
                    this.onError(data);
                    break;
                }
                case 2: {
                    MasterController.getInstance().uninstallListener(this.packageName, this);
                    this.onResult(data);
                }
            }
        }

        private void onError(Parcel data) {
            int processFlag = data.readInt();
            int errorCode = data.readInt();
            int cardDriverType = data.readInt();
            String deviceName = "USERCARD";
            if (data.dataAvail() > 0) {
                deviceName = data.readString();
            }
            RFCpuCardDriver driver = null;
            if (cardDriverType == 2) {
                driver = (RFCpuCardDriver)CardDriverFactory.getInstance(this.packageName).createRFCardDriver(deviceName, "CPU");
            } else if (cardDriverType == 3) {
                driver = (RFCpuCardDriver)CardDriverFactory.getInstance(this.packageName).createRFCardDriver(deviceName, "PRO");
            }
            switch (processFlag) {
                case 1: {
                    this.onCardPassFail(errorCode, driver);
                    break;
                }
                case 2: {
                    this.onActivateFail(errorCode, driver);
                    break;
                }
                case 3: {
                    this.onTransactionInitFail(errorCode, driver);
                    break;
                }
                case 4: {
                    this.onAppSelectFail(errorCode, driver);
                    break;
                }
                case 5: 
                case 6: {
                    this.onAppStartFail(errorCode, driver);
                    break;
                }
                case 7: {
                    this.onAppDataReadFail(errorCode, driver);
                    break;
                }
                case 8: {
                    this.onOfflineAuthFail(errorCode, driver);
                }
            }
        }

        private void onResult(Parcel data) {
            int resultCode = data.readInt();
            if (data.dataAvail() > 0) {
                QPBOCResultData resultData = new QPBOCResultData();
                resultData.setDateTime(new Date((long)data.readInt() * 1000L));
                resultData.setAppIndex(data.readInt());
                resultData.setPan(data.readString());
                resultData.setCardSn(data.readString());
                resultData.setExpiredDate(data.readString());
                resultData.setTrack2(data.readString());
                resultData.setBalance(data.readString());
                CandidateAppInfo info = new CandidateAppInfo();
                info.fromBinary(data.createByteArray());
                resultData.setCandidateAppInfo(info);
                resultData.setTerminalCap(data.createByteArray());
                String deviceName = "USERCARD";
                if (data.dataAvail() > 0) {
                    deviceName = data.readString();
                }
                resultData.setDeviceName(deviceName);
                if (data.dataAvail() > 0) {
                    resultData.setCurrency(data.readString());
                    resultData.setSecondCurrency(data.readString());
                }
                this.onFinish(resultCode, resultData);
            } else {
                this.onFinish(resultCode, null);
            }
        }

        public abstract void onCardPassFail(int var1, RFCpuCardDriver var2);

        public abstract void onTransactionInitFail(int var1, RFCpuCardDriver var2);

        public abstract void onActivateFail(int var1, RFCpuCardDriver var2);

        public abstract void onAppSelectFail(int var1, RFCpuCardDriver var2);

        public abstract void onAppStartFail(int var1, RFCpuCardDriver var2);

        public abstract void onAppDataReadFail(int var1, RFCpuCardDriver var2);

        public abstract void onOfflineAuthFail(int var1, RFCpuCardDriver var2);

        public abstract void onFinish(int var1, QPBOCResultData var2);
    }

    public static class ProcessRestrict
    extends ByteSymbol {
        public boolean isVersionCheckFail() {
            return this.hasBit(0);
        }

        public boolean isAppUsageCheckFail() {
            return this.hasBit(1);
        }

        public boolean isDateCheckFail() {
            return this.hasBit(2);
        }

        public boolean isSuccess() {
            return !this.hasMask((byte)-32);
        }
    }

    public static class RiskResult
    extends ByteSymbol {
        public boolean isExceedAmountLimit() {
            return this.hasBit(0);
        }

        public boolean isRandomFail() {
            return this.hasBit(1);
        }

        public boolean isFrequentnessCheckFail() {
            return this.hasBit(2);
        }

        public boolean isSuccess() {
            return !this.hasMask((byte)-32);
        }
    }

    public static class ByteSymbol {
        private byte data;

        public void setData(byte data) {
            this.data = data;
        }

        public boolean hasMask(byte mask) {
            return (mask & this.data) == mask;
        }

        public boolean hasBit(int index) {
            return (1 << index & this.data) != 0;
        }
    }

    public static class KernID {
        private int kernId;

        public void setValue(int id) {
            this.kernId = id;
        }

        public int getValue() {
            return this.kernId;
        }

        public String toString() {
            switch (this.kernId) {
                case 2: {
                    return "Mastercard";
                }
                case 3: {
                    return "Visa";
                }
                case 4: {
                    return "AME";
                }
                case 5: {
                    return "JCB";
                }
                case 6: {
                    return "Discover";
                }
                case 7: {
                    return "UnionPay";
                }
            }
            return "Unknown";
        }
    }
}

